/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieveserver.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.net.InetSocketAddress;
import org.apache.james.managesieve.api.Session;
import org.apache.james.managesieve.api.SessionTerminatedException;
import org.apache.james.managesieve.transcode.ManageSieveProcessor;
import org.apache.james.managesieve.transcode.NotEnoughDataException;
import org.apache.james.managesieve.util.SettableSession;
import org.apache.james.managesieveserver.netty.ChannelManageSieveResponseWriter;
import org.apache.james.managesieveserver.netty.ManageSieveMDCContext;
import org.apache.james.managesieveserver.netty.NettyConstants;
import org.apache.james.protocols.api.ProxyInformation;
import org.apache.james.protocols.netty.Encryption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ManageSieveChannelUpstreamHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManageSieveChannelUpstreamHandler.class);
    static final String SSL_HANDLER = "sslHandler";
    private final ManageSieveProcessor manageSieveProcessor;
    private final Encryption secure;
    private final int maxLineLength;

    public ManageSieveChannelUpstreamHandler(ManageSieveProcessor manageSieveProcessor, Encryption secure, int maxLineLength) {
        this.manageSieveProcessor = manageSieveProcessor;
        this.secure = secure;
        this.maxLineLength = maxLineLength;
    }

    private boolean isSSL() {
        return this.secure != null && !this.secure.isStartTLS();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ChannelManageSieveResponseWriter attachment = (ChannelManageSieveResponseWriter)ctx.channel().attr(NettyConstants.RESPONSE_WRITER_ATTRIBUTE_KEY).get();
        try (Closeable closeable = ManageSieveMDCContext.from(ctx);){
            if (msg instanceof HAProxyMessage) {
                this.handleHAProxyMessage(ctx, (HAProxyMessage)msg);
                return;
            }
            String request = attachment.cumulate((String)msg);
            if (request.isEmpty() || request.startsWith("\r\n")) {
                return;
            }
            if (request.length() > this.maxLineLength) {
                throw new TooLongFrameException();
            }
            Session manageSieveSession = (Session)ctx.channel().attr(NettyConstants.SESSION_ATTRIBUTE_KEY).get();
            String responseString = this.manageSieveProcessor.handleRequest(manageSieveSession, request);
            attachment.resetCumulation();
            attachment.write(responseString);
            if (manageSieveSession.getState() == Session.State.SSL_NEGOCIATION) {
                this.turnSSLon(ctx.channel());
                manageSieveSession.setSslEnabled(true);
                manageSieveSession.setState(Session.State.UNAUTHENTICATED);
                attachment.stopDetectingCommandInjection();
            }
        }
        catch (NotEnoughDataException notEnoughDataException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHAProxyMessage(ChannelHandlerContext ctx, HAProxyMessage haproxyMsg) throws Exception {
        try {
            if (!haproxyMsg.proxiedProtocol().equals((Object)HAProxyProxiedProtocol.TCP4) && !haproxyMsg.proxiedProtocol().equals((Object)HAProxyProxiedProtocol.TCP6)) {
                throw new IllegalArgumentException("Only TCP4/TCP6 are supported when using PROXY protocol.");
            }
            ProxyInformation proxyInformation = new ProxyInformation(new InetSocketAddress(haproxyMsg.sourceAddress(), haproxyMsg.sourcePort()), new InetSocketAddress(haproxyMsg.destinationAddress(), haproxyMsg.destinationPort()));
            ctx.channel().attr(NettyConstants.PROXY_INFO).set((Object)proxyInformation);
            LOGGER.info("Connection from {} runs through {} proxy", (Object)haproxyMsg.sourceAddress(), (Object)haproxyMsg.destinationAddress());
            super.channelReadComplete(ctx);
        }
        finally {
            haproxyMsg.release();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        try (Closeable closeable = ManageSieveMDCContext.from(ctx);){
            LOGGER.warn("Error while processing ManageSieve request", cause);
            if (cause instanceof TooLongFrameException) {
                ((ChannelManageSieveResponseWriter)ctx.channel().attr(NettyConstants.RESPONSE_WRITER_ATTRIBUTE_KEY).get()).write("NO Maximum command line length exceeded");
            } else if (cause instanceof SessionTerminatedException) {
                ((ChannelManageSieveResponseWriter)ctx.channel().attr(NettyConstants.RESPONSE_WRITER_ATTRIBUTE_KEY).get()).write("OK channel is closing");
                this.logout(ctx);
            }
        }
    }

    private void logout(ChannelHandlerContext ctx) {
        ctx.channel().attr(NettyConstants.SESSION_ATTRIBUTE_KEY).getAndSet(null);
        Channel channel = ctx.channel();
        if (channel.isActive()) {
            channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        try (Closeable closeable = ManageSieveMDCContext.from(ctx);){
            InetSocketAddress address = (InetSocketAddress)ctx.channel().remoteAddress();
            LOGGER.info("Connection established from {}", (Object)address.getAddress().getHostAddress());
            SettableSession session = new SettableSession();
            if (this.isSSL()) {
                session.setSslEnabled(true);
            }
            ctx.channel().attr(NettyConstants.SESSION_ATTRIBUTE_KEY).set((Object)session);
            ctx.channel().attr(NettyConstants.RESPONSE_WRITER_ATTRIBUTE_KEY).set((Object)new ChannelManageSieveResponseWriter(ctx.channel()));
            super.channelActive(ctx);
            ((ChannelManageSieveResponseWriter)ctx.channel().attr(NettyConstants.RESPONSE_WRITER_ATTRIBUTE_KEY).get()).write(this.manageSieveProcessor.getAdvertisedCapabilities() + "OK\r\n");
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try (Closeable closeable = ManageSieveMDCContext.from(ctx);){
            InetSocketAddress address = (InetSocketAddress)ctx.channel().remoteAddress();
            LOGGER.info("Connection closed for {}", (Object)address.getAddress().getHostAddress());
            ctx.channel().attr(NettyConstants.SESSION_ATTRIBUTE_KEY).getAndSet(null);
            super.channelInactive(ctx);
        }
    }

    private void turnSSLon(Channel channel) {
        if (this.secure != null) {
            channel.config().setAutoRead(false);
            channel.pipeline().addFirst(SSL_HANDLER, (ChannelHandler)this.secure.sslHandler());
            channel.config().setAutoRead(true);
        }
    }
}

