/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.admin.beans;

import java.util.Date;
import javax.management.NotCompliantMBeanException;
import javax.servlet.http.HttpServletRequest;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.UserManager;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.ui.admin.SimpleAdminBean;

public class UserBean
extends SimpleAdminBean {
    public UserBean(Engine engine) throws NotCompliantMBeanException {
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }

    @Override
    public String doPost(Context context) {
        UserProfile p;
        HttpServletRequest request = context.getHttpRequest();
        Session session = context.getWikiSession();
        UserManager mgr = (UserManager)context.getEngine().getManager(UserManager.class);
        String loginid = request.getParameter("loginid");
        String loginname = request.getParameter("loginname");
        String fullname = request.getParameter("fullname");
        String password = request.getParameter("password");
        String password2 = request.getParameter("password2");
        String email = request.getParameter("email");
        if (request.getParameter("action").equalsIgnoreCase("remove")) {
            try {
                mgr.getUserDatabase().deleteByLoginName(loginid);
                session.addMessage("User profile " + loginid + " (" + fullname + ") has been deleted");
            }
            catch (NoSuchPrincipalException e) {
                session.addMessage("User profile has already been removed");
            }
            catch (WikiSecurityException e) {
                session.addMessage("Security problem: " + e);
            }
            return "";
        }
        if (password != null && !password.isEmpty() && !password.equals(password2)) {
            session.addMessage("Passwords do not match!");
            return "";
        }
        if (loginid.equals("--New--")) {
            p = mgr.getUserDatabase().newProfile();
            p.setCreated(new Date());
        } else {
            try {
                p = mgr.getUserDatabase().findByLoginName(loginid);
            }
            catch (NoSuchPrincipalException e) {
                session.addMessage("I could not find user profile " + loginid);
                return "";
            }
        }
        p.setEmail(email);
        p.setFullname(fullname);
        if (password != null && !password.isEmpty()) {
            p.setPassword(password);
        }
        p.setLoginName(loginname);
        try {
            mgr.getUserDatabase().save(p);
        }
        catch (WikiSecurityException e) {
            session.addMessage("Unable to save " + e.getMessage());
        }
        session.addMessage("User profile has been updated");
        return "";
    }

    @Override
    public String getTitle() {
        return "User administration";
    }

    @Override
    public int getType() {
        return 0;
    }
}

