/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ContextRuntimeException;
import org.apache.juneau.collections.AList;
import org.apache.juneau.collections.ASet;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.httppart.HttpPartCollectionFormat;
import org.apache.juneau.httppart.HttpPartDataType;
import org.apache.juneau.httppart.HttpPartFormat;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchemaBuilder;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ParamInfo;

public class HttpPartSchema {
    public static final HttpPartSchema DEFAULT = HttpPartSchema.create().allowEmptyValue(true).build();
    public static final HttpPartSchema T_BOOLEAN = HttpPartSchema.tBoolean().build();
    public static final HttpPartSchema T_FILE = HttpPartSchema.tFile().build();
    public static final HttpPartSchema T_INTEGER = HttpPartSchema.tInteger().build();
    public static final HttpPartSchema T_INT32 = HttpPartSchema.tInt32().build();
    public static final HttpPartSchema T_INT64 = HttpPartSchema.tInt64().build();
    public static final HttpPartSchema T_NONE = HttpPartSchema.tNone().build();
    public static final HttpPartSchema T_NUMBER = HttpPartSchema.tNumber().build();
    public static final HttpPartSchema T_FLOAT = HttpPartSchema.tFloat().build();
    public static final HttpPartSchema T_DOUBLE = HttpPartSchema.tDouble().build();
    public static final HttpPartSchema T_STRING = HttpPartSchema.tString().build();
    public static final HttpPartSchema T_BYTE = HttpPartSchema.tByte().build();
    public static final HttpPartSchema T_BINARY = HttpPartSchema.tBinary().build();
    public static final HttpPartSchema T_BINARY_SPACED = HttpPartSchema.tBinarySpaced().build();
    public static final HttpPartSchema T_DATE = HttpPartSchema.tDate().build();
    public static final HttpPartSchema T_DATETIME = HttpPartSchema.tDateTime().build();
    public static final HttpPartSchema T_UON = HttpPartSchema.tUon().build();
    public static final HttpPartSchema T_ARRAY = HttpPartSchema.tArray().build();
    public static final HttpPartSchema T_ARRAY_CSV = HttpPartSchema.tArrayCsv().build();
    public static final HttpPartSchema T_ARRAY_PIPES = HttpPartSchema.tArrayPipes().build();
    public static final HttpPartSchema T_ARRAY_SSV = HttpPartSchema.tArraySsv().build();
    public static final HttpPartSchema T_ARRAY_TSV = HttpPartSchema.tArrayTsv().build();
    public static final HttpPartSchema T_ARRAY_UON = HttpPartSchema.tArrayUon().build();
    public static final HttpPartSchema T_ARRAY_MULTI = HttpPartSchema.tArrayMulti().build();
    public static final HttpPartSchema T_OBJECT = HttpPartSchema.tObject().build();
    public static final HttpPartSchema T_OBJECT_CSV = HttpPartSchema.tObjectCsv().build();
    public static final HttpPartSchema T_OBJECT_PIPES = HttpPartSchema.tObjectPipes().build();
    public static final HttpPartSchema T_OBJECT_SSV = HttpPartSchema.tObjectSsv().build();
    public static final HttpPartSchema T_OBJECT_TSV = HttpPartSchema.tObjectTsv().build();
    public static final HttpPartSchema T_OBJECT_UON = HttpPartSchema.tObjectUon().build();
    final String name;
    final Set<Integer> codes;
    final String _default;
    final Set<String> _enum;
    final Map<String, HttpPartSchema> properties;
    final boolean allowEmptyValue;
    final boolean exclusiveMaximum;
    final boolean exclusiveMinimum;
    final boolean required;
    final boolean uniqueItems;
    final boolean skipIfEmpty;
    final HttpPartCollectionFormat collectionFormat;
    final HttpPartDataType type;
    final HttpPartFormat format;
    final Pattern pattern;
    final HttpPartSchema items;
    final HttpPartSchema additionalProperties;
    final Number maximum;
    final Number minimum;
    final Number multipleOf;
    final Long maxLength;
    final Long minLength;
    final Long maxItems;
    final Long minItems;
    final Long maxProperties;
    final Long minProperties;
    final Class<? extends HttpPartParser> parser;
    final Class<? extends HttpPartSerializer> serializer;
    final ClassMeta<?> parsedType;

    public static HttpPartSchemaBuilder create() {
        return new HttpPartSchemaBuilder();
    }

    public static HttpPartSchemaBuilder tBoolean() {
        return HttpPartSchema.create().tBoolean();
    }

    public static HttpPartSchemaBuilder tFile() {
        return HttpPartSchema.create().tFile();
    }

    public static HttpPartSchemaBuilder tInteger() {
        return HttpPartSchema.create().tInteger();
    }

    public static HttpPartSchemaBuilder tInt32() {
        return HttpPartSchema.create().tInteger().fInt32();
    }

    public static HttpPartSchemaBuilder tInt64() {
        return HttpPartSchema.create().tInteger().fInt64();
    }

    public static HttpPartSchemaBuilder tNone() {
        return HttpPartSchema.create().tNone();
    }

    public static HttpPartSchemaBuilder tNumber() {
        return HttpPartSchema.create().tNumber();
    }

    public static HttpPartSchemaBuilder tFloat() {
        return HttpPartSchema.create().tNumber().fFloat();
    }

    public static HttpPartSchemaBuilder tDouble() {
        return HttpPartSchema.create().tNumber().fDouble();
    }

    public static HttpPartSchemaBuilder tString() {
        return HttpPartSchema.create().tString();
    }

    public static HttpPartSchemaBuilder tByte() {
        return HttpPartSchema.create().tString().fByte();
    }

    public static HttpPartSchemaBuilder tBinary() {
        return HttpPartSchema.create().tString().fBinary();
    }

    public static HttpPartSchemaBuilder tBinarySpaced() {
        return HttpPartSchema.create().tString().fBinarySpaced();
    }

    public static HttpPartSchemaBuilder tDate() {
        return HttpPartSchema.create().tString().fDate();
    }

    public static HttpPartSchemaBuilder tDateTime() {
        return HttpPartSchema.create().tString().fDateTime();
    }

    public static HttpPartSchemaBuilder tUon() {
        return HttpPartSchema.create().tString().fUon();
    }

    public static HttpPartSchemaBuilder tArray() {
        return HttpPartSchema.create().tArray();
    }

    public static HttpPartSchemaBuilder tArray(HttpPartSchemaBuilder items) {
        return HttpPartSchema.create().tArray().items(items);
    }

    public static HttpPartSchemaBuilder tArrayCsv() {
        return HttpPartSchema.create().tArray().cfCsv();
    }

    public static HttpPartSchemaBuilder tArrayCsv(HttpPartSchemaBuilder items) {
        return HttpPartSchema.create().tArray().cfCsv().items(items);
    }

    public static HttpPartSchemaBuilder tArrayPipes() {
        return HttpPartSchema.create().tArray().cfPipes();
    }

    public static HttpPartSchemaBuilder tArrayPipes(HttpPartSchemaBuilder items) {
        return HttpPartSchema.create().tArray().cfPipes().items(items);
    }

    public static HttpPartSchemaBuilder tArraySsv() {
        return HttpPartSchema.create().tArray().cfSsv();
    }

    public static HttpPartSchemaBuilder tArraySsv(HttpPartSchemaBuilder items) {
        return HttpPartSchema.create().tArray().cfSsv().items(items);
    }

    public static HttpPartSchemaBuilder tArrayTsv() {
        return HttpPartSchema.create().tArray().cfTsv();
    }

    public static HttpPartSchemaBuilder tArrayTsv(HttpPartSchemaBuilder items) {
        return HttpPartSchema.create().tArray().cfTsv().items(items);
    }

    public static HttpPartSchemaBuilder tArrayUon() {
        return HttpPartSchema.create().tArray().cfUon();
    }

    public static HttpPartSchemaBuilder tArrayUon(HttpPartSchemaBuilder items) {
        return HttpPartSchema.create().tArray().cfUon().items(items);
    }

    public static HttpPartSchemaBuilder tArrayMulti() {
        return HttpPartSchema.create().tArray().cfMulti();
    }

    public static HttpPartSchemaBuilder tArrayMulti(HttpPartSchemaBuilder items) {
        return HttpPartSchema.create().tArray().cfMulti().items(items);
    }

    public static HttpPartSchemaBuilder tObject() {
        return HttpPartSchema.create().tObject();
    }

    public static HttpPartSchemaBuilder tObjectCsv() {
        return HttpPartSchema.create().tObject().cfCsv();
    }

    public static HttpPartSchemaBuilder tObjectPipes() {
        return HttpPartSchema.create().tObject().cfPipes();
    }

    public static HttpPartSchemaBuilder tObjectSsv() {
        return HttpPartSchema.create().tObject().cfSsv();
    }

    public static HttpPartSchemaBuilder tObjectTsv() {
        return HttpPartSchema.create().tObject().cfTsv();
    }

    public static HttpPartSchemaBuilder tObjectUon() {
        return HttpPartSchema.create().tObject().cfUon();
    }

    public static HttpPartSchema create(Class<? extends Annotation> c, ParamInfo mpi) {
        return HttpPartSchema.create().apply(c, mpi).build();
    }

    public static HttpPartSchema create(Class<? extends Annotation> c, Method m) {
        return HttpPartSchema.create().apply(c, m).build();
    }

    public static HttpPartSchema create(Class<? extends Annotation> c, Type t) {
        return HttpPartSchema.create().apply(c, t).build();
    }

    public static HttpPartSchemaBuilder create(String type) {
        return HttpPartSchema.create().type(type);
    }

    public static HttpPartSchemaBuilder create(String type, String format) {
        return HttpPartSchema.create().type(type).format(format);
    }

    public static HttpPartSchema create(Annotation a) {
        return HttpPartSchema.create().apply(a).build();
    }

    public static HttpPartSchema create(Annotation a, String defaultName) {
        return HttpPartSchema.create().name(defaultName).apply(a).build();
    }

    HttpPartSchema(HttpPartSchemaBuilder b) {
        this.name = b.name;
        this.codes = HttpPartSchema.copy(b.codes);
        this._default = b._default;
        this._enum = HttpPartSchema.copy(b._enum);
        this.properties = HttpPartSchema.build(b.properties, b.noValidate);
        this.allowEmptyValue = this.resolve(b.allowEmptyValue);
        this.exclusiveMaximum = this.resolve(b.exclusiveMaximum);
        this.exclusiveMinimum = this.resolve(b.exclusiveMinimum);
        this.required = this.resolve(b.required);
        this.uniqueItems = this.resolve(b.uniqueItems);
        this.skipIfEmpty = this.resolve(b.skipIfEmpty);
        this.collectionFormat = b.collectionFormat;
        this.type = b.type;
        this.format = b.format;
        this.pattern = b.pattern;
        this.items = HttpPartSchema.build(b.items, b.noValidate);
        this.additionalProperties = HttpPartSchema.build(b.additionalProperties, b.noValidate);
        this.maximum = b.maximum;
        this.minimum = b.minimum;
        this.multipleOf = b.multipleOf;
        this.maxItems = b.maxItems;
        this.maxLength = b.maxLength;
        this.maxProperties = b.maxProperties;
        this.minItems = b.minItems;
        this.minLength = b.minLength;
        this.minProperties = b.minProperties;
        this.parser = b.parser;
        this.serializer = b.serializer;
        Class parsedType = Object.class;
        if (this.type == HttpPartDataType.ARRAY) {
            if (this.items != null) {
                parsedType = Array.newInstance(this.items.parsedType.getInnerClass(), 0).getClass();
            }
        } else if (this.type == HttpPartDataType.BOOLEAN) {
            parsedType = Boolean.class;
        } else if (this.type == HttpPartDataType.INTEGER) {
            parsedType = this.format == HttpPartFormat.INT64 ? Long.class : Integer.class;
        } else if (this.type == HttpPartDataType.NUMBER) {
            parsedType = this.format == HttpPartFormat.DOUBLE ? Double.class : Float.class;
        } else if (this.type == HttpPartDataType.STRING) {
            parsedType = this.format == HttpPartFormat.BYTE || this.format == HttpPartFormat.BINARY || this.format == HttpPartFormat.BINARY_SPACED ? byte[].class : (this.format == HttpPartFormat.DATE || this.format == HttpPartFormat.DATE_TIME ? Calendar.class : String.class);
        }
        this.parsedType = BeanContext.DEFAULT.getClassMeta(parsedType);
        if (b.noValidate) {
            return;
        }
        ArrayList<String> errors = new ArrayList<String>();
        AList<String> notAllowed = AList.of();
        boolean invalidFormat = false;
        switch (this.type) {
            case STRING: {
                notAllowed.aif(this.properties != null, "properties");
                notAllowed.aif(this.additionalProperties != null, "additionalProperties");
                notAllowed.aif(this.exclusiveMaximum, "exclusiveMaximum");
                notAllowed.aif(this.exclusiveMinimum, "exclusiveMinimum");
                notAllowed.aif(this.uniqueItems, "uniqueItems");
                notAllowed.aif(this.collectionFormat != HttpPartCollectionFormat.NO_COLLECTION_FORMAT, "collectionFormat");
                notAllowed.aif(this.items != null, "items");
                notAllowed.aif(this.maximum != null, "maximum");
                notAllowed.aif(this.minimum != null, "minimum");
                notAllowed.aif(this.multipleOf != null, "multipleOf");
                notAllowed.aif(this.maxItems != null, "maxItems");
                notAllowed.aif(this.minItems != null, "minItems");
                notAllowed.aif(this.minProperties != null, "minProperties");
                invalidFormat = !this.format.isOneOf(HttpPartFormat.BYTE, HttpPartFormat.BINARY, HttpPartFormat.BINARY_SPACED, HttpPartFormat.DATE, HttpPartFormat.DATE_TIME, HttpPartFormat.PASSWORD, HttpPartFormat.UON, HttpPartFormat.NO_FORMAT);
                break;
            }
            case ARRAY: {
                notAllowed.aif(this.properties != null, "properties");
                notAllowed.aif(this.additionalProperties != null, "additionalProperties");
                notAllowed.aif(this.exclusiveMaximum, "exclusiveMaximum");
                notAllowed.aif(this.exclusiveMinimum, "exclusiveMinimum");
                notAllowed.aif(this.pattern != null, "pattern");
                notAllowed.aif(this.maximum != null, "maximum");
                notAllowed.aif(this.minimum != null, "minimum");
                notAllowed.aif(this.multipleOf != null, "multipleOf");
                notAllowed.aif(this.maxLength != null, "maxLength");
                notAllowed.aif(this.minLength != null, "minLength");
                notAllowed.aif(this.maxProperties != null, "maxProperties");
                notAllowed.aif(this.minProperties != null, "minProperties");
                invalidFormat = !this.format.isOneOf(HttpPartFormat.NO_FORMAT, HttpPartFormat.UON);
                break;
            }
            case BOOLEAN: {
                notAllowed.aif(!this._enum.isEmpty(), "_enum");
                notAllowed.aif(this.properties != null, "properties");
                notAllowed.aif(this.additionalProperties != null, "additionalProperties");
                notAllowed.aif(this.exclusiveMaximum, "exclusiveMaximum");
                notAllowed.aif(this.exclusiveMinimum, "exclusiveMinimum");
                notAllowed.aif(this.uniqueItems, "uniqueItems");
                notAllowed.aif(this.collectionFormat != HttpPartCollectionFormat.NO_COLLECTION_FORMAT, "collectionFormat");
                notAllowed.aif(this.pattern != null, "pattern");
                notAllowed.aif(this.items != null, "items");
                notAllowed.aif(this.maximum != null, "maximum");
                notAllowed.aif(this.minimum != null, "minimum");
                notAllowed.aif(this.multipleOf != null, "multipleOf");
                notAllowed.aif(this.maxItems != null, "maxItems");
                notAllowed.aif(this.maxLength != null, "maxLength");
                notAllowed.aif(this.maxProperties != null, "maxProperties");
                notAllowed.aif(this.minItems != null, "minItems");
                notAllowed.aif(this.minLength != null, "minLength");
                notAllowed.aif(this.minProperties != null, "minProperties");
                invalidFormat = !this.format.isOneOf(HttpPartFormat.NO_FORMAT, HttpPartFormat.UON);
                break;
            }
            case FILE: {
                break;
            }
            case INTEGER: {
                notAllowed.aif(this.properties != null, "properties");
                notAllowed.aif(this.additionalProperties != null, "additionalProperties");
                notAllowed.aif(this.uniqueItems, "uniqueItems");
                notAllowed.aif(this.collectionFormat != HttpPartCollectionFormat.NO_COLLECTION_FORMAT, "collectionFormat");
                notAllowed.aif(this.pattern != null, "pattern");
                notAllowed.aif(this.items != null, "items");
                notAllowed.aif(this.maxItems != null, "maxItems");
                notAllowed.aif(this.maxLength != null, "maxLength");
                notAllowed.aif(this.maxProperties != null, "maxProperties");
                notAllowed.aif(this.minItems != null, "minItems");
                notAllowed.aif(this.minLength != null, "minLength");
                notAllowed.aif(this.minProperties != null, "minProperties");
                invalidFormat = !this.format.isOneOf(HttpPartFormat.NO_FORMAT, HttpPartFormat.UON, HttpPartFormat.INT32, HttpPartFormat.INT64);
                break;
            }
            case NUMBER: {
                notAllowed.aif(this.properties != null, "properties");
                notAllowed.aif(this.additionalProperties != null, "additionalProperties");
                notAllowed.aif(this.uniqueItems, "uniqueItems");
                notAllowed.aif(this.collectionFormat != HttpPartCollectionFormat.NO_COLLECTION_FORMAT, "collectionFormat");
                notAllowed.aif(this.pattern != null, "pattern");
                notAllowed.aif(this.items != null, "items");
                notAllowed.aif(this.maxItems != null, "maxItems");
                notAllowed.aif(this.maxLength != null, "maxLength");
                notAllowed.aif(this.maxProperties != null, "maxProperties");
                notAllowed.aif(this.minItems != null, "minItems");
                notAllowed.aif(this.minLength != null, "minLength");
                notAllowed.aif(this.minProperties != null, "minProperties");
                invalidFormat = !this.format.isOneOf(HttpPartFormat.NO_FORMAT, HttpPartFormat.UON, HttpPartFormat.FLOAT, HttpPartFormat.DOUBLE);
                break;
            }
            case OBJECT: {
                notAllowed.aif(this.exclusiveMaximum, "exclusiveMaximum");
                notAllowed.aif(this.exclusiveMinimum, "exclusiveMinimum");
                notAllowed.aif(this.uniqueItems, "uniqueItems");
                notAllowed.aif(this.pattern != null, "pattern");
                notAllowed.aif(this.items != null, "items");
                notAllowed.aif(this.maximum != null, "maximum");
                notAllowed.aif(this.minimum != null, "minimum");
                notAllowed.aif(this.multipleOf != null, "multipleOf");
                notAllowed.aif(this.maxItems != null, "maxItems");
                notAllowed.aif(this.maxLength != null, "maxLength");
                notAllowed.aif(this.minItems != null, "minItems");
                notAllowed.aif(this.minLength != null, "minLength");
                invalidFormat = !this.format.isOneOf(HttpPartFormat.NO_FORMAT);
                break;
            }
        }
        if (!notAllowed.isEmpty()) {
            errors.add("Attributes not allow for type='" + (Object)((Object)this.type) + "': " + StringUtils.join(notAllowed, ","));
        }
        if (invalidFormat) {
            errors.add("Invalid format for type='" + (Object)((Object)this.type) + "': '" + (Object)((Object)this.format) + "'");
        }
        if (this.exclusiveMaximum && this.maximum == null) {
            errors.add("Cannot specify exclusiveMaximum with maximum.");
        }
        if (this.exclusiveMinimum && this.minimum == null) {
            errors.add("Cannot specify exclusiveMinimum with minimum.");
        }
        if (this.required && this._default != null) {
            errors.add("Cannot specify a default value on a required value.");
        }
        if (this.minLength != null && this.maxLength != null && this.maxLength < this.minLength) {
            errors.add("maxLength cannot be less than minLength.");
        }
        if (this.minimum != null && this.maximum != null && this.maximum.doubleValue() < this.minimum.doubleValue()) {
            errors.add("maximum cannot be less than minimum.");
        }
        if (this.minItems != null && this.maxItems != null && this.maxItems < this.minItems) {
            errors.add("maxItems cannot be less than minItems.");
        }
        if (this.minProperties != null && this.maxProperties != null && this.maxProperties < this.minProperties) {
            errors.add("maxProperties cannot be less than minProperties.");
        }
        if (this.minLength != null && this.minLength < 0L) {
            errors.add("minLength cannot be less than zero.");
        }
        if (this.maxLength != null && this.maxLength < 0L) {
            errors.add("maxLength cannot be less than zero.");
        }
        if (this.minItems != null && this.minItems < 0L) {
            errors.add("minItems cannot be less than zero.");
        }
        if (this.maxItems != null && this.maxItems < 0L) {
            errors.add("maxItems cannot be less than zero.");
        }
        if (this.minProperties != null && this.minProperties < 0L) {
            errors.add("minProperties cannot be less than zero.");
        }
        if (this.maxProperties != null && this.maxProperties < 0L) {
            errors.add("maxProperties cannot be less than zero.");
        }
        if (this.type == HttpPartDataType.ARRAY && this.items != null && this.items.getType() == HttpPartDataType.OBJECT && this.format != HttpPartFormat.UON && this.format != HttpPartFormat.NO_FORMAT) {
            errors.add("Cannot define an array of objects unless array format is 'uon'.");
        }
        if (!errors.isEmpty()) {
            throw new ContextRuntimeException("Schema specification errors: \n\t" + StringUtils.join(errors, "\n\t"), new Object[0]);
        }
    }

    public ClassMeta<?> getParsedType() {
        return this.parsedType;
    }

    public String getName() {
        return this.name;
    }

    public Set<Integer> getCodes() {
        return this.codes;
    }

    public Set<Integer> getCodes(Integer def) {
        return this.codes.isEmpty() ? Collections.singleton(def) : this.codes;
    }

    public Integer getCode(Integer def) {
        return this.codes.isEmpty() ? def : this.codes.iterator().next();
    }

    public HttpPartDataType getType() {
        return this.type;
    }

    public HttpPartDataType getType(ClassMeta<?> cm) {
        if (this.type != HttpPartDataType.NO_TYPE) {
            return this.type;
        }
        if (cm.isTemporal() || cm.isDateOrCalendar()) {
            return HttpPartDataType.STRING;
        }
        if (cm.isNumber()) {
            if (cm.isDecimal()) {
                return HttpPartDataType.NUMBER;
            }
            return HttpPartDataType.INTEGER;
        }
        if (cm.isBoolean()) {
            return HttpPartDataType.BOOLEAN;
        }
        if (cm.isMapOrBean()) {
            return HttpPartDataType.OBJECT;
        }
        if (cm.isCollectionOrArray()) {
            return HttpPartDataType.ARRAY;
        }
        return HttpPartDataType.STRING;
    }

    public String getDefault() {
        return this._default;
    }

    public HttpPartCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    public HttpPartFormat getFormat() {
        return this.format;
    }

    public HttpPartFormat getFormat(ClassMeta<?> cm) {
        if (this.format != HttpPartFormat.NO_FORMAT) {
            return this.format;
        }
        if (cm.isNumber()) {
            if (cm.isDecimal()) {
                if (cm.isDouble()) {
                    return HttpPartFormat.DOUBLE;
                }
                return HttpPartFormat.FLOAT;
            }
            if (cm.isLong()) {
                return HttpPartFormat.INT64;
            }
            return HttpPartFormat.INT32;
        }
        return this.format;
    }

    public HttpPartSchema getItems() {
        return this.items;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Long getMaxLength() {
        return this.maxLength;
    }

    public Long getMinLength() {
        return this.minLength;
    }

    public Long getMaxItems() {
        return this.maxItems;
    }

    public Long getMinItems() {
        return this.minItems;
    }

    public Long getMaxProperties() {
        return this.maxProperties;
    }

    public Long getMinProperties() {
        return this.minProperties;
    }

    public boolean isExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public boolean isExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public boolean isUniqueItems() {
        return this.uniqueItems;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isSkipIfEmpty() {
        return this.skipIfEmpty;
    }

    public boolean isAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public Set<String> getEnum() {
        return this._enum;
    }

    public Class<? extends HttpPartParser> getParser() {
        return this.parser;
    }

    public Class<? extends HttpPartSerializer> getSerializer() {
        return this.serializer;
    }

    public String validateInput(String in) throws SchemaValidationException {
        if (!this.isValidRequired(in)) {
            throw new SchemaValidationException("No value specified.", new Object[0]);
        }
        if (in != null) {
            if (!this.isValidAllowEmpty(in)) {
                throw new SchemaValidationException("Empty value not allowed.", new Object[0]);
            }
            if (!this.isValidPattern(in)) {
                throw new SchemaValidationException("Value does not match expected pattern.  Must match pattern: {0}", this.pattern.pattern());
            }
            if (!this.isValidEnum(in)) {
                throw new SchemaValidationException("Value does not match one of the expected values.  Must be one of the following: {0}", this._enum);
            }
            if (!this.isValidMaxLength(in)) {
                throw new SchemaValidationException("Maximum length of value exceeded.", new Object[0]);
            }
            if (!this.isValidMinLength(in)) {
                throw new SchemaValidationException("Minimum length of value not met.", new Object[0]);
            }
        }
        return in;
    }

    public <T> T validateOutput(T o, BeanContext bc) throws SchemaValidationException {
        if (o == null) {
            if (!this.isValidRequired(o)) {
                throw new SchemaValidationException("Required value not provided.", new Object[0]);
            }
            return o;
        }
        ClassMeta<T> cm = bc.getClassMetaForObject(o);
        switch (this.getType(cm)) {
            case ARRAY: {
                if (cm.isArray()) {
                    if (!this.isValidMinItems(o)) {
                        throw new SchemaValidationException("Minimum number of items not met.", new Object[0]);
                    }
                    if (!this.isValidMaxItems(o)) {
                        throw new SchemaValidationException("Maximum number of items exceeded.", new Object[0]);
                    }
                    if (!this.isValidUniqueItems(o)) {
                        throw new SchemaValidationException("Duplicate items not allowed.", new Object[0]);
                    }
                    HttpPartSchema items = this.getItems();
                    if (items == null) break;
                    for (int i = 0; i < Array.getLength(o); ++i) {
                        items.validateOutput(Array.get(o, i), bc);
                    }
                } else {
                    if (!cm.isCollection()) break;
                    Collection c = (Collection)o;
                    if (!this.isValidMinItems(c)) {
                        throw new SchemaValidationException("Minimum number of items not met.", new Object[0]);
                    }
                    if (!this.isValidMaxItems(c)) {
                        throw new SchemaValidationException("Maximum number of items exceeded.", new Object[0]);
                    }
                    if (!this.isValidUniqueItems(c)) {
                        throw new SchemaValidationException("Duplicate items not allowed.", new Object[0]);
                    }
                    HttpPartSchema items = this.getItems();
                    if (items == null) break;
                    for (Object o2 : c) {
                        items.validateOutput(o2, bc);
                    }
                }
                break;
            }
            case INTEGER: {
                if (!cm.isNumber()) break;
                Number n = (Number)o;
                if (!this.isValidMinimum(n)) {
                    throw new SchemaValidationException("Minimum value not met.", new Object[0]);
                }
                if (!this.isValidMaximum(n)) {
                    throw new SchemaValidationException("Maximum value exceeded.", new Object[0]);
                }
                if (this.isValidMultipleOf(n)) break;
                throw new SchemaValidationException("Multiple-of not met.", new Object[0]);
            }
            case NUMBER: {
                if (!cm.isNumber()) break;
                Number n = (Number)o;
                if (!this.isValidMinimum(n)) {
                    throw new SchemaValidationException("Minimum value not met.", new Object[0]);
                }
                if (!this.isValidMaximum(n)) {
                    throw new SchemaValidationException("Maximum value exceeded.", new Object[0]);
                }
                if (this.isValidMultipleOf(n)) break;
                throw new SchemaValidationException("Multiple-of not met.", new Object[0]);
            }
            case OBJECT: {
                if (cm.isMapOrBean()) {
                    BeanMap<T> m;
                    BeanMap<T> beanMap = m = cm.isMap() ? (BeanMap<T>)o : bc.createSession().toBeanMap(o);
                    if (!this.isValidMinProperties(m)) {
                        throw new SchemaValidationException("Minimum number of properties not met.", new Object[0]);
                    }
                    if (!this.isValidMaxProperties(m)) {
                        throw new SchemaValidationException("Maximum number of properties exceeded.", new Object[0]);
                    }
                    for (Map.Entry e : m.entrySet()) {
                        String key = e.getKey().toString();
                        HttpPartSchema s2 = this.getProperty(key);
                        if (s2 == null) continue;
                        s2.validateOutput(e.getValue(), bc);
                    }
                    break;
                }
                if (!cm.isBean()) break;
                break;
            }
        }
        return o;
    }

    private boolean isValidRequired(Object x) {
        return x != null || !this.required;
    }

    private boolean isValidMinProperties(Map<?, ?> x) {
        return this.minProperties == null || (long)x.size() >= this.minProperties;
    }

    private boolean isValidMaxProperties(Map<?, ?> x) {
        return this.maxProperties == null || (long)x.size() <= this.maxProperties;
    }

    private boolean isValidMinimum(Number x) {
        if (x instanceof Integer || x instanceof AtomicInteger) {
            return this.minimum == null || x.intValue() > this.minimum.intValue() || x.intValue() == this.minimum.intValue() && !this.exclusiveMinimum;
        }
        if (x instanceof Short || x instanceof Byte) {
            return this.minimum == null || x.shortValue() > this.minimum.shortValue() || x.intValue() == this.minimum.shortValue() && !this.exclusiveMinimum;
        }
        if (x instanceof Long || x instanceof AtomicLong || x instanceof BigInteger) {
            return this.minimum == null || x.longValue() > this.minimum.longValue() || (long)x.intValue() == this.minimum.longValue() && !this.exclusiveMinimum;
        }
        if (x instanceof Float) {
            return this.minimum == null || x.floatValue() > this.minimum.floatValue() || x.floatValue() == this.minimum.floatValue() && !this.exclusiveMinimum;
        }
        if (x instanceof Double || x instanceof BigDecimal) {
            return this.minimum == null || x.doubleValue() > this.minimum.doubleValue() || x.doubleValue() == this.minimum.doubleValue() && !this.exclusiveMinimum;
        }
        return true;
    }

    private boolean isValidMaximum(Number x) {
        if (x instanceof Integer || x instanceof AtomicInteger) {
            return this.maximum == null || x.intValue() < this.maximum.intValue() || x.intValue() == this.maximum.intValue() && !this.exclusiveMaximum;
        }
        if (x instanceof Short || x instanceof Byte) {
            return this.maximum == null || x.shortValue() < this.maximum.shortValue() || x.intValue() == this.maximum.shortValue() && !this.exclusiveMaximum;
        }
        if (x instanceof Long || x instanceof AtomicLong || x instanceof BigInteger) {
            return this.maximum == null || x.longValue() < this.maximum.longValue() || (long)x.intValue() == this.maximum.longValue() && !this.exclusiveMaximum;
        }
        if (x instanceof Float) {
            return this.maximum == null || x.floatValue() < this.maximum.floatValue() || x.floatValue() == this.maximum.floatValue() && !this.exclusiveMaximum;
        }
        if (x instanceof Double || x instanceof BigDecimal) {
            return this.maximum == null || x.doubleValue() < this.maximum.doubleValue() || x.doubleValue() == this.maximum.doubleValue() && !this.exclusiveMaximum;
        }
        return true;
    }

    private boolean isValidMultipleOf(Number x) {
        if (x instanceof Integer || x instanceof AtomicInteger) {
            return this.multipleOf == null || x.intValue() % this.multipleOf.intValue() == 0;
        }
        if (x instanceof Short || x instanceof Byte) {
            return this.multipleOf == null || x.shortValue() % this.multipleOf.shortValue() == 0;
        }
        if (x instanceof Long || x instanceof AtomicLong || x instanceof BigInteger) {
            return this.multipleOf == null || x.longValue() % this.multipleOf.longValue() == 0L;
        }
        if (x instanceof Float) {
            return this.multipleOf == null || x.floatValue() % this.multipleOf.floatValue() == 0.0f;
        }
        if (x instanceof Double || x instanceof BigDecimal) {
            return this.multipleOf == null || x.doubleValue() % this.multipleOf.doubleValue() == 0.0;
        }
        return true;
    }

    private boolean isValidAllowEmpty(String x) {
        return this.allowEmptyValue || StringUtils.isNotEmpty(x);
    }

    private boolean isValidPattern(String x) {
        return this.pattern == null || this.pattern.matcher(x).matches();
    }

    private boolean isValidEnum(String x) {
        return this._enum.isEmpty() || this._enum.contains(x);
    }

    private boolean isValidMinLength(String x) {
        return this.minLength == null || (long)x.length() >= this.minLength;
    }

    private boolean isValidMaxLength(String x) {
        return this.maxLength == null || (long)x.length() <= this.maxLength;
    }

    private boolean isValidMinItems(Object x) {
        return this.minItems == null || (long)Array.getLength(x) >= this.minItems;
    }

    private boolean isValidMaxItems(Object x) {
        return this.maxItems == null || (long)Array.getLength(x) <= this.maxItems;
    }

    private boolean isValidUniqueItems(Object x) {
        if (this.uniqueItems) {
            HashSet<Object> s = new HashSet<Object>();
            for (int i = 0; i < Array.getLength(x); ++i) {
                Object o = Array.get(x, i);
                if (s.add(o)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidMinItems(Collection<?> x) {
        return this.minItems == null || (long)x.size() >= this.minItems;
    }

    private boolean isValidMaxItems(Collection<?> x) {
        return this.maxItems == null || (long)x.size() <= this.maxItems;
    }

    private boolean isValidUniqueItems(Collection<?> x) {
        if (this.uniqueItems && !(x instanceof Set)) {
            HashSet s = new HashSet();
            for (Object o : x) {
                if (s.add(o)) continue;
                return false;
            }
        }
        return true;
    }

    public HttpPartSchema getProperty(String name) {
        HttpPartSchema schema;
        if (this.properties != null && (schema = this.properties.get(name)) != null) {
            return schema;
        }
        return this.additionalProperties;
    }

    public boolean hasProperties() {
        return this.properties != null || this.additionalProperties != null;
    }

    private static <T> Set<T> copy(Set<T> in) {
        return in == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<T>(in));
    }

    private static Map<String, HttpPartSchema> build(Map<String, Object> in, boolean noValidate) {
        if (in == null) {
            return null;
        }
        LinkedHashMap<String, HttpPartSchema> m = new LinkedHashMap<String, HttpPartSchema>();
        for (Map.Entry<String, Object> e : in.entrySet()) {
            Object v = e.getValue();
            m.put(e.getKey(), HttpPartSchema.build(v, noValidate));
        }
        return Collections.unmodifiableMap(m);
    }

    private static HttpPartSchema build(Object in, boolean noValidate) {
        if (in == null) {
            return null;
        }
        if (in instanceof HttpPartSchema) {
            return (HttpPartSchema)in;
        }
        return ((HttpPartSchemaBuilder)in).noValidate(noValidate).build();
    }

    private boolean resolve(Boolean b) {
        return b == null ? false : b;
    }

    static final Set<String> toSet(String[] ... s) {
        for (Object[] objectArray : s) {
            if (objectArray == null || objectArray.length <= 0) continue;
            return HttpPartSchema.toSet(StringUtils.joinnl(objectArray));
        }
        return null;
    }

    static final Set<String> toSet(String s) {
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        ASet<String> set = ASet.of(new String[0]);
        try {
            for (Object o : StringUtils.parseListOrCdl(s)) {
                set.add(o.toString());
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return set;
    }

    static final Number toNumber(String ... s) {
        try {
            for (String ss : s) {
                if (!StringUtils.isNotEmpty(ss)) continue;
                return StringUtils.parseNumber(ss, Number.class);
            }
            return null;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    static final OMap toOMap(String[] ss) {
        String s = StringUtils.joinnl(ss);
        if (s.isEmpty()) {
            return null;
        }
        if (!StringUtils.isJsonObject(s, true)) {
            s = "{" + s + "}";
        }
        try {
            return OMap.ofJson(s);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        try {
            OMap m = new OMap().ase("name", this.name).ase("type", new Object[]{this.type}).ase("format", new Object[]{this.format}).ase("codes", this.codes).ase("default", this._default).ase("enum", this._enum).ase("properties", this.properties).asf("allowEmptyValue", this.allowEmptyValue).asf("exclusiveMaximum", this.exclusiveMaximum).asf("exclusiveMinimum", this.exclusiveMinimum).asf("required", this.required).asf("uniqueItems", this.uniqueItems).asf("skipIfEmpty", this.skipIfEmpty).aif(this.collectionFormat != HttpPartCollectionFormat.NO_COLLECTION_FORMAT, "collectionFormat", (Object)this.collectionFormat).ase("pattern", this.pattern).asn("items", this.items).asn("additionalProperties", this.additionalProperties).asmo("maximum", this.maximum).asmo("minimum", this.minimum).asmo("multipleOf", this.multipleOf).asmo("maxLength", this.maxLength).asmo("minLength", this.minLength).asmo("maxItems", this.maxItems).asmo("minItems", this.minItems).asmo("maxProperties", this.maxProperties).asmo("minProperties", this.minProperties).append("parsedType", this.parsedType);
            return m.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

