/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice;

import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.juneau.collections.Args;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.ConfigBuilder;
import org.apache.juneau.config.event.ConfigEventListener;
import org.apache.juneau.config.event.ConfigEvents;
import org.apache.juneau.config.store.ConfigClasspathStore;
import org.apache.juneau.config.store.ConfigFileStore;
import org.apache.juneau.config.store.ConfigMemoryStore;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.internal.FileUtils;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.microservice.BasicMicroserviceListener;
import org.apache.juneau.microservice.LogConfig;
import org.apache.juneau.microservice.MicroserviceBuilder;
import org.apache.juneau.microservice.MicroserviceListener;
import org.apache.juneau.microservice.console.ConsoleCommand;
import org.apache.juneau.microservice.resources.LogEntryFormatter;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverBuilder;
import org.apache.juneau.svl.vars.ManifestFileVar;
import org.apache.juneau.utils.ManifestFile;

public class Microservice
implements ConfigEventListener {
    private static volatile Microservice INSTANCE;
    final Messages messages = Messages.of(Microservice.class);
    private final MicroserviceBuilder builder;
    private final Args args;
    private final Config config;
    private final ManifestFile manifest;
    private final VarResolver varResolver;
    private final MicroserviceListener listener;
    private final Map<String, ConsoleCommand> consoleCommandMap = new ConcurrentHashMap<String, ConsoleCommand>();
    private final boolean consoleEnabled;
    private final Scanner consoleReader;
    private final PrintWriter consoleWriter;
    private final Thread consoleThread;
    final File workingDir;
    private final String configName;
    private volatile Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setInstance(Microservice m) {
        Class<Microservice> clazz = Microservice.class;
        synchronized (Microservice.class) {
            INSTANCE = m;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Microservice getInstance() {
        Class<Microservice> clazz = Microservice.class;
        synchronized (Microservice.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static MicroserviceBuilder create() {
        return new MicroserviceBuilder();
    }

    protected Microservice(MicroserviceBuilder builder) throws IOException, ParseException {
        Microservice.setInstance(this);
        this.builder = builder.copy();
        this.workingDir = builder.workingDir;
        this.configName = builder.configName;
        this.args = builder.args != null ? builder.args : new Args(new String[0]);
        ManifestFile manifest = builder.manifest;
        if (manifest == null) {
            Manifest m;
            block29: {
                m = new Manifest();
                File f = this.resolveFile("META-INF/MANIFEST.MF");
                if (f.exists() && f.canRead()) {
                    try (FileInputStream fis = new FileInputStream(f);){
                        m.read(fis);
                        break block29;
                    }
                    catch (IOException e) {
                        throw new IOException("Problem detected in MANIFEST.MF.  Contents below:\n " + IOUtils.read(f), e);
                    }
                }
                URL url = this.getClass().getResource("META-INF/MANIFEST.MF");
                if (url != null) {
                    try {
                        m.read(url.openStream());
                    }
                    catch (IOException e) {
                        throw new IOException("Problem detected in MANIFEST.MF.  Contents below:\n " + IOUtils.read(url.openStream()), e);
                    }
                }
            }
            manifest = new ManifestFile(m);
        }
        ManifestFileVar.init(manifest);
        this.manifest = manifest;
        Config config = builder.config;
        ConfigBuilder configBuilder = builder.configBuilder.varResolver(builder.varResolverBuilder.build()).store(ConfigMemoryStore.DEFAULT);
        if (config == null) {
            ConfigStore store = builder.configStore;
            ConfigFileStore cfs = this.workingDir == null ? ConfigFileStore.DEFAULT : ConfigFileStore.create().directory(this.workingDir).build();
            for (String name : this.getCandidateConfigNames()) {
                if (store != null) {
                    if (!store.exists(name)) continue;
                    configBuilder.store(store).name(name);
                    break;
                }
                if (cfs.exists(name)) {
                    configBuilder.store(cfs).name(name);
                    break;
                }
                if (!ConfigClasspathStore.DEFAULT.exists(name)) continue;
                configBuilder.store(ConfigClasspathStore.DEFAULT).name(name);
                break;
            }
            config = configBuilder.build();
        }
        this.config = config;
        Config.setSystemDefault(this.config);
        this.config.addListener(this);
        VarResolverBuilder varResolverBuilder = builder.varResolverBuilder;
        this.varResolver = varResolverBuilder.contextObject("config", config).build();
        this.consoleEnabled = ObjectUtils.firstNonNull(builder.consoleEnabled, config.getBoolean("Console/enabled", false));
        if (this.consoleEnabled) {
            Console c = System.console();
            this.consoleReader = ObjectUtils.firstNonNull(builder.consoleReader, new Scanner(c == null ? new InputStreamReader(System.in) : c.reader()));
            this.consoleWriter = ObjectUtils.firstNonNull(builder.consoleWriter, c == null ? new PrintWriter(System.out, true) : c.writer());
            for (ConsoleCommand cc : builder.consoleCommands) {
                this.consoleCommandMap.put(cc.getName(), cc);
            }
            for (Iterator<Object> iterator : config.getStringArray("Console/commands")) {
                try {
                    ConsoleCommand cc = (ConsoleCommand)Class.forName(iterator).newInstance();
                    this.consoleCommandMap.put(cc.getName(), cc);
                }
                catch (Exception e) {
                    this.getConsoleWriter().println("Could not create console command '" + iterator + "', " + e.getLocalizedMessage());
                }
            }
            this.consoleThread = new Thread("ConsoleThread"){

                @Override
                public void run() {
                    Scanner in = Microservice.this.getConsoleReader();
                    PrintWriter out = Microservice.this.getConsoleWriter();
                    out.println(Microservice.this.messages.getString("ListOfAvailableCommands"));
                    for (ConsoleCommand cc : new TreeMap<String, ConsoleCommand>(Microservice.this.getConsoleCommands()).values()) {
                        out.append("\t").append(cc.getName()).append(" -- ").append(cc.getInfo()).println();
                    }
                    out.println();
                    while (true) {
                        String line = null;
                        out.append("> ").flush();
                        line = in.nextLine();
                        Args args = new Args(line);
                        if (args.isEmpty()) continue;
                        Microservice.this.executeCommand(args, in, out);
                    }
                }
            };
            this.consoleThread.setDaemon(true);
        } else {
            this.consoleReader = null;
            this.consoleWriter = null;
            this.consoleThread = null;
        }
        this.listener = builder.listener != null ? builder.listener : new BasicMicroserviceListener();
        this.init();
    }

    private List<String> getCandidateConfigNames() {
        if (this.configName != null) {
            return Collections.singletonList(this.configName);
        }
        Args args = this.getArgs();
        if (this.getArgs().hasArg("configFile")) {
            return Collections.singletonList(args.getArg("configFile"));
        }
        ManifestFile manifest = this.getManifest();
        if (manifest.containsKey("Main-Config")) {
            return Collections.singletonList(manifest.getString("Main-Config"));
        }
        return Config.getCandidateSystemDefaultConfigNames();
    }

    protected File resolveFile(String path) {
        if (Paths.get(path, new String[0]).isAbsolute()) {
            return new File(path);
        }
        if (this.workingDir != null) {
            return new File(this.workingDir, path);
        }
        return new File(path);
    }

    public synchronized Microservice init() throws IOException, ParseException {
        OMap loggerLevels;
        LogConfig logConfig;
        Set<String> spKeys = this.config.getKeys("SystemProperties");
        if (spKeys != null) {
            for (String key : spKeys) {
                System.setProperty(key, this.config.getString("SystemProperties/" + key));
            }
        }
        this.logger = this.builder.logger;
        LogConfig logConfig2 = logConfig = this.builder.logConfig != null ? this.builder.logConfig : new LogConfig();
        if (this.logger == null) {
            LogManager.getLogManager().reset();
            this.logger = Logger.getLogger("");
            String logFile = ObjectUtils.firstNonNull(logConfig.logFile, this.config.getString("Logging/logFile"));
            if (StringUtils.isNotEmpty(logFile)) {
                String logDir = ObjectUtils.firstNonNull(logConfig.logDir, this.config.getString("Logging/logDir", "."));
                File logDirFile = this.resolveFile(logDir);
                FileUtils.mkdirs(logDirFile, false);
                logDir = logDirFile.getAbsolutePath();
                System.setProperty("juneau.logDir", logDir);
                boolean append = ObjectUtils.firstNonNull(logConfig.append, this.config.getBoolean("Logging/append"));
                int limit = ObjectUtils.firstNonNull(logConfig.limit, this.config.getInt("Logging/limit", 0x100000));
                int count = ObjectUtils.firstNonNull(logConfig.count, this.config.getInt("Logging/count", 1));
                FileHandler fh = new FileHandler(logDir + '/' + logFile, limit, count, append);
                Formatter f = logConfig.formatter;
                if (f == null) {
                    String format = this.config.getString("Logging/format", "[{date} {level}] {msg}%n");
                    String dateFormat = this.config.getString("Logging/dateFormat", "yyyy.MM.dd hh:mm:ss");
                    boolean useStackTraceHashes = this.config.getBoolean("Logging/useStackTraceHashes");
                    f = new LogEntryFormatter(format, dateFormat, useStackTraceHashes);
                }
                fh.setFormatter(f);
                fh.setLevel(ObjectUtils.firstNonNull(logConfig.fileLevel, this.config.getObjectWithDefault("Logging/fileLevel", Level.INFO, Level.class)));
                this.logger.addHandler(fh);
                ConsoleHandler ch = new ConsoleHandler();
                ch.setLevel(ObjectUtils.firstNonNull(logConfig.consoleLevel, this.config.getObjectWithDefault("Logging/consoleLevel", Level.WARNING, Level.class)));
                ch.setFormatter(f);
                this.logger.addHandler(ch);
            }
        }
        if ((loggerLevels = this.config.getObject("Logging/levels", OMap.class)) != null) {
            for (String l : loggerLevels.keySet()) {
                Logger.getLogger(l).setLevel(loggerLevels.get(l, Level.class));
            }
        }
        for (String l : logConfig.levels.keySet()) {
            Logger.getLogger(l).setLevel(logConfig.levels.get(l));
        }
        return this;
    }

    public synchronized Microservice start() throws Exception {
        if (this.config.getName() == null) {
            this.err(this.messages, "RunningClassWithoutConfig", this.getClass().getSimpleName());
        } else {
            this.out(this.messages, "RunningClassWithConfig", this.getClass().getSimpleName(), this.config.getName());
        }
        Runtime.getRuntime().addShutdownHook(new Thread("ShutdownHookThread"){

            @Override
            public void run() {
                try {
                    Microservice.this.stop();
                    Microservice.this.stopConsole();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.listener.onStart(this);
        return this;
    }

    public synchronized Microservice startConsole() throws Exception {
        if (this.consoleThread != null && !this.consoleThread.isAlive()) {
            this.consoleThread.start();
        }
        return this;
    }

    public synchronized Microservice stopConsole() throws Exception {
        if (this.consoleThread != null && this.consoleThread.isAlive()) {
            this.consoleThread.interrupt();
        }
        return this;
    }

    public Args getArgs() {
        return this.args;
    }

    public Config getConfig() {
        return this.config;
    }

    public ManifestFile getManifest() {
        return this.manifest;
    }

    public VarResolver getVarResolver() {
        return this.varResolver;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean executeCommand(Args args, Scanner in, PrintWriter out) {
        ConsoleCommand cc = this.consoleCommandMap.get(args.getArg(0));
        if (cc == null) {
            out.println(this.messages.getString("UnknownCommand"));
        } else {
            try {
                return cc.execute(in, out, args);
            }
            catch (Exception e) {
                e.printStackTrace(out);
            }
        }
        return false;
    }

    public String executeCommand(String command, String input, Object ... args) {
        StringWriter sw = new StringWriter();
        ArrayList<String> l = new ArrayList<String>();
        l.add(command);
        for (Object a : args) {
            l.add(StringUtils.stringify(a));
        }
        Args args2 = new Args(l.toArray(new String[l.size()]));
        try (Scanner in = new Scanner(input);
             PrintWriter out = new PrintWriter(sw);){
            this.executeCommand(args2, in, out);
        }
        return sw.toString();
    }

    public Microservice join() throws Exception {
        return this;
    }

    public Microservice stop() throws Exception {
        this.listener.onStop(this);
        return this;
    }

    public void exit() throws Exception {
        try {
            this.stopConsole();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public void kill() {
        System.exit(2);
    }

    public final Map<String, ConsoleCommand> getConsoleCommands() {
        return this.consoleCommandMap;
    }

    protected Scanner getConsoleReader() {
        return this.consoleReader;
    }

    protected PrintWriter getConsoleWriter() {
        return this.consoleWriter;
    }

    public void out(Messages mb, String messageKey, Object ... args) {
        String msg = mb.getString(messageKey, args);
        if (this.consoleEnabled) {
            this.getConsoleWriter().println(msg);
        }
        this.log(Level.INFO, msg, new Object[0]);
    }

    public void err(Messages mb, String messageKey, Object ... args) {
        String msg = mb.getString(messageKey, args);
        if (this.consoleEnabled) {
            System.err.println(mb.getString(messageKey, args));
        }
        this.log(Level.SEVERE, msg, new Object[0]);
    }

    protected void log(Level level, String message, Object ... args) {
        String msg = args.length == 0 ? message : MessageFormat.format(message, args);
        this.getLogger().log(level, msg);
    }

    @Override
    public void onConfigChange(ConfigEvents events) {
        this.listener.onConfigChange(this, events);
    }
}

