/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.debug;

import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import org.apache.juneau.Enablement;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.rest.HttpRuntimeException;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestOpContext;
import org.apache.juneau.rest.debug.BasicDebugEnablement;
import org.apache.juneau.utils.ReflectionMap;

public interface DebugEnablement {
    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    public boolean isDebug(RestContext var1, HttpServletRequest var2);

    public boolean isDebug(RestOpContext var1, HttpServletRequest var2);

    public static class Builder {
        ReflectionMap.Builder<Enablement> mapBuilder;
        Enablement defaultEnablement = Enablement.NEVER;
        Predicate<HttpServletRequest> conditional;
        BeanCreator<DebugEnablement> creator;

        protected Builder(BeanStore beanStore) {
            this.mapBuilder = ReflectionMap.create(Enablement.class);
            this.defaultEnablement = Enablement.NEVER;
            this.conditional = x -> "true".equalsIgnoreCase(x.getHeader("Debug"));
            this.creator = beanStore.createBean(DebugEnablement.class).type(BasicDebugEnablement.class).builder(Builder.class, (Object)this);
        }

        public DebugEnablement build() {
            try {
                return (DebugEnablement)this.creator.run();
            }
            catch (Exception e) {
                throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
            }
        }

        public Builder type(Class<? extends DebugEnablement> value) {
            this.creator.type(value == null ? BasicDebugEnablement.class : value);
            return this;
        }

        public Builder impl(DebugEnablement value) {
            this.creator.impl((Object)value);
            return this;
        }

        public Builder enable(Enablement enablement, String ... keys) {
            for (String k : keys) {
                this.mapBuilder.append(k, (Object)enablement);
            }
            return this;
        }

        public Builder enable(Enablement enablement, Class<?> ... classes) {
            for (Class<?> c : classes) {
                this.mapBuilder.append(c.getName(), (Object)enablement);
            }
            return this;
        }

        public Builder defaultEnable(Enablement value) {
            this.defaultEnablement = value;
            return this;
        }

        public Builder conditional(Predicate<HttpServletRequest> value) {
            this.conditional = value;
            return this;
        }
    }

    public static abstract class Void
    implements DebugEnablement {
    }
}

