/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import org.apache.http.HttpException;
import org.apache.juneau.http.header.Thrown;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.rest.client.RestResponse;

public final class RestCallException
extends HttpException {
    private static final long serialVersionUID = 1L;
    private final RestResponse response;
    private final Thrown thrown;

    public RestCallException(RestResponse response, Throwable cause, String message, Object ... args) {
        super(RestCallException.format(message, args), cause);
        this.response = response;
        this.thrown = response == null ? Thrown.EMPTY : response.getHeader("Thrown").asHeader(Thrown.class);
    }

    public Thrown getThrown() {
        return this.thrown;
    }

    public RestResponse getResponse() {
        return this.response;
    }

    public int getResponseCode() {
        return this.response == null ? 0 : this.response.getStatusCode();
    }

    public <T extends Throwable> T getCause(Class<T> c) {
        return ThrowableUtils.getCause(c, this);
    }

    private static String format(String msg, Object ... args) {
        if (args.length == 0) {
            return RestCallException.clean(msg);
        }
        return RestCallException.clean(StringUtils.format(msg, args));
    }

    private static String clean(String message) {
        message = StringUtils.emptyIfNull(message);
        boolean needsCleaning = false;
        for (int i = 0; i < message.length() && !needsCleaning; ++i) {
            if (message.charAt(i) >= ' ') continue;
            needsCleaning = true;
        }
        if (!needsCleaning) {
            return message;
        }
        StringBuilder sb = new StringBuilder(message.length());
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            sb.append(c < ' ' ? (char)' ' : (char)c);
        }
        return sb.toString();
    }
}

