/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.response;

import org.apache.http.HttpResponse;
import org.apache.juneau.http.BasicStatusLine;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.Schema;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.http.response.BasicHttpResponse;
import org.apache.juneau.http.response.HttpResponseBuilder;

@Response
@StatusCode(value={206})
@Schema(description={"Partial Content"})
public class PartialContent
extends BasicHttpResponse {
    public static final int STATUS_CODE = 206;
    public static final String REASON_PHRASE = "Partial Content";
    private static final BasicStatusLine STATUS_LINE = BasicStatusLine.create().statusCode(206).reasonPhrase("Partial Content").build();
    public static final PartialContent INSTANCE = PartialContent.create().unmodifiable().build();

    public static HttpResponseBuilder<PartialContent> create() {
        return new HttpResponseBuilder<Class<PartialContent>>(PartialContent.class).statusLine(STATUS_LINE);
    }

    public PartialContent(HttpResponseBuilder<?> builder) {
        super(builder);
    }

    public PartialContent(HttpResponse response) {
        this(PartialContent.create().copyFrom(response));
        this.assertStatusCode(response);
    }

    public HttpResponseBuilder<PartialContent> copy() {
        return new HttpResponseBuilder<PartialContent>(this);
    }
}

