/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;

@FluentSetters
public class ControlledArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = -1L;
    private boolean unmodifiable;

    public ControlledArrayList(boolean unmodifiable) {
        this.unmodifiable = unmodifiable;
    }

    public ControlledArrayList(boolean unmodifiable, List<? extends E> list) {
        super(list);
        this.unmodifiable = unmodifiable;
    }

    @FluentSetter
    public ControlledArrayList<E> setUnmodifiable() {
        this.unmodifiable = true;
        return this;
    }

    protected final void assertModifiable() {
        if (this.unmodifiable) {
            throw new UnsupportedOperationException("List is read-only");
        }
    }

    public boolean isModifiable() {
        return !this.unmodifiable;
    }

    @Override
    public E set(int index, E element) {
        this.assertModifiable();
        return this.overrideSet(index, element);
    }

    public E overrideSet(int index, E element) {
        return super.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.assertModifiable();
        this.overrideAdd(index, element);
    }

    public void overrideAdd(int index, E element) {
        super.add(index, element);
    }

    @Override
    public E remove(int index) {
        this.assertModifiable();
        return this.overrideRemove(index);
    }

    public E overrideRemove(int index) {
        return super.remove(index);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.assertModifiable();
        return this.overrideAddAll(index, c);
    }

    public boolean overrideAddAll(int index, Collection<? extends E> c) {
        return super.addAll(index, c);
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        this.assertModifiable();
        this.overrideReplaceAll(operator);
    }

    public void overrideReplaceAll(UnaryOperator<E> operator) {
        super.replaceAll(operator);
    }

    @Override
    public void sort(Comparator<? super E> c) {
        this.assertModifiable();
        this.overrideSort(c);
    }

    public void overrideSort(Comparator<? super E> c) {
        super.sort(c);
    }

    @Override
    public boolean add(E element) {
        this.assertModifiable();
        return this.overrideAdd(element);
    }

    public boolean overrideAdd(E element) {
        return super.add(element);
    }

    @Override
    public boolean remove(Object o) {
        this.assertModifiable();
        return this.overrideRemove(o);
    }

    public boolean overrideRemove(Object o) {
        return super.remove(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.assertModifiable();
        return this.overrideAddAll(c);
    }

    public boolean overrideAddAll(Collection<? extends E> c) {
        return super.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        this.assertModifiable();
        return this.overrideRemoveAll(coll);
    }

    public boolean overrideRemoveAll(Collection<?> c) {
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.assertModifiable();
        return this.overrideRetainAll(c);
    }

    public boolean overrideRetainAll(Collection<?> c) {
        return super.retainAll(c);
    }

    @Override
    public void clear() {
        this.assertModifiable();
        this.overrideClear();
    }

    public void overrideClear() {
        super.clear();
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        this.assertModifiable();
        return this.overrideRemoveIf(filter);
    }

    public boolean overrideRemoveIf(Predicate<? super E> filter) {
        return super.removeIf(filter);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new ControlledArrayList(this.unmodifiable, super.subList(fromIndex, toIndex));
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        if (!this.unmodifiable) {
            return this.overrideListIterator(index);
        }
        return new ListIterator<E>(){
            private final ListIterator<? extends E> i;
            {
                this.i = ControlledArrayList.this.overrideListIterator(index);
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public E next() {
                return this.i.next();
            }

            @Override
            public boolean hasPrevious() {
                return this.i.hasPrevious();
            }

            @Override
            public E previous() {
                return this.i.previous();
            }

            @Override
            public int nextIndex() {
                return this.i.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.i.previousIndex();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(E e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(E e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void forEachRemaining(Consumer<? super E> action) {
                this.i.forEachRemaining(action);
            }
        };
    }

    public ListIterator<E> overrideListIterator(int index) {
        return super.listIterator(index);
    }

    @Override
    public Iterator<E> iterator() {
        if (!this.unmodifiable) {
            return this.overrideIterator();
        }
        return new Iterator<E>(){
            private final Iterator<? extends E> i;
            {
                this.i = ControlledArrayList.this.overrideIterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public E next() {
                return this.i.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void forEachRemaining(Consumer<? super E> action) {
                this.i.forEachRemaining(action);
            }
        };
    }

    public Iterator<E> overrideIterator() {
        return super.iterator();
    }
}

