/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import org.apache.juneau.Value;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.annotation.Attr;
import org.apache.juneau.rest.arg.ArgException;
import org.apache.juneau.rest.arg.RestOpArg;

public class AttributeArg
implements RestOpArg {
    private final String name;
    private final Class<?> type;

    public static AttributeArg create(ParamInfo paramInfo) {
        if (paramInfo.hasAnnotation(Attr.class) || paramInfo.getParameterType().hasAnnotation(Attr.class)) {
            return new AttributeArg(paramInfo);
        }
        return null;
    }

    protected AttributeArg(ParamInfo paramInfo) {
        this.name = this.getName(paramInfo);
        this.type = paramInfo.getParameterType().inner();
    }

    private String getName(ParamInfo paramInfo) {
        Value n = Value.empty();
        paramInfo.forEachAnnotation(Attr.class, x -> StringUtils.isNotEmpty((String)x.name()), x -> n.set((Object)x.name()));
        paramInfo.forEachAnnotation(Attr.class, x -> StringUtils.isNotEmpty((String)x.value()), x -> n.set((Object)x.value()));
        if (n.isEmpty()) {
            throw new ArgException(paramInfo, "@Attr used without name or value", new Object[0]);
        }
        return (String)n.get();
    }

    @Override
    public Object resolve(RestOpSession opSession) throws Exception {
        return opSession.getRequest().getAttribute(this.name).as(this.type).orElse(null);
    }
}

