/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jsonschema;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanTraverseContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Context;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.Visibility;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.jsonschema.BasicBeanDefMapper;
import org.apache.juneau.jsonschema.BeanDefMapper;
import org.apache.juneau.jsonschema.JsonSchemaBeanPropertyMeta;
import org.apache.juneau.jsonschema.JsonSchemaClassMeta;
import org.apache.juneau.jsonschema.JsonSchemaGeneratorSession;
import org.apache.juneau.jsonschema.JsonSchemaMetaProvider;
import org.apache.juneau.jsonschema.TypeCategory;
import org.apache.juneau.swap.BeanInterceptor;
import org.apache.juneau.utils.HashKey;
import org.apache.juneau.utils.ThrowingFunction;

public class JsonSchemaGenerator
extends BeanTraverseContext
implements JsonSchemaMetaProvider {
    public static final JsonSchemaGenerator DEFAULT = new JsonSchemaGenerator(JsonSchemaGenerator.create());
    final boolean useBeanDefs;
    final boolean allowNestedExamples;
    final boolean allowNestedDescriptions;
    final Set<TypeCategory> addExamplesTo;
    final Set<TypeCategory> addDescriptionsTo;
    final Class<? extends BeanDefMapper> beanDefMapper;
    final Set<String> ignoreTypes;
    private final BeanDefMapper beanDefMapperBean;
    final JsonSerializer jsonSerializer;
    final JsonParser jsonParser;
    private final Pattern[] ignoreTypePatterns;
    private final Map<ClassMeta<?>, JsonSchemaClassMeta> jsonSchemaClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, JsonSchemaBeanPropertyMeta> jsonSchemaBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, JsonSchemaBeanPropertyMeta>();

    public static Builder create() {
        return new Builder();
    }

    public JsonSchemaGenerator(Builder builder) {
        super(builder.detectRecursions().ignoreRecursions());
        this.useBeanDefs = builder.useBeanDefs;
        this.allowNestedExamples = builder.allowNestedExamples;
        this.allowNestedDescriptions = builder.allowNestedDescriptions;
        this.beanDefMapper = builder.beanDefMapper;
        this.addExamplesTo = builder.addExamplesTo == null ? Collections.emptySet() : new TreeSet<TypeCategory>(builder.addExamplesTo);
        this.addDescriptionsTo = builder.addDescriptionsTo == null ? Collections.emptySet() : new TreeSet<TypeCategory>(builder.addDescriptionsTo);
        this.ignoreTypes = builder.ignoreTypes == null ? Collections.emptySet() : new TreeSet<String>(builder.ignoreTypes);
        LinkedHashSet<Pattern> ignoreTypePatterns = CollectionUtils.set(new Pattern[0]);
        this.ignoreTypes.forEach(y -> StringUtils.split(y, x -> ignoreTypePatterns.add(Pattern.compile(x.replace(".", "\\.").replace("*", ".*")))));
        this.ignoreTypePatterns = ignoreTypePatterns.toArray(new Pattern[ignoreTypePatterns.size()]);
        try {
            this.beanDefMapperBean = this.beanDefMapper.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw ThrowableUtils.asRuntimeException(e);
        }
        this.jsonSerializer = builder.jsonSerializerBuilder.build();
        this.jsonParser = builder.jsonParserBuilder.beanContext(this.getBeanContext()).build();
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    @Override
    public JsonSchemaGeneratorSession.Builder createSession() {
        return JsonSchemaGeneratorSession.create(this);
    }

    @Override
    public JsonSchemaGeneratorSession getSession() {
        return this.createSession().build();
    }

    JsonSerializer getJsonSerializer() {
        return this.jsonSerializer;
    }

    JsonParser getJsonParser() {
        return this.jsonParser;
    }

    protected final Set<TypeCategory> getAddDescriptionsTo() {
        return this.addDescriptionsTo;
    }

    protected final Set<TypeCategory> getAddExamplesTo() {
        return this.addExamplesTo;
    }

    protected final boolean isAllowNestedDescriptions() {
        return this.allowNestedDescriptions;
    }

    protected final boolean isAllowNestedExamples() {
        return this.allowNestedExamples;
    }

    protected final BeanDefMapper getBeanDefMapper() {
        return this.beanDefMapperBean;
    }

    public List<Pattern> getIgnoreTypes() {
        return CollectionUtils.ulist(this.ignoreTypePatterns);
    }

    protected final boolean isUseBeanDefs() {
        return this.useBeanDefs;
    }

    @Override
    public JsonSchemaClassMeta getJsonSchemaClassMeta(ClassMeta<?> cm) {
        JsonSchemaClassMeta m = this.jsonSchemaClassMetas.get(cm);
        if (m == null) {
            m = new JsonSchemaClassMeta(cm, this);
            this.jsonSchemaClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public JsonSchemaBeanPropertyMeta getJsonSchemaBeanPropertyMeta(BeanPropertyMeta bpm) {
        JsonSchemaBeanPropertyMeta m = this.jsonSchemaBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new JsonSchemaBeanPropertyMeta(bpm, this);
            this.jsonSchemaBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    public boolean isIgnoredType(ClassMeta<?> cm) {
        for (Pattern p : this.ignoreTypePatterns) {
            if (!p.matcher(cm.getSimpleName()).matches() && !p.matcher(cm.getName()).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JsonMap properties() {
        return JsonMap.filteredMap().append("useBeanDefs", this.useBeanDefs).append("allowNestedExamples", this.allowNestedExamples).append("allowNestedDescriptions", this.allowNestedDescriptions).append("beanDefMapper", this.beanDefMapper).append("addExamplesTo", this.addExamplesTo).append("addDescriptionsTo", this.addDescriptionsTo).append("ignoreTypes", this.ignoreTypes);
    }

    @FluentSetters
    public static class Builder
    extends BeanTraverseContext.Builder {
        private static final Cache<HashKey, JsonSchemaGenerator> CACHE = Cache.of(HashKey.class, JsonSchemaGenerator.class).build();
        final JsonSerializer.Builder jsonSerializerBuilder;
        final JsonParser.Builder jsonParserBuilder;
        SortedSet<TypeCategory> addDescriptionsTo;
        SortedSet<TypeCategory> addExamplesTo;
        boolean allowNestedDescriptions;
        boolean allowNestedExamples;
        boolean useBeanDefs;
        Class<? extends BeanDefMapper> beanDefMapper;
        SortedSet<String> ignoreTypes;

        protected Builder() {
            BeanContext.Builder bc = this.beanContext();
            this.jsonSerializerBuilder = JsonSerializer.create().beanContext(bc);
            this.jsonParserBuilder = JsonParser.create().beanContext(bc);
            this.registerBuilders(this.jsonSerializerBuilder, this.jsonParserBuilder);
            this.addDescriptionsTo = null;
            this.addExamplesTo = null;
            this.allowNestedDescriptions = this.env("JsonSchemaGenerator.allowNestedDescriptions", false);
            this.allowNestedExamples = this.env("JsonSchemaGenerator.allowNestedExamples", false);
            this.useBeanDefs = this.env("JsonSchemaGenerator.useBeanDefs", false);
            this.beanDefMapper = BasicBeanDefMapper.class;
            this.ignoreTypes = null;
        }

        protected Builder(JsonSchemaGenerator copyFrom) {
            super(copyFrom);
            BeanContext.Builder bc = this.beanContext();
            this.jsonSerializerBuilder = copyFrom.jsonSerializer.copy().beanContext(bc);
            this.jsonParserBuilder = copyFrom.jsonParser.copy().beanContext(bc);
            this.registerBuilders(this.jsonSerializerBuilder, this.jsonParserBuilder);
            this.addDescriptionsTo = copyFrom.addDescriptionsTo.isEmpty() ? null : new TreeSet<TypeCategory>(copyFrom.addDescriptionsTo);
            this.addExamplesTo = copyFrom.addExamplesTo.isEmpty() ? null : new TreeSet<TypeCategory>(copyFrom.addExamplesTo);
            this.allowNestedDescriptions = copyFrom.allowNestedDescriptions;
            this.allowNestedExamples = copyFrom.allowNestedExamples;
            this.useBeanDefs = copyFrom.useBeanDefs;
            this.beanDefMapper = copyFrom.beanDefMapper;
            this.ignoreTypes = copyFrom.ignoreTypes.isEmpty() ? null : new TreeSet<String>(copyFrom.ignoreTypes);
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            BeanContext.Builder bc = this.beanContext();
            this.jsonSerializerBuilder = copyFrom.jsonSerializerBuilder.copy().beanContext(bc);
            this.jsonParserBuilder = copyFrom.jsonParserBuilder.copy().beanContext(bc);
            this.registerBuilders(this.jsonSerializerBuilder, this.jsonParserBuilder);
            this.addDescriptionsTo = copyFrom.addDescriptionsTo == null ? null : new TreeSet<TypeCategory>(copyFrom.addDescriptionsTo);
            this.addExamplesTo = copyFrom.addExamplesTo == null ? null : new TreeSet<TypeCategory>(copyFrom.addExamplesTo);
            this.allowNestedDescriptions = copyFrom.allowNestedDescriptions;
            this.allowNestedExamples = copyFrom.allowNestedExamples;
            this.useBeanDefs = copyFrom.useBeanDefs;
            this.beanDefMapper = copyFrom.beanDefMapper;
            this.ignoreTypes = copyFrom.ignoreTypes == null ? null : new TreeSet<String>(copyFrom.ignoreTypes);
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public JsonSchemaGenerator build() {
            return this.cache(CACHE).build(JsonSchemaGenerator.class);
        }

        @Override
        public HashKey hashKey() {
            return HashKey.of(super.hashKey(), this.jsonSerializerBuilder.hashKey(), this.jsonParserBuilder.hashKey(), this.addDescriptionsTo, this.addExamplesTo, this.allowNestedDescriptions, this.allowNestedExamples, this.useBeanDefs, this.beanDefMapper, this.ignoreTypes);
        }

        @FluentSetter
        public Builder addDescriptionsTo(TypeCategory ... values) {
            this.addDescriptionsTo = CollectionUtils.addAll(this.addDescriptionsTo, values);
            return this;
        }

        @FluentSetter
        public Builder addExamplesTo(TypeCategory ... values) {
            this.addExamplesTo = CollectionUtils.addAll(this.addExamplesTo, values);
            return this;
        }

        @FluentSetter
        public Builder allowNestedDescriptions() {
            return this.allowNestedDescriptions(true);
        }

        @FluentSetter
        public Builder allowNestedDescriptions(boolean value) {
            this.allowNestedDescriptions = value;
            return this;
        }

        @FluentSetter
        public Builder allowNestedExamples() {
            return this.allowNestedExamples(true);
        }

        @FluentSetter
        public Builder allowNestedExamples(boolean value) {
            this.allowNestedExamples = value;
            return this;
        }

        @FluentSetter
        public Builder beanDefMapper(Class<? extends BeanDefMapper> value) {
            this.beanDefMapper = value;
            return this;
        }

        @FluentSetter
        public Builder ignoreTypes(String ... values) {
            this.ignoreTypes = CollectionUtils.addAll(this.ignoreTypes, values);
            return this;
        }

        @FluentSetter
        public Builder useBeanDefs() {
            return this.useBeanDefs(true);
        }

        @FluentSetter
        public Builder useBeanDefs(boolean value) {
            this.useBeanDefs = value;
            return this;
        }

        public JsonSerializer.Builder getJsonSerializerBuilder() {
            return this.jsonSerializerBuilder;
        }

        public JsonParser.Builder getJsonParserBuilder() {
            return this.jsonParserBuilder;
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... fromClasses) {
            super.applyAnnotations((Class[])fromClasses);
            return this;
        }

        @Override
        public Builder applyAnnotations(Method ... fromMethods) {
            super.applyAnnotations(fromMethods);
            return this;
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache((Cache)value);
            return this;
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type((Class)value);
            return this;
        }

        @Override
        public Builder beanClassVisibility(Visibility value) {
            super.beanClassVisibility(value);
            return this;
        }

        @Override
        public Builder beanConstructorVisibility(Visibility value) {
            super.beanConstructorVisibility(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext.Builder value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanDictionary(Class<?> ... values) {
            super.beanDictionary((Class[])values);
            return this;
        }

        @Override
        public Builder beanFieldVisibility(Visibility value) {
            super.beanFieldVisibility(value);
            return this;
        }

        @Override
        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            super.beanInterceptor((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder beanMapPutReturnsOldValue() {
            super.beanMapPutReturnsOldValue();
            return this;
        }

        @Override
        public Builder beanMethodVisibility(Visibility value) {
            super.beanMethodVisibility(value);
            return this;
        }

        @Override
        public Builder beanProperties(Map<String, Object> values) {
            super.beanProperties((Map)values);
            return this;
        }

        @Override
        public Builder beanProperties(Class<?> beanClass, String properties) {
            super.beanProperties((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanProperties(String beanClassName, String properties) {
            super.beanProperties(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            super.beanPropertiesExcludes((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            super.beanPropertiesExcludes((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            super.beanPropertiesExcludes(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            super.beanPropertiesReadOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesReadOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            super.beanPropertiesReadOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            super.beanPropertiesWriteOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesWriteOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            super.beanPropertiesWriteOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beansRequireDefaultConstructor() {
            super.beansRequireDefaultConstructor();
            return this;
        }

        @Override
        public Builder beansRequireSerializable() {
            super.beansRequireSerializable();
            return this;
        }

        @Override
        public Builder beansRequireSettersForGetters() {
            super.beansRequireSettersForGetters();
            return this;
        }

        @Override
        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            super.dictionaryOn((Class)on, (Class[])values);
            return this;
        }

        @Override
        public Builder disableBeansRequireSomeProperties() {
            super.disableBeansRequireSomeProperties();
            return this;
        }

        @Override
        public Builder disableIgnoreMissingSetters() {
            super.disableIgnoreMissingSetters();
            return this;
        }

        @Override
        public Builder disableIgnoreTransientFields() {
            super.disableIgnoreTransientFields();
            return this;
        }

        @Override
        public Builder disableIgnoreUnknownNullBeanProperties() {
            super.disableIgnoreUnknownNullBeanProperties();
            return this;
        }

        @Override
        public Builder disableInterfaceProxies() {
            super.disableInterfaceProxies();
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, T o) {
            super.example((Class)pojoClass, (Object)o);
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, String json) {
            super.example((Class)pojoClass, json);
            return this;
        }

        @Override
        public Builder findFluentSetters() {
            super.findFluentSetters();
            return this;
        }

        @Override
        public Builder findFluentSetters(Class<?> on) {
            super.findFluentSetters((Class)on);
            return this;
        }

        @Override
        public Builder ignoreInvocationExceptionsOnGetters() {
            super.ignoreInvocationExceptionsOnGetters();
            return this;
        }

        @Override
        public Builder ignoreInvocationExceptionsOnSetters() {
            super.ignoreInvocationExceptionsOnSetters();
            return this;
        }

        @Override
        public Builder ignoreUnknownBeanProperties() {
            super.ignoreUnknownBeanProperties();
            return this;
        }

        @Override
        public Builder ignoreUnknownEnumValues() {
            super.ignoreUnknownEnumValues();
            return this;
        }

        @Override
        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            super.implClass((Class)interfaceClass, (Class)implClass);
            return this;
        }

        @Override
        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            super.implClasses((Map)values);
            return this;
        }

        @Override
        public Builder interfaceClass(Class<?> on, Class<?> value) {
            super.interfaceClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder interfaces(Class<?> ... value) {
            super.interfaces((Class[])value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder notBeanClasses(Class<?> ... values) {
            super.notBeanClasses((Class[])values);
            return this;
        }

        @Override
        public Builder notBeanPackages(String ... values) {
            super.notBeanPackages(values);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)value);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder sortProperties() {
            super.sortProperties();
            return this;
        }

        @Override
        public Builder sortProperties(Class<?> ... on) {
            super.sortProperties((Class[])on);
            return this;
        }

        @Override
        public Builder stopClass(Class<?> on, Class<?> value) {
            super.stopClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction, (ThrowingFunction)unswapFunction);
            return this;
        }

        @Override
        public Builder swaps(Class<?> ... values) {
            super.swaps((Class[])values);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder typeName(Class<?> on, String value) {
            super.typeName((Class)on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(String value) {
            super.typePropertyName(value);
            return this;
        }

        @Override
        public Builder typePropertyName(Class<?> on, String value) {
            super.typePropertyName((Class)on, value);
            return this;
        }

        @Override
        public Builder useEnumNames() {
            super.useEnumNames();
            return this;
        }

        @Override
        public Builder useJavaBeanIntrospector() {
            super.useJavaBeanIntrospector();
            return this;
        }

        @Override
        public Builder detectRecursions() {
            super.detectRecursions();
            return this;
        }

        @Override
        public Builder detectRecursions(boolean value) {
            super.detectRecursions(value);
            return this;
        }

        @Override
        public Builder ignoreRecursions() {
            super.ignoreRecursions();
            return this;
        }

        @Override
        public Builder ignoreRecursions(boolean value) {
            super.ignoreRecursions(value);
            return this;
        }

        @Override
        public Builder initialDepth(int value) {
            super.initialDepth(value);
            return this;
        }

        @Override
        public Builder maxDepth(int value) {
            super.maxDepth(value);
            return this;
        }
    }
}

