/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.matcher;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.juneau.commons.lang.VersionRange;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.rest.annotation.RestOpAnnotation;
import org.apache.juneau.rest.matcher.RestMatcher;

public class ClientVersionMatcher
extends RestMatcher {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    private final String clientVersionHeader;
    private final VersionRange range;

    public ClientVersionMatcher(String clientVersionHeader, MethodInfo mi) {
        this.clientVersionHeader = StringUtils.isEmpty((String)clientVersionHeader) ? "Client-Version" : clientVersionHeader;
        String clientVersion = AP.find(mi, new AnnotationTraversal[0]).stream().filter(RestOpAnnotation.REST_OP_GROUP).flatMap(ai -> ai.getValue(String.class, "clientVersion").stream()).filter(StringUtils.NOT_EMPTY).findFirst().orElse(null);
        this.range = new VersionRange(clientVersion);
    }

    @Override
    public boolean matches(HttpServletRequest req) {
        return this.range.matches(req.getHeader(this.clientVersionHeader));
    }

    @Override
    public boolean required() {
        return true;
    }
}

