/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.support.completers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;

public class AggregateCompleter
implements Completer {
    private final Collection<Completer> completers;

    public AggregateCompleter(Collection<Completer> completers) {
        assert (completers != null);
        this.completers = completers;
    }

    public int complete(Session session, CommandLine commandLine, List candidates) {
        assert (candidates != null);
        ArrayList<Completion> completions = new ArrayList<Completion>(this.completers.size());
        int max = -1;
        for (Completer completer : this.completers) {
            Completion completion = new Completion(candidates);
            completion.complete(session, completer, commandLine);
            if (completion.cursor > max) {
                completions.clear();
                completions.add(completion);
                max = completion.cursor;
                continue;
            }
            if (completion.cursor != max) continue;
            completions.add(completion);
        }
        for (Completion completion : completions) {
            candidates.addAll(completion.candidates);
        }
        return max;
    }

    private class Completion {
        public final List<String> candidates;
        public int cursor;

        public Completion(List candidates) {
            assert (candidates != null);
            this.candidates = new LinkedList<String>(candidates);
        }

        public void complete(Session session, Completer completer, CommandLine commandLine) {
            assert (completer != null);
            this.cursor = completer.complete(session, commandLine, this.candidates);
        }
    }
}

