/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.commands.help;

import java.io.BufferedReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.apache.karaf.shell.api.console.Command;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Parser;
import org.apache.karaf.shell.api.console.Registry;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.impl.console.commands.help.BundleHelpProvider;
import org.apache.karaf.shell.impl.console.commands.help.CommandListHelpProvider;
import org.apache.karaf.shell.impl.console.commands.help.CommandsHelpProvider;
import org.apache.karaf.shell.impl.console.commands.help.HelpProvider;
import org.apache.karaf.shell.impl.console.commands.help.ShellHelpProvider;
import org.apache.karaf.shell.impl.console.commands.help.SimpleHelpProvider;
import org.apache.karaf.shell.impl.console.commands.help.SingleCommandHelpProvider;
import org.apache.karaf.shell.support.CommandException;
import org.apache.karaf.shell.support.ansi.SimpleAnsi;
import org.apache.karaf.shell.support.completers.ArgumentCommandLine;
import org.apache.karaf.shell.support.completers.StringsCompleter;

public class HelpCommand
implements Command {
    public HelpCommand(SessionFactory factory) {
        Registry registry = factory.getRegistry();
        registry.register(this);
        registry.register(new SimpleHelpProvider());
        registry.register(new ShellHelpProvider());
        registry.register(new SingleCommandHelpProvider());
        registry.register(new CommandsHelpProvider());
        registry.register(new CommandListHelpProvider());
        registry.register(new BundleHelpProvider());
    }

    @Override
    public String getScope() {
        return "*";
    }

    @Override
    public String getName() {
        return "help";
    }

    @Override
    public String getDescription() {
        return "Displays this help or help about a command";
    }

    @Override
    public Object execute(Session session, List<Object> arguments) throws Exception {
        if (arguments.contains("--help")) {
            this.printHelp(System.out);
            return null;
        }
        if (arguments.size() > 1) {
            String msg = SimpleAnsi.COLOR_RED + "Error executing command " + SimpleAnsi.INTENSITY_BOLD + this.getName() + SimpleAnsi.INTENSITY_NORMAL + SimpleAnsi.COLOR_DEFAULT + ": too many arguments specified";
            throw new CommandException(msg);
        }
        String path = arguments.isEmpty() ? null : (arguments.get(0) == null ? null : arguments.get(0).toString());
        String help = this.getHelp(session, path);
        if (help != null) {
            try (BufferedReader reader = new BufferedReader(new StringReader(help));){
                String line;
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
            }
        }
        return null;
    }

    @Override
    public Completer getCompleter(boolean scoped) {
        return new Completer(){

            @Override
            public int complete(Session session, CommandLine commandLine, List<String> candidates) {
                String[] args = commandLine.getArguments();
                int argIndex = commandLine.getCursorArgumentIndex();
                StringsCompleter completer = new StringsCompleter(Collections.singletonList(HelpCommand.this.getName()));
                if (argIndex == 0) {
                    return completer.complete(session, new ArgumentCommandLine(args[argIndex], commandLine.getArgumentPosition()), candidates);
                }
                if (!this.verifyCompleter(session, completer, args[0])) {
                    return -1;
                }
                completer = new StringsCompleter();
                for (Command command : session.getRegistry().getCommands()) {
                    if (!"*".equals(command.getScope())) {
                        completer.getStrings().add(command.getScope() + ":" + command.getName());
                    }
                    completer.getStrings().add(command.getName());
                }
                completer.getStrings().add("--help");
                if (argIndex == 1) {
                    int res = argIndex < args.length ? completer.complete(session, new ArgumentCommandLine(args[argIndex], commandLine.getArgumentPosition()), candidates) : completer.complete(session, new ArgumentCommandLine("", 0), candidates);
                    return res + (commandLine.getBufferPosition() - commandLine.getArgumentPosition());
                }
                if (!this.verifyCompleter(session, completer, args[1])) {
                    return -1;
                }
                return -1;
            }

            protected boolean verifyCompleter(Session session, Completer completer, String argument) {
                ArrayList<String> candidates = new ArrayList<String>();
                return completer.complete(session, new ArgumentCommandLine(argument, argument.length()), candidates) != -1 && !candidates.isEmpty();
            }
        };
    }

    @Override
    public Parser getParser() {
        return null;
    }

    protected void printHelp(PrintStream out) {
        out.println(SimpleAnsi.INTENSITY_BOLD + "DESCRIPTION" + SimpleAnsi.INTENSITY_NORMAL);
        out.print("        ");
        out.println(SimpleAnsi.INTENSITY_BOLD + this.getName() + SimpleAnsi.INTENSITY_NORMAL);
        out.println();
        out.print("\t");
        out.println(this.getDescription());
        out.println();
        out.println(SimpleAnsi.INTENSITY_BOLD + "SYNTAX" + SimpleAnsi.INTENSITY_NORMAL);
        out.print("        ");
        out.println(this.getName() + " [options] [command]");
        out.println();
        out.println(SimpleAnsi.INTENSITY_BOLD + "ARGUMENTS" + SimpleAnsi.INTENSITY_NORMAL);
        out.print("        ");
        out.println(SimpleAnsi.INTENSITY_BOLD + "command" + SimpleAnsi.INTENSITY_NORMAL);
        out.print("                ");
        out.println("Command to display help for");
        out.println();
        out.println(SimpleAnsi.INTENSITY_BOLD + "OPTIONS" + SimpleAnsi.INTENSITY_NORMAL);
        out.print("        ");
        out.println(SimpleAnsi.INTENSITY_BOLD + "--help" + SimpleAnsi.INTENSITY_NORMAL);
        out.print("                ");
        out.println("Display this help message");
        out.println();
    }

    public String getHelp(Session session, String path) {
        if (path == null) {
            path = "%root%";
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("data", "${" + path + "}");
        List<HelpProvider> providers = session.getRegistry().getServices(HelpProvider.class);
        InterpolationHelper.performSubstitution(props, key -> {
            for (HelpProvider hp : providers) {
                String result = hp.getHelp(session, key);
                if (result == null) continue;
                return this.removeNewLine(result);
            }
            return null;
        });
        return (String)props.get("data");
    }

    private String removeNewLine(String help) {
        if (help != null && help.endsWith("\n")) {
            help = help.substring(0, help.length() - 1);
        }
        return help;
    }
}

