/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm;

import com.cloudera.api.swagger.ClustersResourceApi;
import com.cloudera.api.swagger.RolesResourceApi;
import com.cloudera.api.swagger.ServicesResourceApi;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiCluster;
import com.cloudera.api.swagger.model.ApiClusterList;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiRoleList;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import com.cloudera.api.swagger.model.ApiServiceList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.topology.discovery.GatewayService;
import org.apache.knox.gateway.topology.discovery.ServiceDiscovery;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerCluster;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.cm.DiscoveryApiClient;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModelGenerator;

public class ClouderaManagerServiceDiscovery
implements ServiceDiscovery {
    static final String TYPE = "ClouderaManager";
    private static final ClouderaManagerServiceDiscoveryMessages log = (ClouderaManagerServiceDiscoveryMessages)MessagesFactory.get(ClouderaManagerServiceDiscoveryMessages.class);
    static final String API_PATH = "api/v32";
    private static final String CLUSTER_TYPE_ANY = "any";
    private static final String VIEW_SUMMARY = "summary";
    private static final String VIEW_FULL = "full";
    static final String DEFAULT_USER_ALIAS = "cm.discovery.user";
    static final String DEFAULT_PWD_ALIAS = "cm.discovery.password";
    private boolean debug;
    @GatewayService
    private AliasService aliasService;

    ClouderaManagerServiceDiscovery() {
        this(false);
    }

    ClouderaManagerServiceDiscovery(boolean debug) {
        this.debug = debug;
    }

    public String getType() {
        return TYPE;
    }

    private DiscoveryApiClient getClient(ServiceDiscoveryConfig discoveryConfig) {
        String discoveryAddress = discoveryConfig.getAddress();
        if (discoveryAddress == null || discoveryAddress.isEmpty()) {
            log.missingDiscoveryAddress();
            throw new IllegalArgumentException("Missing or invalid discovery address.");
        }
        DiscoveryApiClient client = new DiscoveryApiClient(discoveryConfig, this.aliasService);
        client.setDebugging(this.debug);
        client.setVerifyingSsl(false);
        return client;
    }

    public Map<String, ServiceDiscovery.Cluster> discover(GatewayConfig gatewayConfig, ServiceDiscoveryConfig discoveryConfig) {
        HashMap<String, ServiceDiscovery.Cluster> clusters = new HashMap<String, ServiceDiscovery.Cluster>();
        DiscoveryApiClient client = this.getClient(discoveryConfig);
        List<ApiCluster> apiClusters = ClouderaManagerServiceDiscovery.getClusters(client);
        for (ApiCluster apiCluster : apiClusters) {
            String clusterName = apiCluster.getName();
            log.discoveredCluster(clusterName, apiCluster.getFullVersion());
            ServiceDiscovery.Cluster cluster = this.discover(gatewayConfig, discoveryConfig, clusterName, client);
            clusters.put(clusterName, cluster);
        }
        return clusters;
    }

    public ServiceDiscovery.Cluster discover(GatewayConfig gatewayConfig, ServiceDiscoveryConfig discoveryConfig, String clusterName) {
        return this.discover(gatewayConfig, discoveryConfig, clusterName, this.getClient(discoveryConfig));
    }

    protected ServiceDiscovery.Cluster discover(GatewayConfig gatewayConfig, ServiceDiscoveryConfig discoveryConfig, String clusterName, DiscoveryApiClient client) {
        ServiceDiscovery.Cluster cluster = null;
        if (clusterName == null || clusterName.isEmpty()) {
            log.missingDiscoveryCluster();
            throw new IllegalArgumentException("The cluster configuration is missing from, or invalid in, the discovery configuration.");
        }
        try {
            cluster = ClouderaManagerServiceDiscovery.discoverCluster(client, clusterName);
        }
        catch (ApiException e) {
            log.clusterDiscoveryError(clusterName, (Exception)((Object)e));
        }
        return cluster;
    }

    private static List<ApiCluster> getClusters(DiscoveryApiClient client) {
        ArrayList<ApiCluster> clusters = new ArrayList<ApiCluster>();
        try {
            ClustersResourceApi clustersResourceApi = new ClustersResourceApi((ApiClient)client);
            ApiClusterList clusterList = clustersResourceApi.readClusters(CLUSTER_TYPE_ANY, VIEW_SUMMARY);
            if (clusterList != null) {
                clusters.addAll(clusterList.getItems());
            }
        }
        catch (Exception e) {
            log.clusterDiscoveryError(CLUSTER_TYPE_ANY, e);
        }
        return clusters;
    }

    private static ServiceDiscovery.Cluster discoverCluster(DiscoveryApiClient client, String clusterName) throws ApiException {
        ClouderaManagerCluster cluster = null;
        ServicesResourceApi servicesResourceApi = new ServicesResourceApi((ApiClient)client);
        RolesResourceApi rolesResourceApi = new RolesResourceApi((ApiClient)client);
        log.discoveringCluster(clusterName);
        cluster = new ClouderaManagerCluster(clusterName);
        HashSet<ServiceModel> serviceModels = new HashSet<ServiceModel>();
        ServiceLoader<ServiceModelGenerator> loader = ServiceLoader.load(ServiceModelGenerator.class);
        ApiServiceList serviceList = ClouderaManagerServiceDiscovery.getClusterServices(servicesResourceApi, clusterName);
        if (serviceList != null) {
            for (ApiService service : serviceList.getItems()) {
                String serviceName = service.getName();
                log.discoveredService(serviceName, service.getType());
                ApiServiceConfig serviceConfig = ClouderaManagerServiceDiscovery.getServiceConfig(servicesResourceApi, clusterName, serviceName);
                ApiRoleList roleList = ClouderaManagerServiceDiscovery.getRoles(rolesResourceApi, clusterName, serviceName);
                if (roleList == null) continue;
                for (ApiRole role : roleList.getItems()) {
                    String roleName = role.getName();
                    log.discoveredServiceRole(roleName, role.getType());
                    ApiConfigList roleConfig = ClouderaManagerServiceDiscovery.getRoleConfig(rolesResourceApi, clusterName, serviceName, roleName);
                    for (ServiceModelGenerator serviceModelGenerator : loader) {
                        if (!serviceModelGenerator.handles(service, serviceConfig, role, roleConfig)) continue;
                        serviceModelGenerator.setApiClient(client);
                        ServiceModel serviceModel = serviceModelGenerator.generateService(service, serviceConfig, role, roleConfig);
                        serviceModels.add(serviceModel);
                    }
                }
            }
        }
        cluster.addServiceModels(serviceModels);
        return cluster;
    }

    private static ApiServiceList getClusterServices(ServicesResourceApi servicesResourceApi, String clusterName) {
        ApiServiceList services = null;
        try {
            services = servicesResourceApi.readServices(clusterName, VIEW_SUMMARY);
        }
        catch (ApiException e) {
            log.failedToAccessServiceConfigs(clusterName, (Exception)((Object)e));
        }
        return services;
    }

    private static ApiServiceConfig getServiceConfig(ServicesResourceApi servicesResourceApi, String clusterName, String serviceName) {
        ApiServiceConfig serviceConfig = null;
        try {
            serviceConfig = servicesResourceApi.readServiceConfig(clusterName, serviceName, VIEW_FULL);
        }
        catch (Exception e) {
            log.failedToAccessServiceConfigs(clusterName, e);
        }
        return serviceConfig;
    }

    private static ApiRoleList getRoles(RolesResourceApi rolesResourceApi, String clusterName, String serviceName) {
        ApiRoleList roles = null;
        try {
            roles = rolesResourceApi.readRoles(clusterName, serviceName, "", VIEW_SUMMARY);
        }
        catch (Exception e) {
            log.failedToAccessServiceRoleConfigs(clusterName, e);
        }
        return roles;
    }

    private static ApiConfigList getRoleConfig(RolesResourceApi rolesResourceApi, String clusterName, String serviceName, String roleName) {
        ApiConfigList configList = null;
        try {
            configList = rolesResourceApi.readRoleConfig(clusterName, roleName, serviceName, VIEW_FULL);
        }
        catch (Exception e) {
            log.failedToAccessServiceRoleConfigs(clusterName, e);
        }
        return configList;
    }
}

