/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl.html;

import java.util.Collections;
import java.util.List;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFunctionDescriptorFactory;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteFunctionProcessorFactory;
import org.apache.knox.gateway.filter.rewrite.impl.html.HtmlImportFunctionDescriptor;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteFunctionProcessor;

public class HtmlImportFunctionProcessor
implements UrlRewriteFunctionProcessor<HtmlImportFunctionDescriptor> {
    private static final String IMPORT_LITERAL = "@import";
    private UrlRewriteFunctionProcessor frontend;

    @Override
    public void initialize(UrlRewriteEnvironment environment, HtmlImportFunctionDescriptor descriptor) throws Exception {
        Object frontendDescriptor = UrlRewriteFunctionDescriptorFactory.create("frontend");
        this.frontend = UrlRewriteFunctionProcessorFactory.create("frontend", frontendDescriptor);
        this.frontend.initialize(environment, frontendDescriptor);
    }

    @Override
    public void destroy() throws Exception {
        this.frontend.destroy();
    }

    @Override
    public List<String> resolve(UrlRewriteContext context, List<String> parameters) throws Exception {
        String prefix = "";
        if (parameters != null && parameters.size() > 1) {
            prefix = parameters.get(0);
            parameters = parameters.subList(1, parameters.size());
        }
        List<String> frontendValues = this.frontend.resolve(context, parameters);
        StringBuilder buffer = new StringBuilder(IMPORT_LITERAL);
        buffer.append(' ').append(prefix);
        if (frontendValues != null && !frontendValues.isEmpty()) {
            for (String value : frontendValues) {
                buffer.append(value);
            }
        }
        return Collections.singletonList(buffer.toString());
    }

    @Override
    public String name() {
        return "import";
    }
}

