/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.j2e.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.config.ConfigBuilder;
import org.pac4j.core.config.ConfigSingleton;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.J2ENopHttpActionAdapter;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigFilter
implements Filter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Config config;

    public void init(FilterConfig filterConfig) throws ServletException {
        String configFactoryParam = filterConfig.getInitParameter("configFactory");
        if (configFactoryParam != null) {
            Config config = ConfigBuilder.build((String)configFactoryParam, (Object[])new Object[0]);
            this.setConfig(config);
        }
    }

    protected String getStringParam(FilterConfig filterConfig, String name, String defaultValue) {
        String param = filterConfig.getInitParameter(name);
        String value = param != null ? param : defaultValue;
        this.logger.debug("String param: {}: {}", (Object)name, (Object)value);
        return value;
    }

    protected Boolean getBooleanParam(FilterConfig filterConfig, String name, Boolean defaultValue) {
        String param = filterConfig.getInitParameter(name);
        Boolean value = param != null ? Boolean.valueOf(Boolean.parseBoolean(param)) : defaultValue;
        this.logger.debug("Boolean param: {}: {}", (Object)name, (Object)value);
        return value;
    }

    protected void checkForbiddenParameter(FilterConfig filterConfig, String name) {
        String parameter = this.getStringParam(filterConfig, name, null);
        if (CommonHelper.isNotBlank((String)parameter)) {
            String message = "the " + name + " servlet parameter is no longer supported";
            this.logger.error(message);
            throw new TechnicalException(message);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        this.internalFilter(req, resp, chain);
    }

    protected HttpActionAdapter<Object, J2EContext> retrieveHttpActionAdapter() {
        HttpActionAdapter configHttpActionAdapter;
        if (this.getConfig() != null && (configHttpActionAdapter = this.getConfig().getHttpActionAdapter()) != null) {
            return configHttpActionAdapter;
        }
        return J2ENopHttpActionAdapter.INSTANCE;
    }

    protected abstract void internalFilter(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws IOException, ServletException;

    public void destroy() {
    }

    public Config getConfig() {
        if (this.config == null) {
            return ConfigSingleton.getConfig();
        }
        return this.config;
    }

    public void setConfig(Config config) {
        CommonHelper.assertNotNull((String)"config", (Object)config);
        this.config = config;
        ConfigSingleton.setConfig((Config)config);
    }

    public void setConfigOnly(Config config) {
        CommonHelper.assertNotNull((String)"config", (Object)config);
        this.config = config;
    }
}

