/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.configuration;

import org.jasig.cas.client.configuration.ConfigurationStrategy;
import org.jasig.cas.client.configuration.JndiConfigurationStrategyImpl;
import org.jasig.cas.client.configuration.LegacyConfigurationStrategyImpl;
import org.jasig.cas.client.configuration.PropertiesConfigurationStrategyImpl;
import org.jasig.cas.client.configuration.SystemPropertiesConfigurationStrategyImpl;
import org.jasig.cas.client.configuration.WebXmlConfigurationStrategyImpl;
import org.jasig.cas.client.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ConfigurationStrategyName {
    DEFAULT(LegacyConfigurationStrategyImpl.class),
    JNDI(JndiConfigurationStrategyImpl.class),
    WEB_XML(WebXmlConfigurationStrategyImpl.class),
    PROPERTY_FILE(PropertiesConfigurationStrategyImpl.class),
    SYSTEM_PROPERTIES(SystemPropertiesConfigurationStrategyImpl.class);

    private static final Logger LOGGER;
    private final Class<? extends ConfigurationStrategy> configurationStrategyClass;

    private ConfigurationStrategyName(Class<? extends ConfigurationStrategy> configurationStrategyClass) {
        this.configurationStrategyClass = configurationStrategyClass;
    }

    public static Class<? extends ConfigurationStrategy> resolveToConfigurationStrategy(String value) {
        if (CommonUtils.isBlank(value)) {
            return ConfigurationStrategyName.DEFAULT.configurationStrategyClass;
        }
        for (ConfigurationStrategyName csn : ConfigurationStrategyName.values()) {
            if (!csn.name().equalsIgnoreCase(value)) continue;
            return csn.configurationStrategyClass;
        }
        try {
            Class<?> clazz = Class.forName(value);
            if (ConfigurationStrategy.class.isAssignableFrom(clazz)) {
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Unable to locate strategy {} by name or class name.  Using default strategy instead.", (Object)value, (Object)e);
        }
        return ConfigurationStrategyName.DEFAULT.configurationStrategyClass;
    }

    static {
        LOGGER = LoggerFactory.getLogger(ConfigurationStrategyName.class);
    }
}

