/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.deploy.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.knox.gateway.topology.Provider;

public class ShiroConfig {
    private Map<String, Map<String, String>> sections = new LinkedHashMap<String, Map<String, String>>();

    public ShiroConfig(Provider provider, String clusterName) {
        Map params = provider.getParams();
        params.putIfAbsent("main.invalidRequest.blockSemicolon", "false");
        params.putIfAbsent("main.invalidRequest.blockBackslash", "false");
        params.putIfAbsent("main.invalidRequest.blockNonAscii", "false");
        for (Map.Entry entry : params.entrySet()) {
            int sectionDot = ((String)entry.getKey()).indexOf(46);
            if (sectionDot <= 0) continue;
            String sectionName = ((String)entry.getKey()).substring(0, sectionDot);
            String name = ((String)entry.getKey()).substring(sectionDot + 1);
            String value = ((String)entry.getValue()).trim();
            if (value.startsWith("${ALIAS=") && value.endsWith("}")) {
                String baseName = name.substring(0, name.lastIndexOf(46));
                this.addNameValueToSection(baseName + ".clusterName", clusterName, sectionName);
                this.addNameValueToSection(name, "S" + value.substring(1), sectionName);
                continue;
            }
            this.addNameValueToSection(name, value, sectionName);
        }
    }

    private void addNameValueToSection(String name, String value, String sectionName) {
        Map section = this.sections.computeIfAbsent(sectionName, k -> new LinkedHashMap());
        section.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Map<String, String>> section : this.sections.entrySet()) {
            sb.append('[').append(section.getKey()).append("]\n");
            for (Map.Entry<String, String> entry : section.getValue().entrySet()) {
                sb.append(entry.getKey()).append('=').append(entry.getValue()).append('\n');
            }
        }
        return sb.toString();
    }
}

