/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.cm;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class ClouderaManagerAPIServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "CM-API";
    public static final String SERVICE_TYPE = "CM";
    public static final String ROLE_TYPE = "CM_SERVER";

    @Override
    public String getService() {
        return SERVICE;
    }

    @Override
    public String getServiceType() {
        return SERVICE_TYPE;
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.API;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig, ApiServiceConfig coreSettingsConfig) throws ApiException {
        URI uri;
        String basePath = this.getClient().getBasePath();
        try {
            uri = new URI(basePath);
        }
        catch (URISyntaxException e) {
            throw new ApiException((Throwable)e);
        }
        String serviceURL = this.getModelType() == ServiceModel.Type.API ? String.format(Locale.getDefault(), "%s://%s:%s/api", uri.getScheme(), uri.getHost(), uri.getPort()) : String.format(Locale.getDefault(), "%s://%s:%s", uri.getScheme(), uri.getHost(), uri.getPort());
        return new ServiceModel(this.getModelType(), this.getService(), this.getServiceType(), this.getRoleType(), serviceURL);
    }
}

