﻿// LUCENENET specific - This is the content of QueryParserMessages.Designer that was generated, with customizations.
// The NLS derived class was replaced with this one to make interop with .NET resources easier.
//
// We turned off auto-generation of this file and added a SetResourceProvider() to supply a class that can supply string/object localized resources.
// This allows end users to supply localized messages.
//
// 1. Add a Resource (.resx) to the project.
// 2. Add any of the below properties as the resource names, and supply messages as desired.
// 3. Call QueryParserMessages.SetResourceProvider(new QueryParserResourceProvider(SomeResource.ResourceManager)) at application startup and supply the ResourceManager of the custom Resource's designer.


using Lucene.Net.Util;
using System;
using System.ComponentModel;
using System.Globalization;
#nullable enable

namespace Lucene.Net.QueryParsers.Flexible.Core.Messages
{
    /*
     * Licensed to the Apache Software Foundation (ASF) under one or more
     * contributor license agreements.  See the NOTICE file distributed with
     * this work for additional information regarding copyright ownership.
     * The ASF licenses this file to You under the Apache License, Version 2.0
     * (the "License"); you may not use this file except in compliance with
     * the License.  You may obtain a copy of the License at
     *
     *     http://www.apache.org/licenses/LICENSE-2.0
     *
     * Unless required by applicable law or agreed to in writing, software
     * distributed under the License is distributed on an "AS IS" BASIS,
     * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
     * See the License for the specific language governing permissions and
     * limitations under the License.
     */

    /// <summary>
    /// A strongly-typed resource class, for looking up localized strings, etc.
    /// <para/>
    /// The localized resources can be replaced by end users by calling the <see cref="SetResourceProvider(IResourceProvider)"/>
    /// method and supplying an instance of <see cref="QueryParserResourceProvider"/> with custom
    /// <see cref="System.Resources.ResourceManager"/> instances provided in its constructor.
    /// <code>
    /// QueryParserMessages.SetResourceProvider(new QueryParserResourceProvider(SomeResource.ResourceManager, SomeOtherResource.ResourceManager));
    /// </code>
    /// <c>SomeResource</c> and <c>SomeOtherResource</c> are auto-generated designer classes which can be generated by Visual Studio when adding
    /// resource files (.resx) to a project. These resources can optionally be localized in different cultures and optionally be distributed as satellite
    /// assemblies. See the <see cref="System.Resources.ResourceManager"/> documentation for tips on how to get started, but do note this is a broad topic.
    /// <para/>
    /// <see cref="QueryParserResourceProvider"/> makes no assumptions on the method used to generate or deploy resources, the only requirement is that you provide
    /// a <see cref="System.Resources.ResourceManager"/> that can find them. Note that it is also possible to subclass <see cref="QueryParserResourceProvider"/>
    /// or implement <see cref="IResourceProvider"/> directly to provide resources from any source.
    /// </summary>
    // LUCENENET NOTE: Since we are not using a custom tool to generate this file, any additions/deletions to the
    // QueryParserMessages.resx file must be done to this class manually.
    public static class QueryParserMessages
    {
        private static CultureInfo? resourceCulture;
        private static IResourceProvider resourceProvider = new QueryParserResourceProvider();

        /// <summary>
        /// Gets the associated resource provider.
        /// </summary>
        /// <returns>The current resource provider.</returns>
        /// <seealso cref="SetResourceProvider(IResourceProvider)"/>
        public static IResourceProvider GetResourceProvider()
        {
            return resourceProvider;
        }

        /// <summary>
        /// Sets the <see cref="IResourceProvider"/> instance used to provide
        /// localized <see cref="string"/>s and <see cref="object"/>s.
        /// </summary>
        /// <param name="provider">The new <see cref="IResourceProvider"/>.</param>
        /// <exception cref="ArgumentNullException">The <paramref name="provider"/> parameter is <c>null</c>.</exception>
        /// <seealso cref="GetResourceProvider()"/>
        public static void SetResourceProvider(IResourceProvider provider)
        {
            resourceProvider = provider ?? throw new ArgumentNullException(nameof(provider));
        }

        private static string? GetString(string name, CultureInfo? culture)
        {
            return resourceProvider.GetString(name, culture);
        }

        /// <summary>
        ///   Overrides the current thread's CurrentUICulture property for all
        ///   resource lookups using this strongly typed resource class.
        /// </summary>
        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
        public static CultureInfo? Culture
        {
            get => resourceCulture;
            set => resourceCulture = value;
        }

        /// <summary>
        ///   Looks up a localized string similar to Value cannot be null..
        /// </summary>
        public static string? ARGUMENT_CANNOT_BE_NULL => GetString("ARGUMENT_CANNOT_BE_NULL", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to Could not parse text &quot;{0}&quot; using {1}.
        /// </summary>
        public static string? COULD_NOT_PARSE_NUMBER => GetString("COULD_NOT_PARSE_NUMBER", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to .
        /// </summary>
        public static string? EMPTY_MESSAGE => GetString("EMPTY_MESSAGE", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to Syntax Error: {0}.
        /// </summary>
        public static string? INVALID_SYNTAX => GetString("INVALID_SYNTAX", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to Syntax Error, cannot parse {0}: {1}.
        /// </summary>
        public static string? INVALID_SYNTAX_CANNOT_PARSE => GetString("INVALID_SYNTAX_CANNOT_PARSE", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to Term can not end with escape character..
        /// </summary>
        public static string? INVALID_SYNTAX_ESCAPE_CHARACTER => GetString("INVALID_SYNTAX_ESCAPE_CHARACTER", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to Non-hex character in Unicode escape sequence: {0}.
        /// </summary>
        public static string? INVALID_SYNTAX_ESCAPE_NONE_HEX_UNICODE => GetString("INVALID_SYNTAX_ESCAPE_NONE_HEX_UNICODE", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to Truncated unicode escape sequence..
        /// </summary>
        public static string? INVALID_SYNTAX_ESCAPE_UNICODE_TRUNCATION => GetString("INVALID_SYNTAX_ESCAPE_UNICODE_TRUNCATION", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to Fractional edit distances are not allowed..
        /// </summary>
        public static string? INVALID_SYNTAX_FUZZY_EDITS => GetString("INVALID_SYNTAX_FUZZY_EDITS", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to The similarity value for a fuzzy search must be between 0.0 and 1.0..
        /// </summary>
        public static string? INVALID_SYNTAX_FUZZY_LIMITS => GetString("INVALID_SYNTAX_FUZZY_LIMITS", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to Leading wildcard is not allowed: {0}.
        /// </summary>
        public static string? LEADING_WILDCARD_NOT_ALLOWED => GetString("LEADING_WILDCARD_NOT_ALLOWED", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to Cannot convert query to lucene syntax: {0} error: {1}.
        /// </summary>
        public static string? LUCENE_QUERY_CONVERSION_ERROR => GetString("LUCENE_QUERY_CONVERSION_ERROR", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to This node does not support this action..
        /// </summary>
        public static string? NODE_ACTION_NOT_SUPPORTED => GetString("NODE_ACTION_NOT_SUPPORTED", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to The parameter must be greater than or equal to zero..
        /// </summary>
        public static string? NUMBER_CANNOT_BE_NEGATIVE => GetString("NUMBER_CANNOT_BE_NEGATIVE", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to Number class not supported by NumericRangeQueryNode: {0}.
        /// </summary>
        public static string? NUMBER_CLASS_NOT_SUPPORTED_BY_NUMERIC_RANGE_QUERY => GetString("NUMBER_CLASS_NOT_SUPPORTED_BY_NUMERIC_RANGE_QUERY", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to Field &quot;{0}&quot; is numeric and cannot have an empty value..
        /// </summary>
        public static string? NUMERIC_CANNOT_BE_EMPTY => GetString("NUMERIC_CANNOT_BE_EMPTY", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to Parameter {1} with value {0} not supported..
        /// </summary>
        public static string? PARAMETER_VALUE_NOT_SUPPORTED => GetString("PARAMETER_VALUE_NOT_SUPPORTED", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to Too many boolean clauses, the maximum supported is {0}: {1}.
        /// </summary>
        public static string? TOO_MANY_BOOLEAN_CLAUSES => GetString("TOO_MANY_BOOLEAN_CLAUSES", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to Unsupported NumericField.DataType: {0}.
        /// </summary>
        public static string? UNSUPPORTED_NUMERIC_DATA_TYPE => GetString("UNSUPPORTED_NUMERIC_DATA_TYPE", resourceCulture);

        /// <summary>
        ///   Looks up a localized string similar to Wildcard is not supported for query: {0}.
        /// </summary>
        public static string? WILDCARD_NOT_SUPPORTED => GetString("WILDCARD_NOT_SUPPORTED", resourceCulture);
    }
}
