/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import com.jmatio.io.MatFileHeader;
import com.jmatio.io.MatlabIOException;
import com.jmatio.io.OSArrayTag;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLCell;
import com.jmatio.types.MLChar;
import com.jmatio.types.MLNumericArray;
import com.jmatio.types.MLSparse;
import com.jmatio.types.MLStructure;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatFileWriter {
    public MatFileWriter() {
    }

    public MatFileWriter(String fileName, Collection<MLArray> data) throws IOException {
        this(new File(fileName), data);
    }

    public MatFileWriter(File file, Collection<MLArray> data) throws IOException {
        this(new FileOutputStream(file).getChannel(), data);
    }

    public MatFileWriter(WritableByteChannel channel, Collection<MLArray> data) throws IOException {
        this.write(channel, data);
    }

    public synchronized void write(String filepath, Collection<MLArray> data) throws IOException {
        this.write(new File(filepath), data);
    }

    public synchronized void write(File file, Collection<MLArray> data) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            this.write(fos.getChannel(), data);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            fos.close();
            throw throwable;
        }
        fos.close();
    }

    private synchronized void write(WritableByteChannel channel, Collection<MLArray> data) throws IOException {
        try {
            this.writeHeader(channel);
            for (MLArray matrix : data) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                this.writeMatrix(dos, matrix);
                Deflater compresser = new Deflater();
                byte[] input = baos.toByteArray();
                ByteArrayOutputStream compressed = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(new DeflaterOutputStream((OutputStream)compressed, compresser));
                dout.write(input);
                dout.close();
                compressed.close();
                byte[] compressedBytes = compressed.toByteArray();
                ByteBuffer buf = ByteBuffer.allocateDirect(8 + compressedBytes.length);
                buf.putInt(15);
                buf.putInt(compressedBytes.length);
                buf.put(compressedBytes);
                buf.flip();
                channel.write(buf);
            }
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            channel.close();
            throw throwable;
        }
        channel.close();
    }

    private void writeHeader(WritableByteChannel channel) throws IOException {
        MatFileHeader header = MatFileHeader.createHeader();
        char[] dest = new char[116];
        char[] src = header.getDescription().toCharArray();
        System.arraycopy(src, 0, dest, 0, src.length);
        byte[] endianIndicator = header.getEndianIndicator();
        ByteBuffer buf = ByteBuffer.allocateDirect(dest.length * 2 + 2 + endianIndicator.length);
        for (int i = 0; i < dest.length; ++i) {
            buf.put((byte)dest[i]);
        }
        buf.position(buf.position() + 8);
        int version = header.getVersion();
        buf.put((byte)(version >> 8));
        buf.put((byte)version);
        buf.put(endianIndicator);
        buf.flip();
        channel.write(buf);
    }

    private void writeMatrix(DataOutputStream output, MLArray array) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        this.writeFlags(dos, array);
        this.writeDimensions(dos, array);
        this.writeName(dos, array);
        switch (array.getType()) {
            case 4: {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                DataOutputStream bufferDOS = new DataOutputStream(buffer);
                Character[] ac = ((MLChar)array).exportChar();
                for (int i = 0; i < ac.length; ++i) {
                    String temp = new StringBuffer().append(ac[i].charValue()).toString();
                    bufferDOS.write(temp.getBytes("UTF-8"));
                }
                OSArrayTag tag = new OSArrayTag(16, buffer.toByteArray());
                tag.writeTo(dos);
                break;
            }
            case 6: {
                OSArrayTag tag = new OSArrayTag(9, ((MLNumericArray)array).getRealByteBuffer());
                tag.writeTo(dos);
                if (!array.isComplex()) break;
                tag = new OSArrayTag(9, ((MLNumericArray)array).getImaginaryByteBuffer());
                tag.writeTo(dos);
                break;
            }
            case 7: {
                OSArrayTag tag = new OSArrayTag(7, ((MLNumericArray)array).getRealByteBuffer());
                tag.writeTo(dos);
                if (!array.isComplex()) break;
                tag = new OSArrayTag(7, ((MLNumericArray)array).getImaginaryByteBuffer());
                tag.writeTo(dos);
                break;
            }
            case 9: {
                OSArrayTag tag = new OSArrayTag(2, ((MLNumericArray)array).getRealByteBuffer());
                tag.writeTo(dos);
                if (!array.isComplex()) break;
                tag = new OSArrayTag(2, ((MLNumericArray)array).getImaginaryByteBuffer());
                tag.writeTo(dos);
                break;
            }
            case 8: {
                OSArrayTag tag = new OSArrayTag(1, ((MLNumericArray)array).getRealByteBuffer());
                tag.writeTo(dos);
                if (!array.isComplex()) break;
                tag = new OSArrayTag(1, ((MLNumericArray)array).getImaginaryByteBuffer());
                tag.writeTo(dos);
                break;
            }
            case 10: {
                OSArrayTag tag = new OSArrayTag(3, ((MLNumericArray)array).getRealByteBuffer());
                tag.writeTo(dos);
                if (!array.isComplex()) break;
                tag = new OSArrayTag(3, ((MLNumericArray)array).getImaginaryByteBuffer());
                tag.writeTo(dos);
                break;
            }
            case 14: {
                OSArrayTag tag = new OSArrayTag(12, ((MLNumericArray)array).getRealByteBuffer());
                tag.writeTo(dos);
                if (!array.isComplex()) break;
                tag = new OSArrayTag(12, ((MLNumericArray)array).getImaginaryByteBuffer());
                tag.writeTo(dos);
                break;
            }
            case 15: {
                OSArrayTag tag = new OSArrayTag(13, ((MLNumericArray)array).getRealByteBuffer());
                tag.writeTo(dos);
                if (!array.isComplex()) break;
                tag = new OSArrayTag(13, ((MLNumericArray)array).getImaginaryByteBuffer());
                tag.writeTo(dos);
                break;
            }
            case 2: {
                int itag = 262149;
                dos.writeInt(itag);
                dos.writeInt(((MLStructure)array).getMaxFieldLenth());
                OSArrayTag tag = new OSArrayTag(1, ((MLStructure)array).getKeySetToByteArray());
                tag.writeTo(dos);
                for (MLArray a : ((MLStructure)array).getAllFields()) {
                    this.writeMatrix(dos, a);
                }
                break;
            }
            case 1: {
                for (MLArray a : ((MLCell)array).cells()) {
                    this.writeMatrix(dos, a);
                }
                break;
            }
            case 5: {
                int i;
                int[] ai;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                DataOutputStream bufferDOS = new DataOutputStream(buffer);
                for (int i2 : ai = ((MLSparse)array).getIR()) {
                    bufferDOS.writeInt(i2);
                }
                OSArrayTag tag = new OSArrayTag(5, buffer.toByteArray());
                tag.writeTo(dos);
                buffer = new ByteArrayOutputStream();
                bufferDOS = new DataOutputStream(buffer);
                for (int i2 : ai = ((MLSparse)array).getJC()) {
                    bufferDOS.writeInt(i2);
                }
                tag = new OSArrayTag(5, buffer.toByteArray());
                tag.writeTo(dos);
                buffer = new ByteArrayOutputStream();
                bufferDOS = new DataOutputStream(buffer);
                Double[] ad = ((MLSparse)array).exportReal();
                for (i = 0; i < ad.length; ++i) {
                    bufferDOS.writeDouble(ad[i]);
                }
                tag = new OSArrayTag(9, buffer.toByteArray());
                tag.writeTo(dos);
                if (!array.isComplex()) break;
                buffer = new ByteArrayOutputStream();
                bufferDOS = new DataOutputStream(buffer);
                ad = ((MLSparse)array).exportImaginary();
                for (i = 0; i < ad.length; ++i) {
                    bufferDOS.writeDouble(ad[i]);
                }
                tag = new OSArrayTag(9, buffer.toByteArray());
                tag.writeTo(dos);
                break;
            }
            default: {
                throw new MatlabIOException("Cannot write matrix of type: " + MLArray.typeToString(array.getType()));
            }
        }
        output.writeInt(14);
        output.writeInt(baos.size());
        output.write(baos.toByteArray());
    }

    private void writeFlags(DataOutputStream os, MLArray array) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream bufferDOS = new DataOutputStream(buffer);
        bufferDOS.writeInt(array.getFlags());
        if (array.isSparse()) {
            bufferDOS.writeInt(((MLSparse)array).getMaxNZ());
        } else {
            bufferDOS.writeInt(0);
        }
        OSArrayTag tag = new OSArrayTag(6, buffer.toByteArray());
        tag.writeTo(os);
    }

    private void writeDimensions(DataOutputStream os, MLArray array) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream bufferDOS = new DataOutputStream(buffer);
        int[] dims = array.getDimensions();
        for (int i = 0; i < dims.length; ++i) {
            bufferDOS.writeInt(dims[i]);
        }
        OSArrayTag tag = new OSArrayTag(5, buffer.toByteArray());
        tag.writeTo(os);
    }

    private void writeName(DataOutputStream os, MLArray array) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream bufferDOS = new DataOutputStream(buffer);
        byte[] nameByteArray = array.getNameToByteArray();
        buffer = new ByteArrayOutputStream();
        bufferDOS = new DataOutputStream(buffer);
        bufferDOS.write(nameByteArray);
        OSArrayTag tag = new OSArrayTag(1, buffer.toByteArray());
        tag.writeTo(os);
    }
}

