/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.Headers;
import com.sun.xml.internal.ws.developer.StreamingAttachmentFeature;
import com.sun.xml.internal.ws.developer.WSBindingProvider;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SunJREPortProvider
extends AbstractPortProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SunJREPortProvider.class);

    protected BindingProvider createPortObject(AbstractPortProvider.CmisServiceHolder serviceHolder) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session {}: Creating Web Service port object of {} ...", (Object)this.getSession().getSessionId(), (Object)serviceHolder.getServiceName());
        }
        try {
            int readTimeout;
            WebServiceFeature[] features;
            if (serviceHolder.getService().handlesContent()) {
                int threshold = this.getSession().get("org.apache.chemistry.opencmis.binding.webservices.memoryThreshold", 0x400000);
                features = new WebServiceFeature[]{new MTOMFeature(), new StreamingAttachmentFeature(null, true, (long)threshold)};
            } else {
                features = new WebServiceFeature[]{new MTOMFeature()};
            }
            BindingProvider portObject = this.createPortObjectFromServiceHolder(serviceHolder, features);
            if (serviceHolder.getService().handlesContent()) {
                portObject.getRequestContext().put("com.sun.xml.internal.ws.transport.http.client.streaming.chunk.size", 65535);
            }
            AuthenticationProvider authProvider = CmisBindingsHelper.getAuthenticationProvider(this.getSession());
            Map httpHeaders = null;
            if (authProvider != null) {
                HostnameVerifier hv;
                Element soapHeader = authProvider.getSOAPHeaders((Object)portObject);
                if (soapHeader != null) {
                    ((WSBindingProvider)portObject).setOutboundHeaders(new Header[]{Headers.create((Element)soapHeader)});
                }
                String url = serviceHolder.getEndpointUrl() != null ? serviceHolder.getEndpointUrl().toString() : serviceHolder.getServiceObject().getWSDLDocumentLocation().toString();
                httpHeaders = authProvider.getHTTPHeaders(url);
                SSLSocketFactory sf = authProvider.getSSLSocketFactory();
                if (sf != null) {
                    portObject.getRequestContext().put("com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory", sf);
                }
                if ((hv = authProvider.getHostnameVerifier()) != null) {
                    portObject.getRequestContext().put("com.sun.xml.internal.ws.transport.https.client.hostname.verifier", hv);
                }
            }
            this.setHTTPHeaders(portObject, httpHeaders);
            this.setEndpointUrl(portObject, serviceHolder.getEndpointUrl());
            int connectTimeout = this.getSession().get("org.apache.chemistry.opencmis.binding.connecttimeout", -1);
            if (connectTimeout >= 0) {
                portObject.getRequestContext().put("com.sun.xml.internal.ws.connect.timeout", connectTimeout);
            }
            if ((readTimeout = this.getSession().get("org.apache.chemistry.opencmis.binding.readtimeout", -1)) >= 0) {
                portObject.getRequestContext().put("com.sun.xml.internal.ws.request.timeout", readTimeout);
            }
            return portObject;
        }
        catch (CmisBaseException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CmisConnectionException("Cannot initalize Web Services port object: " + e.getMessage(), (Throwable)e);
        }
    }
}

