/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.SubqueryNode;

public class SubqueryList
extends QueryTreeNodeVector {
    public void addSubqueryNode(SubqueryNode subqueryNode) throws StandardException {
        this.addElement(subqueryNode);
    }

    public void optimize(DataDictionary dataDictionary, double d) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            SubqueryNode subqueryNode = (SubqueryNode)this.elementAt(i);
            subqueryNode.optimize(dataDictionary, d);
        }
    }

    public void modifyAccessPaths() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            SubqueryNode subqueryNode = (SubqueryNode)this.elementAt(i);
            subqueryNode.modifyAccessPaths();
        }
    }

    public boolean referencesTarget(String string, boolean bl) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            SubqueryNode subqueryNode = (SubqueryNode)this.elementAt(i);
            if (subqueryNode.isMaterializable() || !subqueryNode.getResultSet().referencesTarget(string, bl)) continue;
            return true;
        }
        return false;
    }

    public boolean referencesSessionSchema() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            SubqueryNode subqueryNode = (SubqueryNode)this.elementAt(i);
            if (!subqueryNode.referencesSessionSchema()) continue;
            return true;
        }
        return false;
    }

    public void setPointOfAttachment(int n) throws StandardException {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            SubqueryNode subqueryNode = (SubqueryNode)this.elementAt(i);
            subqueryNode.setPointOfAttachment(n);
        }
    }

    void decrementLevel(int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            ((SubqueryNode)this.elementAt(i)).getResultSet().decrementLevel(n);
        }
    }

    public void markHavingSubqueries() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            SubqueryNode subqueryNode = (SubqueryNode)this.elementAt(i);
            subqueryNode.setHavingSubquery(true);
        }
    }

    public void markWhereSubqueries() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            SubqueryNode subqueryNode = (SubqueryNode)this.elementAt(i);
            subqueryNode.setWhereSubquery(true);
        }
    }
}

