/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.vectorhighlight;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.FilterClause;
import org.apache.lucene.queries.TermFilter;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQueryWrapperFilter;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.vectorhighlight.FastVectorHighlighter;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.lucene.search.function.FiltersFunctionScoreQuery;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;

public class CustomFieldQuery
extends FieldQuery {
    private static Field multiTermQueryWrapperFilterQueryField;
    public static final ThreadLocal<Boolean> highlightFilters;

    public CustomFieldQuery(Query query, IndexReader reader, FastVectorHighlighter highlighter) throws IOException {
        this(query, reader, highlighter.isPhraseHighlight(), highlighter.isFieldMatch());
    }

    public CustomFieldQuery(Query query, IndexReader reader, boolean phraseHighlight, boolean fieldMatch) throws IOException {
        super(query, reader, phraseHighlight, fieldMatch);
        highlightFilters.remove();
    }

    void flatten(Query sourceQuery, IndexReader reader, Collection<Query> flatQueries) throws IOException {
        if (sourceQuery instanceof SpanTermQuery) {
            super.flatten((Query)new TermQuery(((SpanTermQuery)sourceQuery).getTerm()), reader, flatQueries);
        } else if (sourceQuery instanceof ConstantScoreQuery) {
            ConstantScoreQuery constantScoreQuery = (ConstantScoreQuery)sourceQuery;
            if (constantScoreQuery.getFilter() != null) {
                this.flatten(constantScoreQuery.getFilter(), reader, flatQueries);
            } else {
                this.flatten(constantScoreQuery.getQuery(), reader, flatQueries);
            }
        } else if (sourceQuery instanceof FunctionScoreQuery) {
            this.flatten(((FunctionScoreQuery)sourceQuery).getSubQuery(), reader, flatQueries);
        } else if (sourceQuery instanceof FilteredQuery) {
            this.flatten(((FilteredQuery)sourceQuery).getQuery(), reader, flatQueries);
            this.flatten(((FilteredQuery)sourceQuery).getFilter(), reader, flatQueries);
        } else if (sourceQuery instanceof XFilteredQuery) {
            this.flatten(((XFilteredQuery)sourceQuery).getQuery(), reader, flatQueries);
            this.flatten(((XFilteredQuery)sourceQuery).getFilter(), reader, flatQueries);
        } else if (sourceQuery instanceof MultiPhrasePrefixQuery) {
            this.flatten(sourceQuery.rewrite(reader), reader, flatQueries);
        } else if (sourceQuery instanceof FiltersFunctionScoreQuery) {
            this.flatten(((FiltersFunctionScoreQuery)sourceQuery).getSubQuery(), reader, flatQueries);
        } else if (sourceQuery instanceof MultiPhraseQuery) {
            MultiPhraseQuery q = (MultiPhraseQuery)sourceQuery;
            this.convertMultiPhraseQuery(0, new int[q.getTermArrays().size()], q, q.getTermArrays(), q.getPositions(), reader, flatQueries);
        } else {
            super.flatten(sourceQuery, reader, flatQueries);
        }
    }

    private void convertMultiPhraseQuery(int currentPos, int[] termsIdx, MultiPhraseQuery orig, List<Term[]> terms, int[] pos, IndexReader reader, Collection<Query> flatQueries) throws IOException {
        if (currentPos == 0) {
            int numTerms = 0;
            for (Term[] currentPosTerm : terms) {
                numTerms += currentPosTerm.length;
            }
            if (numTerms > 16) {
                for (Term[] currentPosTerm : terms) {
                    for (Term term : currentPosTerm) {
                        super.flatten((Query)new TermQuery(term), reader, flatQueries);
                    }
                }
                return;
            }
        }
        if (currentPos == terms.size()) {
            PhraseQuery query = new PhraseQuery();
            query.setBoost(orig.getBoost());
            query.setSlop(orig.getSlop());
            for (int i = 0; i < termsIdx.length; ++i) {
                query.add(terms.get(i)[termsIdx[i]], pos[i]);
            }
            this.flatten((Query)query, reader, flatQueries);
        } else {
            Term[] t = terms.get(currentPos);
            int i = 0;
            while (i < t.length) {
                termsIdx[currentPos] = i++;
                this.convertMultiPhraseQuery(currentPos + 1, termsIdx, orig, terms, pos, reader, flatQueries);
            }
        }
    }

    void flatten(Filter sourceFilter, IndexReader reader, Collection<Query> flatQueries) throws IOException {
        Boolean highlight = highlightFilters.get();
        if (highlight == null || highlight.equals(Boolean.FALSE)) {
            return;
        }
        if (sourceFilter instanceof TermFilter) {
            this.flatten((Query)new TermQuery(((TermFilter)sourceFilter).getTerm()), reader, flatQueries);
        } else if (sourceFilter instanceof MultiTermQueryWrapperFilter) {
            if (multiTermQueryWrapperFilterQueryField != null) {
                try {
                    this.flatten((Query)multiTermQueryWrapperFilterQueryField.get(sourceFilter), reader, flatQueries);
                }
                catch (IllegalAccessException e) {}
            }
        } else if (sourceFilter instanceof XBooleanFilter) {
            XBooleanFilter booleanFilter = (XBooleanFilter)sourceFilter;
            for (FilterClause clause : booleanFilter.clauses()) {
                if (clause.getOccur() != BooleanClause.Occur.MUST && clause.getOccur() != BooleanClause.Occur.SHOULD) continue;
                this.flatten(clause.getFilter(), reader, flatQueries);
            }
        }
    }

    static {
        try {
            multiTermQueryWrapperFilterQueryField = MultiTermQueryWrapperFilter.class.getDeclaredField("query");
            multiTermQueryWrapperFilterQueryField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        highlightFilters = new ThreadLocal();
    }
}

