/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;

abstract class AbstractHash
implements Releasable {
    static final float DEFAULT_MAX_LOAD_FACTOR = 0.6f;
    final float maxLoadFactor;
    long size;
    long maxSize;
    LongArray ids;
    long mask;

    AbstractHash(long capacity, float maxLoadFactor, PageCacheRecycler recycler) {
        Preconditions.checkArgument(capacity >= 0L, "capacity must be >= 0");
        Preconditions.checkArgument(maxLoadFactor > 0.0f && maxLoadFactor < 1.0f, "maxLoadFactor must be > 0 and < 1");
        this.maxLoadFactor = maxLoadFactor;
        long buckets = 1L + (long)((float)capacity / maxLoadFactor);
        buckets = Math.max(1L, Long.highestOneBit(buckets - 1L) << 1);
        assert (buckets == Long.highestOneBit(buckets));
        this.maxSize = (long)((float)buckets * maxLoadFactor);
        assert (this.maxSize >= capacity);
        this.size = 0L;
        this.ids = BigArrays.newLongArray(buckets, recycler, true);
        this.mask = buckets - 1L;
    }

    public long capacity() {
        return this.ids.size();
    }

    public long size() {
        return this.size;
    }

    static long slot(long hash, long mask) {
        return hash & mask;
    }

    static long nextSlot(long curSlot, long mask) {
        return curSlot + 1L & mask;
    }

    public long id(long index) {
        return this.ids.get(index) - 1L;
    }

    protected final long id(long index, long id) {
        return this.ids.set(index, id + 1L) - 1L;
    }

    protected void resizeKeys(long capacity) {
    }

    protected abstract void removeAndAdd(long var1, long var3);

    protected final void grow() {
        long id;
        long i;
        assert (this.size == this.maxSize);
        long prevSize = this.size;
        long buckets = this.capacity();
        long newBuckets = buckets << 1;
        assert (newBuckets == Long.highestOneBit(newBuckets)) : newBuckets;
        this.resizeKeys(newBuckets);
        this.ids = BigArrays.resize(this.ids, newBuckets);
        this.mask = newBuckets - 1L;
        for (i = 0L; i < buckets; ++i) {
            id = this.id(i, -1L);
            if (id == -1L) continue;
            this.removeAndAdd(i, id);
        }
        for (i = buckets; i < newBuckets && (id = this.id(i, -1L)) != -1L; ++i) {
            this.removeAndAdd(i, id);
        }
        assert (this.size == prevSize);
        this.maxSize = (long)((float)newBuckets * this.maxLoadFactor);
        assert (this.size < this.maxSize);
    }

    @Override
    public boolean release() {
        Releasables.release(this.ids);
        return true;
    }
}

