/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import org.apache.sis.metadata.MetadataVisitor;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.ValueExistencePolicy;

final class HashCode
extends MetadataVisitor<Integer> {
    private static final ThreadLocal<HashCode> VISITORS = ThreadLocal.withInitial(HashCode::new);
    private int code;

    private HashCode() {
    }

    static HashCode getOrCreate() {
        return VISITORS.get();
    }

    @Override
    final ThreadLocal<HashCode> creator() {
        return VISITORS;
    }

    @Override
    MetadataVisitor.Filter preVisit(PropertyAccessor propertyAccessor) {
        this.code = propertyAccessor.type.hashCode();
        return MetadataVisitor.Filter.NON_EMPTY;
    }

    @Override
    Object visit(Class<?> clazz, Object object) {
        if (!ValueExistencePolicy.isNullOrEmpty(object)) {
            int n = this.code;
            this.code = n += object.hashCode();
        }
        return object;
    }

    @Override
    Integer result() {
        return this.code;
    }
}

