/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.region;

import java.io.BufferedWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.utils.collections.DictionaryAsMap;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.internal.download.DownloadManager;
import org.apache.karaf.features.internal.download.Downloader;
import org.apache.karaf.features.internal.download.StreamProvider;
import org.apache.karaf.features.internal.region.RepositoryManager;
import org.apache.karaf.features.internal.region.Subsystem;
import org.apache.karaf.features.internal.region.SubsystemResolveContext;
import org.apache.karaf.features.internal.resolver.BaseClause;
import org.apache.karaf.features.internal.resolver.CapabilityImpl;
import org.apache.karaf.features.internal.resolver.CapabilitySet;
import org.apache.karaf.features.internal.resolver.RequirementImpl;
import org.apache.karaf.features.internal.resolver.ResolverUtil;
import org.apache.karaf.features.internal.resolver.ResourceBuilder;
import org.apache.karaf.features.internal.resolver.ResourceImpl;
import org.apache.karaf.features.internal.resolver.SimpleFilter;
import org.apache.karaf.features.internal.util.JsonWriter;
import org.apache.karaf.features.internal.util.MapUtils;
import org.eclipse.equinox.internal.region.StandardRegionDigraph;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.repository.Repository;
import org.osgi.service.resolver.ResolveContext;
import org.osgi.service.resolver.Resolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsystemResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubsystemResolver.class);
    private DownloadManager manager;
    private Resolver resolver;
    private RegionDigraph digraph;
    private Subsystem root;
    private Map<Resource, List<Wire>> wiring;
    private ResourceImpl environmentResource;
    private Map<String, String> flatSubsystemsMap;
    private Map<String, Set<Resource>> bundlesPerRegions;
    private Map<Resource, String> bundles;
    private Map<String, Set<Resource>> featuresPerRegions;
    private Map<Resource, String> features;
    private RegionDigraph flatDigraph;
    private Map<String, Map<String, BundleInfo>> bundleInfos;

    public SubsystemResolver(Resolver resolver, DownloadManager manager) {
        this.resolver = resolver;
        this.manager = manager;
    }

    /*
     * WARNING - void declaration
     */
    public void prepare(Collection<Feature> allFeatures, Map<String, Set<String>> requirements, Map<String, Set<BundleRevision>> system) throws Exception {
        for (Map.Entry<String, Set<String>> entry : requirements.entrySet()) {
            void var7_8;
            String[] parts = entry.getKey().split("/");
            if (this.root == null) {
                this.root = new Subsystem((String)parts[0]);
            } else if (!this.root.getName().equals(parts[0])) {
                throw new IllegalArgumentException("Can not use multiple roots: " + this.root.getName() + ", " + (String)parts[0]);
            }
            Subsystem subsystem = this.root;
            for (int i = 1; i < parts.length; ++i) {
                Subsystem subsystem2 = this.getOrCreateChild((Subsystem)var7_8, (String)parts[i]);
            }
            for (String requirement : entry.getValue()) {
                var7_8.require(requirement);
            }
        }
        if (this.root == null) {
            return;
        }
        this.root.build(allFeatures);
        BundleRevision sysBundleRev = null;
        boolean hasEeCap = false;
        for (Map.Entry entry : system.entrySet()) {
            Subsystem ss = null;
            String[] parts = ((String)entry.getKey()).split("/");
            String path = parts[0];
            if (path.equals(this.root.getName())) {
                ss = this.root;
            }
            for (int i = 1; ss != null && i < parts.length; ss = ss.getChild(path), ++i) {
                path = path + "/" + parts[i];
            }
            if (ss == null) continue;
            ResourceImpl dummy = new ResourceImpl("dummy", "dummy", Version.emptyVersion);
            for (BundleRevision res : (Set)entry.getValue()) {
                DictionaryAsMap<String, String> headers = new DictionaryAsMap<String, String>(res.getBundle().getHeaders());
                ResourceImpl tmp = ResourceBuilder.build(res.getBundle().getLocation(), headers);
                for (Capability cap : tmp.getCapabilities("osgi.service")) {
                    dummy.addCapability(new CapabilityImpl(dummy, cap.getNamespace(), cap.getDirectives(), cap.getAttributes()));
                }
                ss.addSystemResource((Resource)res);
                for (Capability cap : res.getCapabilities(null)) {
                    hasEeCap |= cap.getNamespace().equals("osgi.ee");
                }
                if (res.getBundle().getBundleId() != 0L) continue;
                sysBundleRev = res;
            }
            ss.addSystemResource(dummy);
        }
        if (!hasEeCap && sysBundleRev != null) {
            String provideCaps = (String)sysBundleRev.getBundle().getHeaders().get("Provide-Capability");
            this.environmentResource = new ResourceImpl("environment", "karaf.environment", Version.emptyVersion);
            this.environmentResource.addCapabilities(ResourceBuilder.parseCapability(this.environmentResource, provideCaps));
            this.root.addSystemResource(this.environmentResource);
        }
    }

    public Set<String> collectPrerequisites() throws Exception {
        if (this.root != null) {
            return this.root.collectPrerequisites();
        }
        return new HashSet<String>();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<Resource, List<Wire>> resolve(Set<String> overrides, String featureResolutionRange, String serviceRequirements, Repository globalRepository, String outputFile) throws Exception {
        if (this.root == null) {
            return Collections.emptyMap();
        }
        RepositoryManager repos = new RepositoryManager();
        this.root.downloadBundles(this.manager, overrides, featureResolutionRange, serviceRequirements, repos);
        this.digraph = new StandardRegionDigraph(null, null);
        this.populateDigraph(this.digraph, this.root);
        Downloader downloader = this.manager.createDownloader();
        SubsystemResolveContext context = new SubsystemResolveContext(this.root, this.digraph, globalRepository, downloader, serviceRequirements);
        if (outputFile != null) {
            HashMap<String, Object> json = new HashMap<String, Object>();
            if (globalRepository != null) {
                json.put("globalRepository", this.toJson(globalRepository));
            }
            json.put("repository", this.toJson(context.getRepository()));
            try {
                this.wiring = this.resolver.resolve((ResolveContext)context);
                json.put("success", "true");
                json.put("wiring", this.toJson(this.wiring));
            }
            catch (Exception e) {
                try {
                    json.put("success", "false");
                    json.put("exception", e.toString());
                    throw e;
                }
                catch (Throwable throwable) {
                    try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(outputFile, new String[0]), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                        JsonWriter.write((Writer)writer, json, true);
                        throw throwable;
                    }
                }
            }
            try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(outputFile, new String[0]), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                JsonWriter.write((Writer)writer, json, true);
            }
        }
        this.wiring = this.resolver.resolve((ResolveContext)context);
        downloader.await();
        if (this.environmentResource != null) {
            for (List<Wire> wires : this.wiring.values()) {
                Iterator<Wire> iterator = wires.iterator();
                while (iterator.hasNext()) {
                    Wire wire = iterator.next();
                    if (wire.getProvider() != this.environmentResource) continue;
                    iterator.remove();
                }
            }
        }
        this.associateFragments();
        return this.wiring;
    }

    private Object toJson(Map<Resource, List<Wire>> wiring) {
        HashMap wires = new HashMap();
        for (Map.Entry<Resource, List<Wire>> reswiring : wiring.entrySet()) {
            Resource resource = reswiring.getKey();
            String id = this.toString(resource);
            ArrayList reswires = new ArrayList();
            for (Wire w : reswiring.getValue()) {
                LinkedHashMap<String, String> rw = new LinkedHashMap<String, String>();
                rw.put("requirement", this.toString(w.getRequirement()));
                rw.put("capability", this.toString(w.getCapability()));
                rw.put("requirer", this.toString(w.getRequirer()));
                rw.put("provider", this.toString(w.getProvider()));
                reswires.add(rw);
            }
            wires.put(id, reswires);
        }
        return wires;
    }

    private String toString(Resource r) {
        return this.toString((Capability)r.getCapabilities("osgi.identity").get(0));
    }

    private String toString(Requirement r) {
        return BaseClause.toString(null, r.getNamespace(), r.getAttributes(), r.getDirectives());
    }

    private String toString(Capability c) {
        return BaseClause.toString(null, c.getNamespace(), c.getAttributes(), c.getDirectives());
    }

    private Object toJson(Repository repository) {
        RequirementImpl req = new RequirementImpl(null, "osgi.identity", Collections.emptyMap(), Collections.emptyMap(), new SimpleFilter(null, null, 0));
        Collection<Capability> identities = repository.findProviders(Collections.singleton(req)).get(req);
        ArrayList<Object> resources = new ArrayList<Object>();
        for (Capability identity : identities) {
            String id = BaseClause.toString(null, identity.getNamespace(), identity.getAttributes(), identity.getDirectives());
            resources.add(this.toJson(identity.getResource()));
        }
        return resources;
    }

    private Object toJson(Resource resource) {
        HashMap obj = new HashMap();
        ArrayList<String> caps = new ArrayList<String>();
        ArrayList<String> reqs = new ArrayList<String>();
        for (Capability cap : resource.getCapabilities(null)) {
            caps.add(BaseClause.toString(null, cap.getNamespace(), cap.getAttributes(), cap.getDirectives()));
        }
        for (Requirement req : resource.getRequirements(null)) {
            reqs.add(BaseClause.toString(null, req.getNamespace(), req.getAttributes(), req.getDirectives()));
        }
        obj.put("capabilities", caps);
        obj.put("requirements", reqs);
        return obj;
    }

    public Map<String, Map<String, BundleInfo>> getBundleInfos() {
        if (this.bundleInfos == null) {
            this.bundleInfos = new HashMap<String, Map<String, BundleInfo>>();
            this.addBundleInfos(this.root);
        }
        return this.bundleInfos;
    }

    private void addBundleInfos(Subsystem subsystem) {
        if (subsystem != null) {
            String region = this.getFlatSubsystemsMap().get(subsystem.getName());
            Map<String, BundleInfo> bis = this.bundleInfos.get(region);
            if (bis == null) {
                bis = new HashMap<String, BundleInfo>();
                this.bundleInfos.put(region, bis);
            }
            bis.putAll(subsystem.getBundleInfos());
            for (Subsystem child : subsystem.getChildren()) {
                this.addBundleInfos(child);
            }
        }
    }

    public Map<String, StreamProvider> getProviders() {
        return this.manager.getProviders();
    }

    public Map<Resource, List<Wire>> getWiring() {
        return this.wiring;
    }

    public RegionDigraph getFlatDigraph() throws BundleException, InvalidSyntaxException {
        if (this.flatDigraph == null) {
            this.flatDigraph = new StandardRegionDigraph(null, null);
            Map<String, String> flats = this.getFlatSubsystemsMap();
            if (this.digraph != null) {
                for (Region r : this.digraph.getRegions()) {
                    if (!r.getName().equals(flats.get(r.getName()))) continue;
                    this.flatDigraph.createRegion(r.getName());
                }
                for (Region r : this.digraph.getRegions()) {
                    for (RegionDigraph.FilteredRegion fr : this.digraph.getEdges(r)) {
                        String rt = flats.get(r.getName());
                        String rh = flats.get(fr.getRegion().getName());
                        if (rh.equals(rt)) continue;
                        Region tail = this.flatDigraph.getRegion(rt);
                        Region head = this.flatDigraph.getRegion(rh);
                        RegionFilterBuilder rfb = this.flatDigraph.createRegionFilterBuilder();
                        for (Map.Entry<String, Collection<String>> entry : fr.getFilter().getSharingPolicy().entrySet()) {
                            if ("osgi.identity".equals(entry.getKey())) continue;
                            for (String f : entry.getValue()) {
                                rfb.allow(entry.getKey(), f);
                            }
                        }
                        this.flatDigraph.connect(tail, rfb.build(), head);
                    }
                }
            }
        }
        return this.flatDigraph;
    }

    public Map<String, String> getFlatSubsystemsMap() {
        if (this.flatSubsystemsMap == null) {
            this.flatSubsystemsMap = new HashMap<String, String>();
            this.findSubsystemsToFlatten(this.root, this.flatSubsystemsMap);
        }
        return this.flatSubsystemsMap;
    }

    public Map<String, Set<Resource>> getBundlesPerRegions() {
        if (this.bundlesPerRegions == null) {
            this.bundlesPerRegions = MapUtils.invert(this.getBundles());
        }
        return this.bundlesPerRegions;
    }

    public Map<Resource, String> getBundles() {
        if (this.bundles == null) {
            String filter = String.format("(&(%s=*)(|(%s=%s)(%s=%s)))", "osgi.identity", "type", "osgi.bundle", "type", "osgi.fragment");
            SimpleFilter sf = SimpleFilter.parse(filter);
            this.bundles = this.getResourceMapping(sf);
        }
        return this.bundles;
    }

    public Map<String, Set<Resource>> getFeaturesPerRegions() {
        if (this.featuresPerRegions == null) {
            this.featuresPerRegions = MapUtils.invert(this.getFeatures());
        }
        return this.featuresPerRegions;
    }

    public Map<Resource, String> getFeatures() {
        if (this.features == null) {
            SimpleFilter sf = this.createFilter("osgi.identity", "*", "type", "karaf.feature");
            this.features = this.getResourceMapping(sf);
        }
        return this.features;
    }

    private Map<Resource, String> getResourceMapping(SimpleFilter resourceFilter) {
        Map<String, String> flats = this.getFlatSubsystemsMap();
        Map<Resource, List<Wire>> wiring = this.getWiring();
        HashMap<Resource, String> resources = new HashMap<Resource, String>();
        SimpleFilter sf = this.createFilter("osgi.identity", "*", "type", "karaf.subsystem");
        if (wiring != null) {
            for (Resource resource : wiring.keySet()) {
                Wire wire;
                if (this.findMatchingCapability(resourceFilter, resource.getCapabilities(null)) == null || (wire = this.findMatchingWire(sf, (Collection<Wire>)wiring.get(resource))) == null) continue;
                String region = (String)wire.getCapability().getAttributes().get("osgi.identity");
                region = flats.get(region);
                resources.put(resource, region);
            }
        }
        return resources;
    }

    private void associateFragments() {
        SimpleFilter sf = this.createFilter("osgi.identity", "*", "type", "karaf.subsystem");
        for (Map.Entry<Resource, List<Wire>> entry : this.wiring.entrySet()) {
            List<Wire> wires;
            Resource host;
            Wire wire;
            final Resource resource = entry.getKey();
            final Requirement requirement = this.getSubsystemRequirement(resource);
            if (!ResolverUtil.isFragment(resource) || requirement == null || (wire = this.findMatchingWire(sf, (Collection<Wire>)this.wiring.get(host = (wires = entry.getValue()).get(0).getProvider()))) == null) continue;
            wires.add(new Wire(){

                public Capability getCapability() {
                    return wire.getCapability();
                }

                public Requirement getRequirement() {
                    return requirement;
                }

                public Resource getProvider() {
                    return wire.getProvider();
                }

                public Resource getRequirer() {
                    return resource;
                }
            });
        }
    }

    private Requirement getSubsystemRequirement(Resource resource) {
        for (Requirement requirement : resource.getRequirements(null)) {
            if (!"osgi.identity".equals(requirement.getNamespace()) || !"karaf.subsystem".equals(requirement.getAttributes().get("type"))) continue;
            return requirement;
        }
        return null;
    }

    private Capability findMatchingCapability(SimpleFilter filter, Collection<Capability> caps) {
        for (Capability cap : caps) {
            if (!CapabilitySet.matches(cap, filter)) continue;
            return cap;
        }
        return null;
    }

    private Wire findMatchingWire(SimpleFilter filter, Collection<Wire> wires) {
        for (Wire wire : wires) {
            Capability cap = wire.getCapability();
            if (!CapabilitySet.matches(cap, filter)) continue;
            return wire;
        }
        return null;
    }

    private SimpleFilter createFilter(String ... s) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (int i = 0; i < s.length - 1; i += 2) {
            attrs.put(s[i], s[i + 1]);
        }
        return SimpleFilter.convert(attrs);
    }

    private void findSubsystemsToFlatten(Subsystem subsystem, Map<String, String> toFlatten) {
        Subsystem nonFlat = subsystem;
        while (this.isFlat(nonFlat)) {
            nonFlat = nonFlat.getParent();
        }
        if (subsystem != null) {
            toFlatten.put(subsystem.getName(), nonFlat.getName());
            for (Subsystem child : subsystem.getChildren()) {
                this.findSubsystemsToFlatten(child, toFlatten);
            }
        }
    }

    private boolean isFlat(Subsystem subsystem) {
        if (subsystem == null || subsystem.getFeature() == null) {
            return false;
        }
        return subsystem.getFeature() != null && subsystem.getFeature().getScoping() == null;
    }

    private Subsystem getOrCreateChild(Subsystem ss, String name) {
        Subsystem child = ss.getChild(name);
        return child != null ? child : ss.createSubsystem(name, true);
    }

    private void populateDigraph(RegionDigraph digraph, Subsystem subsystem) throws BundleException, InvalidSyntaxException {
        Region region = digraph.createRegion(subsystem.getName());
        if (subsystem.getParent() != null) {
            Region parent = digraph.getRegion(subsystem.getParent().getName());
            digraph.connect(region, this.createRegionFilterBuilder(digraph, subsystem.getImportPolicy()).build(), parent);
            digraph.connect(parent, this.createRegionFilterBuilder(digraph, subsystem.getExportPolicy()).build(), region);
        }
        for (Subsystem child : subsystem.getChildren()) {
            this.populateDigraph(digraph, child);
        }
    }

    private RegionFilterBuilder createRegionFilterBuilder(RegionDigraph digraph, Map<String, Set<String>> sharingPolicy) throws InvalidSyntaxException {
        RegionFilterBuilder result = digraph.createRegionFilterBuilder();
        for (Map.Entry<String, Set<String>> entry : sharingPolicy.entrySet()) {
            for (String filter : entry.getValue()) {
                result.allow(entry.getKey(), filter);
            }
        }
        return result;
    }
}

