/*
 * Decompiled with CFR 0.152.
 */
package cisco.infra.dft.maven.dma.repo.mojos;

import cisco.infra.dft.maven.dma.svnkit.SVNDebugLogAdaptor;
import cisco.infra.dma.repo.BadDmaName;
import cisco.infra.dma.repo.Namespaces;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;

public class CreateSpaceFromPomMojo
extends AbstractMojo {
    protected boolean underTest = false;
    public MavenProject project;
    protected boolean debug = false;
    private static final String DMA_COMMIT_NOTIFICATIONS = "dma:commit-notifications";
    private static String REPO = "http://dft-releng-02.cisco.com/svn/repo/";
    static final String DEV_REPO = "http://dft-releng-02.cisco.com/svn/repo/";

    public void execute() throws MojoExecutionException {
        this.turnOffProxyHosts();
        if (this.project == null) {
            this.getLog().error((CharSequence)"Could not read POM");
            return;
        }
        if (this.debug) {
            SVNDebugLog.setDefaultLog((ISVNDebugLog)new SVNDebugLogAdaptor());
        }
        this.displayNamingInformation();
        this.validatePom();
        try {
            this.createProject();
        }
        catch (SVNAuthenticationException authe) {
            throw new MojoExecutionException("SVN Authentication Failed");
        }
        catch (SVNException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("SVN Call Failed");
        }
    }

    protected void turnOffProxyHosts() {
        System.setProperty("socksProxyHost", "");
        System.setProperty("socksProxyPort", "");
    }

    private void validatePom() throws BadDmaName {
        if (!Namespaces.isFixedCategoryValid((String)Namespaces.getFixedCategory((String)this.project.getGroupId()))) {
            throw new BadDmaName(Namespaces.getFixedCategory((String)(this.project.getGroupId() + "Not valid?")));
        }
        if (!Namespaces.isProjectSpaceValid((String)this.project.getArtifactId())) {
            this.getLog().info((CharSequence)("Space Name : " + this.project.getArtifactId() + " is not valid. "));
            throw new BadDmaName();
        }
    }

    private void displayNamingInformation() throws MojoExecutionException {
        if (this.project == null) {
            return;
        }
        this.getLog().info((CharSequence)"Going to create project space in the repo using your maven POM for configuration");
        this.getLog().info((CharSequence)("Group Name = [" + this.project.getGroupId() + "]"));
        this.getLog().info((CharSequence)("Project Name = [" + this.project.getArtifactId() + "]"));
        this.getLog().info((CharSequence)"======= DMA SVN Naming Conventions ==========");
        this.getLog().info((CharSequence)("Fixd Category = [" + Namespaces.getFixedCategory((String)this.project.getGroupId()) + "]"));
        this.getLog().info((CharSequence)("Subject Area = [" + Namespaces.getSubjectArea((String)this.project.getGroupId()) + "]"));
        this.getLog().info((CharSequence)("Project Space = [" + Namespaces.getProjectSpace((String)this.project.getGroupId()) + "]"));
    }

    public void createProject() throws SVNException, BadDmaName {
        DAVRepositoryFactory.setup();
        SVNURL url = SVNURL.parseURIEncoded((String)(this.repoUrl() + "/" + Namespaces.getFixedCategory((String)this.project.getGroupId()) + "/" + Namespaces.getSubjectArea((String)this.project.getGroupId())));
        SVNRepository repo = SVNRepositoryFactory.create((SVNURL)url);
        this.getLog().info((CharSequence)("Using URL " + url.toDecodedString()));
        String userName = "robevans";
        String userPassword = "robevans";
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)userName, (String)userPassword);
        repo.setAuthenticationManager(authManager);
        CreateSpaceFromPomMojo.addProject(repo, this.project.getArtifactId());
        this.checkout();
    }

    protected String repoUrl() throws SVNException {
        if (this.underTest) {
            return DEV_REPO;
        }
        return REPO;
    }

    private void checkout() throws SVNException, BadDmaName {
        SVNURL url = SVNURL.parseURIEncoded((String)(this.repoUrl() + "/" + Namespaces.getFixedCategory((String)this.project.getGroupId()) + "/" + "/" + Namespaces.getSubjectArea((String)this.project.getGroupId()) + "/" + this.project.getArtifactId() + "/trunk"));
        this.getLog().info((CharSequence)("Checking out a working copy of the trunk from " + url.toDecodedString()));
        ISVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        SVNClientManager ourClientManager = SVNClientManager.newInstance((ISVNOptions)options, (String)"robevans", (String)"robevans");
        SVNUpdateClient updateClient = ourClientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        String curDir = System.getProperty("user.dir");
        File name = new File(curDir);
        updateClient.doCheckout(url, name, SVNRevision.HEAD, SVNRevision.HEAD, true);
    }

    private static SVNCommitInfo addProject(SVNRepository repos, String dirPath) throws SVNException {
        ISVNEditor editor = repos.getCommitEditor("DMA Automation - Repo Mojo", null);
        editor.openRoot(-1L);
        editor.addDir(dirPath, null, -1L);
        editor.changeDirProperty(DMA_COMMIT_NOTIFICATIONS, "robevans@cisco.com,dft-dma@cisco.com");
        editor.addDir("trunk", null, -1L);
        editor.closeDir();
        editor.addDir("tags", null, -1L);
        editor.closeDir();
        editor.addDir("branches", null, -1L);
        editor.closeDir();
        editor.closeDir();
        return editor.closeEdit();
    }
}

