/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0077_inbandreg;

import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLSemanticError;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.authorization.AccountCreationException;
import org.apache.vysper.xmpp.authorization.AccountManagement;
import org.apache.vysper.xmpp.modules.core.base.handler.DefaultIQHandler;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;

public class InBandRegistrationHandler
extends DefaultIQHandler {
    protected boolean verifyNamespace(Stanza stanza) {
        return this.verifyInnerNamespace(stanza, "jabber:iq:register");
    }

    public boolean isSessionRequired() {
        return false;
    }

    protected Stanza handleGet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        if (sessionContext.getState().equals((Object)SessionState.STARTED) || sessionContext.getState().equals((Object)SessionState.ENCRYPTED) || sessionContext.getState().equals((Object)SessionState.AUTHENTICATED)) {
            StanzaBuilder stanzaBuilder = StanzaBuilder.createIQStanza(stanza.getTo(), stanza.getFrom(), IQStanzaType.RESULT, stanza.getID());
            ((StanzaBuilder)((StanzaBuilder)((StanzaBuilder)stanzaBuilder.startInnerElement("query", "jabber:iq:register")).startInnerElement("instructions", "jabber:iq:register")).addText("Choose a username and password for use with this service.")).endInnerElement();
            if (sessionContext.getState().equals((Object)SessionState.AUTHENTICATED)) {
                ((StanzaBuilder)((StanzaBuilder)((StanzaBuilder)((StanzaBuilder)stanzaBuilder.startInnerElement("registered", "jabber:iq:register")).endInnerElement()).startInnerElement("username", "jabber:iq:register")).addText(sessionContext.getInitiatingEntity().getNode())).endInnerElement();
            } else {
                ((StanzaBuilder)((StanzaBuilder)((StanzaBuilder)stanzaBuilder.startInnerElement("username", "jabber:iq:register")).endInnerElement()).startInnerElement("password", "jabber:iq:register")).endInnerElement();
            }
            return (Stanza)stanzaBuilder.build();
        }
        return ServerErrorResponses.getStanzaError(StanzaErrorCondition.SERVICE_UNAVAILABLE, stanza, StanzaErrorType.CANCEL, null, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Stanza handleSet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        if (!sessionContext.getState().equals((Object)SessionState.STARTED) && !sessionContext.getState().equals((Object)SessionState.ENCRYPTED) && !sessionContext.getState().equals((Object)SessionState.AUTHENTICATED)) return ServerErrorResponses.getStanzaError(StanzaErrorCondition.SERVICE_UNAVAILABLE, stanza, StanzaErrorType.CANCEL, null, null, null);
        try {
            EntityImpl user;
            XMLElement query = stanza.getSingleInnerElementsNamed("query", "jabber:iq:register");
            XMLElement usernameElm = query.getSingleInnerElementsNamed("username", "jabber:iq:register");
            if (usernameElm == null || usernameElm.getInnerText() == null) {
                throw new XMLSemanticError("Invalid or missing username");
            }
            String username = usernameElm.getInnerText().getText();
            XMLElement passwordElm = query.getSingleInnerElementsNamed("password", "jabber:iq:register");
            if (passwordElm == null || passwordElm.getInnerText() == null) {
                throw new XMLSemanticError("Invalid or missing password");
            }
            String password = passwordElm.getInnerText().getText();
            if (password.trim().length() == 0) {
                throw new XMLSemanticError("Invalid password");
            }
            AccountManagement accountManagement = (AccountManagement)serverRuntimeContext.getStorageProvider(AccountManagement.class);
            if (username.contains("@")) {
                user = EntityImpl.parse(username);
                if (!serverRuntimeContext.getServerEnitity().getDomain().equals(user.getDomain())) {
                    throw new XMLSemanticError("Username must be in the same domain as the server");
                }
            } else {
                user = EntityImpl.parse(username + "@" + serverRuntimeContext.getServerEnitity());
            }
            if (sessionContext.getState().equals((Object)SessionState.AUTHENTICATED)) {
                if (!accountManagement.verifyAccountExists(user)) throw new AccountCreationException("Account does not exist");
                accountManagement.changePassword(user, password);
                return (Stanza)StanzaBuilder.createDirectReply((XMPPCoreStanza)stanza, true, IQStanzaType.RESULT).build();
            } else {
                if (accountManagement.verifyAccountExists(user)) {
                    throw new AccountCreationException("Account already exists");
                }
                accountManagement.addUser(user, password);
            }
            return (Stanza)StanzaBuilder.createDirectReply((XMPPCoreStanza)stanza, true, IQStanzaType.RESULT).build();
        }
        catch (XMLSemanticError e) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.NOT_ACCEPTABLE, stanza, StanzaErrorType.MODIFY, 406, null, null, null);
        }
        catch (EntityFormatException e) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.NOT_ACCEPTABLE, stanza, StanzaErrorType.MODIFY, 406, null, null, null);
        }
        catch (AccountCreationException e) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.CONFLICT, stanza, StanzaErrorType.CANCEL, 409, e.getMessage(), null, null);
        }
    }
}

