/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.server.response;

import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.modules.core.sasl.SASLFailureType;
import org.apache.vysper.xmpp.protocol.StreamErrorCondition;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;

public class ServerErrorResponses {
    private ServerErrorResponses() {
    }

    public static Stanza getStreamError(StreamErrorCondition definedErrorCondition, String languageCode, String descriptiveText, XMLElement applicationSpecificError) {
        if (languageCode == null) {
            languageCode = "en_US";
        }
        StanzaBuilder stanzaBuilder = new StanzaBuilder("error", "urn:ietf:params:xml:ns:xmpp-streams");
        ((StanzaBuilder)stanzaBuilder.startInnerElement(definedErrorCondition.value(), "urn:ietf:params:xml:ns:xmpp-streams")).endInnerElement();
        if (descriptiveText != null) {
            ((StanzaBuilder)((StanzaBuilder)((StanzaBuilder)stanzaBuilder.startInnerElement("text", "urn:ietf:params:xml:ns:xmpp-streams")).addAttribute("http://www.w3.org/XML/1998/namespace", "lang", languageCode)).addText(descriptiveText)).endInnerElement();
        }
        if (applicationSpecificError != null) {
            stanzaBuilder.addPreparedElement(applicationSpecificError);
        }
        return (Stanza)stanzaBuilder.build();
    }

    public static Stanza getStanzaError(StanzaErrorCondition errorCondition, XMPPCoreStanza stanza, StanzaErrorType type, String errorText, String errorLang, XMLElement errorConditionElement) {
        if (stanza != null && "error".equals(stanza.getType())) {
            return ServerErrorResponses.getStreamError(StreamErrorCondition.UNSUPPORTED_STANZA_TYPE, errorLang, "cannot respond to IQ stanza of type error with the same", null);
        }
        StanzaBuilder responseBuilder = StanzaBuilder.createDirectReply(stanza, true, "error");
        ServerErrorResponses.fillErrorStanza(stanza, type, errorCondition, -1, errorText, errorLang, errorConditionElement, responseBuilder);
        return (Stanza)responseBuilder.build();
    }

    public static Stanza getStanzaError(StanzaErrorCondition errorCondition, XMPPCoreStanza stanza, StanzaErrorType type, int code, String errorText, String errorLang, XMLElement errorConditionElement) {
        if (stanza != null && "error".equals(stanza.getType())) {
            return ServerErrorResponses.getStreamError(StreamErrorCondition.UNSUPPORTED_STANZA_TYPE, errorLang, "cannot respond to IQ stanza of type error with the same", null);
        }
        StanzaBuilder responseBuilder = StanzaBuilder.createDirectReply(stanza, true, "error");
        ServerErrorResponses.fillErrorStanza(stanza, type, errorCondition, code, errorText, errorLang, errorConditionElement, responseBuilder);
        return (Stanza)responseBuilder.build();
    }

    private static void fillErrorStanza(XMPPCoreStanza stanza, StanzaErrorType type, StanzaErrorCondition errorCondition, int code, String errorText, String errorLang, XMLElement errorConditionElement, StanzaBuilder responseBuilder) {
        for (XMLElement innerElement : stanza.getInnerElements()) {
            responseBuilder.addPreparedElement(innerElement);
        }
        ((StanzaBuilder)responseBuilder.startInnerElement("error", "jabber:client")).addAttribute("type", type.value());
        if (code != -1) {
            responseBuilder.addAttribute("code", Integer.toString(code));
        }
        responseBuilder.startInnerElement(errorCondition.value(), "urn:ietf:params:xml:ns:xmpp-stanzas");
        responseBuilder.endInnerElement();
        if (errorText != null && errorLang != null) {
            ((StanzaBuilder)((StanzaBuilder)responseBuilder.startInnerElement("text", "urn:ietf:params:xml:ns:xmpp-stanzas")).addAttribute("http://www.w3.org/XML/1998/namespace", "lang", errorLang)).addText(errorText);
        }
        if (errorConditionElement != null) {
            responseBuilder.addPreparedElement(errorConditionElement);
        }
        responseBuilder.endInnerElement();
    }

    public static Stanza getTLSFailure() {
        StanzaBuilder stanzaBuilder = new StanzaBuilder("failure", "urn:ietf:params:xml:ns:xmpp-tls");
        return (Stanza)stanzaBuilder.build();
    }

    public static Stanza getSASLFailure(SASLFailureType failureType) {
        StanzaBuilder stanzaBuilder = new StanzaBuilder("failure", "urn:ietf:params:xml:ns:xmpp-sasl");
        if (failureType != null) {
            ((StanzaBuilder)stanzaBuilder.startInnerElement(failureType.toString(), "urn:ietf:params:xml:ns:xmpp-sasl")).endInnerElement();
        }
        return (Stanza)stanzaBuilder.build();
    }
}

