/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.el.ValueExpression;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.commons.util.ParametrizableFacesMessage;

public final class MessageUtils {
    private static final String DEFAULT_BUNDLE = "org.apache.myfaces.commons.Messages";
    private static final String DETAIL_SUFFIX = "_detail";
    private static Log log = LogFactory.getLog(MessageUtils.class);

    private MessageUtils() {
    }

    public static FacesMessage getMessage(FacesMessage.Severity severity, String messageId, Object arg) {
        return MessageUtils.getMessage(severity, messageId, new Object[]{arg}, FacesContext.getCurrentInstance());
    }

    public static FacesMessage getMessage(String bundleBaseName, FacesMessage.Severity severity, String messageId, Object arg) {
        return MessageUtils.getMessage(bundleBaseName, severity, messageId, new Object[]{arg}, FacesContext.getCurrentInstance());
    }

    public static FacesMessage getMessage(FacesMessage.Severity severity, String messageId, Object[] args) {
        return MessageUtils.getMessage(severity, messageId, args, FacesContext.getCurrentInstance());
    }

    public static FacesMessage getMessage(String bundleBaseName, FacesMessage.Severity severity, String messageId, Object[] args) {
        return MessageUtils.getMessage(bundleBaseName, severity, messageId, args, FacesContext.getCurrentInstance());
    }

    public static FacesMessage getMessage(FacesMessage.Severity severity, String messageId, Object[] args, FacesContext facesContext) {
        FacesMessage message = MessageUtils.getMessage(facesContext, messageId, args);
        message.setSeverity(severity);
        return message;
    }

    public static FacesMessage getMessage(String bundleBaseName, FacesMessage.Severity severity, String messageId, Object[] args, FacesContext facesContext) {
        FacesMessage message = MessageUtils.getMessage(bundleBaseName, facesContext, messageId, args);
        message.setSeverity(severity);
        return message;
    }

    public static void addMessage(FacesMessage.Severity severity, String messageId, Object[] args) {
        MessageUtils.addMessage(severity, messageId, args, null, FacesContext.getCurrentInstance());
    }

    public static void addMessage(String bundleBaseName, FacesMessage.Severity severity, String messageId, Object[] args) {
        MessageUtils.addMessage(bundleBaseName, severity, messageId, args, null, FacesContext.getCurrentInstance());
    }

    public static void addMessage(FacesMessage.Severity severity, String messageId, Object[] args, FacesContext facesContext) {
        MessageUtils.addMessage(severity, messageId, args, null, facesContext);
    }

    public static void addMessage(String bundleBaseName, FacesMessage.Severity severity, String messageId, Object[] args, FacesContext facesContext) {
        MessageUtils.addMessage(bundleBaseName, severity, messageId, args, null, facesContext);
    }

    public static void addMessage(FacesMessage.Severity severity, String messageId, Object[] args, String forClientId) {
        MessageUtils.addMessage(severity, messageId, args, forClientId, FacesContext.getCurrentInstance());
    }

    public static void addMessage(String bundleBaseName, FacesMessage.Severity severity, String messageId, Object[] args, String forClientId) {
        MessageUtils.addMessage(bundleBaseName, severity, messageId, args, forClientId, FacesContext.getCurrentInstance());
    }

    public static void addMessage(FacesMessage.Severity severity, String messageId, Object[] args, String forClientId, FacesContext facesContext) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("adding message " + messageId + " for clientId " + forClientId));
        }
        facesContext.addMessage(forClientId, MessageUtils.getMessage(severity, messageId, args, facesContext));
    }

    public static void addMessage(String bundleBaseName, FacesMessage.Severity severity, String messageId, Object[] args, String forClientId, FacesContext facesContext) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("adding message " + messageId + " for clientId " + forClientId));
        }
        facesContext.addMessage(forClientId, MessageUtils.getMessage(bundleBaseName, severity, messageId, args, facesContext));
    }

    public static String substituteParams(Locale locale, String msgtext, Object[] params) {
        String localizedStr = null;
        if (params == null || msgtext == null) {
            return msgtext;
        }
        StringBuffer b = new StringBuffer(100);
        MessageFormat mf = new MessageFormat(msgtext);
        if (locale != null) {
            mf.setLocale(locale);
            b.append(mf.format(params));
            localizedStr = b.toString();
        }
        return localizedStr;
    }

    public static FacesMessage getMessage(String messageId, Object[] params) {
        Locale locale = MessageUtils.getCurrentLocale();
        return MessageUtils.getMessage(locale, messageId, params);
    }

    public static FacesMessage getMessageFromBundle(String bundleBaseName, String messageId, Object[] params) {
        Locale locale = null;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null && context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        return MessageUtils.getMessageFromBundle(bundleBaseName, context, locale, messageId, params);
    }

    public static FacesMessage getMessage(Locale locale, String messageId, Object[] params) {
        String summary = null;
        String detail = null;
        String bundleName = MessageUtils.getApplication().getMessageBundle();
        ResourceBundle bundle = null;
        if (bundleName != null) {
            try {
                bundle = ResourceBundle.getBundle(bundleName, locale, MessageUtils.getCurrentLoader(bundleName));
                summary = bundle.getString(messageId);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = ResourceBundle.getBundle(DEFAULT_BUNDLE, locale, MessageUtils.getCurrentLoader(DEFAULT_BUNDLE));
                if (bundle == null) {
                    throw new NullPointerException();
                }
                summary = bundle.getString(messageId);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (summary == null) {
            summary = messageId;
        }
        if (bundle == null) {
            throw new NullPointerException("Unable to locate ResourceBundle: bundle is null");
        }
        if (params != null && locale != null) {
            try {
                detail = bundle.getString(messageId + DETAIL_SUFFIX);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            return new ParametrizableFacesMessage(summary, detail, params, locale);
        }
        summary = MessageUtils.substituteParams(locale, summary, params);
        try {
            detail = MessageUtils.substituteParams(locale, bundle.getString(messageId + DETAIL_SUFFIX), params);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return new FacesMessage(summary, detail);
    }

    public static FacesMessage getMessageFromBundle(String bundleBaseName, FacesContext context, Locale locale, String messageId, Object[] params) {
        String summary = null;
        String detail = null;
        String bundleName = context.getApplication().getMessageBundle();
        ResourceBundle bundle = null;
        if (bundleName != null) {
            try {
                bundle = ResourceBundle.getBundle(bundleName, locale, MessageUtils.getCurrentLoader(bundleName));
                summary = bundle.getString(messageId);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = ResourceBundle.getBundle(bundleBaseName, locale, MessageUtils.getCurrentLoader(bundleBaseName));
                if (bundle == null) {
                    throw new NullPointerException();
                }
                summary = bundle.getString(messageId);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = ResourceBundle.getBundle(DEFAULT_BUNDLE, locale, MessageUtils.getCurrentLoader(DEFAULT_BUNDLE));
                if (bundle == null) {
                    throw new NullPointerException();
                }
                summary = bundle.getString(messageId);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (summary == null) {
            summary = messageId;
        }
        if (bundle == null) {
            throw new NullPointerException("Unable to locate ResourceBundle: bundle is null");
        }
        if (params != null && locale != null) {
            try {
                detail = bundle.getString(messageId + DETAIL_SUFFIX);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            return new ParametrizableFacesMessage(summary, detail, params, locale);
        }
        summary = MessageUtils.substituteParams(locale, summary, params);
        try {
            detail = MessageUtils.substituteParams(locale, bundle.getString(messageId + DETAIL_SUFFIX), params);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return new FacesMessage(summary, detail);
    }

    public static FacesMessage getMessage(String bundleBaseName, String messageId, Object[] params) {
        return MessageUtils.getMessage(bundleBaseName, MessageUtils.getCurrentLocale(), messageId, params);
    }

    public static Locale getCurrentLocale() {
        return MessageUtils.getCurrentLocale(FacesContext.getCurrentInstance());
    }

    public static Locale getCurrentLocale(FacesContext context) {
        Locale locale;
        if (context != null && context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static FacesMessage getMessage(FacesMessage.Severity severity, String bundleBaseName, String messageId, Object[] params) {
        FacesMessage msg = MessageUtils.getMessage(bundleBaseName, messageId, params);
        msg.setSeverity(severity);
        return msg;
    }

    public static FacesMessage getMessage(String bundleBaseName, Locale locale, String messageId, Object[] params) {
        if (bundleBaseName == null) {
            throw new NullPointerException("Unable to locate ResourceBundle: bundle is null");
        }
        ResourceBundle bundle = ResourceBundle.getBundle(bundleBaseName, locale);
        return MessageUtils.getMessage(bundle, messageId, params);
    }

    public static FacesMessage getMessage(ResourceBundle bundle, String messageId, Object[] params) {
        String summary = null;
        String detail = null;
        try {
            summary = bundle.getString(messageId);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (summary == null) {
            summary = messageId;
        }
        summary = MessageUtils.substituteParams(bundle.getLocale(), summary, params);
        try {
            detail = MessageUtils.substituteParams(bundle.getLocale(), bundle.getString(messageId + DETAIL_SUFFIX), params);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return new FacesMessage(summary, detail);
    }

    public static FacesMessage getMessage(FacesContext context, String messageId) {
        return MessageUtils.getMessage(context, messageId, (Object[])null);
    }

    public static FacesMessage getMessage(String bundleBaseName, FacesContext context, String messageId) {
        return MessageUtils.getMessage(bundleBaseName, context, messageId, (Object[])null);
    }

    public static FacesMessage getMessage(FacesContext context, String messageId, Object[] params) {
        if (context == null || messageId == null) {
            throw new NullPointerException(" context " + context + " messageId " + messageId);
        }
        Locale locale = MessageUtils.getCurrentLocale(context);
        if (null == locale) {
            throw new NullPointerException(" locale " + locale);
        }
        FacesMessage message = MessageUtils.getMessage(locale, messageId, params);
        if (message != null) {
            return message;
        }
        locale = Locale.getDefault();
        return MessageUtils.getMessage(locale, messageId, params);
    }

    public static FacesMessage getMessage(String bundleBaseName, FacesContext context, String messageId, Object[] params) {
        if (context == null || messageId == null) {
            throw new NullPointerException(" context " + context + " messageId " + messageId);
        }
        Locale locale = MessageUtils.getCurrentLocale(context);
        if (null == locale) {
            throw new NullPointerException(" locale " + locale);
        }
        FacesMessage message = MessageUtils.getMessageFromBundle(bundleBaseName, context, locale, messageId, params);
        if (message != null) {
            return message;
        }
        locale = Locale.getDefault();
        return MessageUtils.getMessageFromBundle(bundleBaseName, context, locale, messageId, params);
    }

    public static Object getLabel(FacesContext facesContext, UIComponent component) {
        Object label = component.getAttributes().get("label");
        if (label != null) {
            return label;
        }
        ValueExpression expression = component.getValueExpression("label");
        if (expression != null) {
            return expression;
        }
        return component.getClientId(facesContext);
    }

    private static Application getApplication() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            return context.getApplication();
        }
        ApplicationFactory afactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        return afactory.getApplication();
    }

    private static ClassLoader getCurrentLoader(Object defaultObject) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = defaultObject.getClass().getClassLoader();
        }
        return loader;
    }
}

