/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import java.io.IOException;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.view.facelets.compiler.Instruction;
import org.apache.myfaces.view.facelets.el.ELText;

final class TextInstruction
implements Instruction {
    private final ELText txt;
    private final String alias;

    public TextInstruction(String alias, ELText txt) {
        this.alias = alias;
        this.txt = txt;
    }

    @Override
    public void write(FacesContext context) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        this.txt.writeText(out, context.getELContext());
    }

    @Override
    public Instruction apply(ExpressionFactory factory, ELContext ctx) {
        ELText nt = this.txt.apply(factory, ctx);
        if (nt == this.txt) {
            return this;
        }
        return new TextInstruction(this.alias, nt);
    }

    @Override
    public boolean isLiteral() {
        return this.txt.isLiteral();
    }
}

