/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.apache.myfaces.view.facelets.compiler.Instruction;

public class DoctypeInstruction
implements Instruction {
    private final String name;
    private final String publicId;
    private final String systemId;
    private final boolean html5Doctype;

    public DoctypeInstruction(String name, String publicId, String systemId, boolean html5Doctype) {
        this.name = name;
        this.publicId = publicId;
        this.systemId = systemId;
        this.html5Doctype = html5Doctype;
    }

    @Override
    public void write(FacesContext context) throws IOException {
        StringBuilder sb = new StringBuilder(64);
        if (this.html5Doctype) {
            sb.append("<!DOCTYPE html>\n");
        } else {
            sb.append("<!DOCTYPE ").append(this.name);
            if (this.publicId != null) {
                sb.append(" PUBLIC \"").append(this.publicId).append('\"');
                if (this.systemId != null) {
                    sb.append(" \"").append(this.systemId).append('\"');
                }
            } else if (this.systemId != null) {
                sb.append(" SYSTEM \"").append(this.systemId).append('\"');
            }
            sb.append(">\n");
        }
        context.getResponseWriter().writeDoctype(sb.toString());
    }

    @Override
    public Instruction apply(ExpressionFactory factory, ELContext ctx) {
        return this;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }
}

