/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.RecordComponent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;

public final class Json {
    private static final String ERROR_INVALID_BEAN = "Cannot introspect object of type '%s' as bean.";
    private static final String ERROR_INVALID_GETTER = "Cannot invoke getter of property '%s' of bean '%s'.";
    private static final Logger LOG = Logger.getLogger(Json.class.getName());
    private static final int UNICODE_3_BYTES = 4095;
    private static final int UNICODE_2_BYTES = 255;
    private static final int UNICODE_1_BYTE = 15;
    private static final int UNICODE_END_PRINTABLE_ASCII = 127;
    private static final int UNICODE_BEGIN_PRINTABLE_ASCII = 32;
    private static final String PATTERN_RFC1123_DATE = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final TimeZone TIMEZONE_GMT = TimeZone.getTimeZone("GMT");

    private Json() {
    }

    public static String encode(Object object) {
        StringBuilder builder = new StringBuilder();
        Json.encode(object, builder);
        return builder.toString();
    }

    private static void encode(Object object, StringBuilder builder) {
        if (object == null) {
            builder.append("null");
        } else if (object instanceof Boolean || object instanceof Number) {
            builder.append(object.toString());
        } else if (object instanceof CharSequence) {
            builder.append('\"').append(Json.escapeJS(object.toString(), false)).append('\"');
        } else if (object instanceof Date) {
            builder.append('\"').append(Json.formatRFC1123((Date)object)).append('\"');
        } else if (object instanceof Collection) {
            Json.encodeCollection((Collection)object, builder);
        } else if (object.getClass().isArray()) {
            Json.encodeArray(object, builder);
        } else if (object instanceof Map) {
            Json.encodeMap((Map)object, builder);
        } else if (object instanceof Class) {
            Json.encode(((Class)object).getName(), builder);
        } else if (object instanceof Record) {
            Json.encodeRecord(object, builder);
        } else {
            Json.encodeBean(object, builder);
        }
    }

    private static void encodeRecord(Object recordObject, StringBuilder builder) {
        builder.append('{');
        boolean fieldsFound = false;
        for (RecordComponent component : recordObject.getClass().getRecordComponents()) {
            fieldsFound = true;
            String name = component.getName();
            builder.append(name);
            builder.append(':');
            try {
                Json.encode(component.getAccessor().invoke(recordObject, new Object[0]), builder);
            }
            catch (Exception e) {
                LOG.warning("Failed to access RecordComponent for " + String.valueOf(recordObject) + " Message: " + e.getMessage());
            }
            builder.append(',');
        }
        if (fieldsFound) {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append('}');
    }

    private static void encodeCollection(Collection<?> collection, StringBuilder builder) {
        builder.append('[');
        int i = 0;
        for (Object element : collection) {
            if (i++ > 0) {
                builder.append(',');
            }
            Json.encode(element, builder);
        }
        builder.append(']');
    }

    private static void encodeArray(Object array, StringBuilder builder) {
        builder.append('[');
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            Json.encode(Array.get(array, i), builder);
        }
        builder.append(']');
    }

    private static void encodeMap(Map<?, ?> map, StringBuilder builder) {
        builder.append('{');
        int i = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (i++ > 0) {
                builder.append(',');
            }
            Json.encode(String.valueOf(entry.getKey()), builder);
            builder.append(':');
            Json.encode(entry.getValue(), builder);
        }
        builder.append('}');
    }

    private static void encodeBean(Object bean, StringBuilder builder) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_BEAN, bean.getClass()), e);
        }
        builder.append('{');
        int i = 0;
        for (PropertyDescriptor property : beanInfo.getPropertyDescriptors()) {
            Object value;
            if (property.getReadMethod() == null || "class".equals(property.getName())) continue;
            try {
                value = property.getReadMethod().invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format(ERROR_INVALID_GETTER, property.getName(), bean.getClass()), e);
            }
            if (value == null) continue;
            if (i++ > 0) {
                builder.append(',');
            }
            Json.encode(property.getName(), builder);
            builder.append(':');
            Json.encode(value, builder);
        }
        builder.append('}');
    }

    public static String escapeJS(String string, boolean escapeSingleQuote) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(string.length());
        for (char c : string.toCharArray()) {
            if (c > '\u0fff') {
                builder.append("\\u").append(Integer.toHexString(c));
                continue;
            }
            if (c > '\u00ff') {
                builder.append("\\u0").append(Integer.toHexString(c));
                continue;
            }
            if (c > '\u007f') {
                builder.append("\\u00").append(Integer.toHexString(c));
                continue;
            }
            if (c < ' ') {
                Json.escapeJSControlCharacter(builder, c);
                continue;
            }
            Json.escapeJSASCIICharacter(builder, c, escapeSingleQuote);
        }
        return builder.toString();
    }

    private static void escapeJSControlCharacter(StringBuilder builder, char c) {
        switch (c) {
            case '\b': {
                builder.append('\\').append('b');
                break;
            }
            case '\n': {
                builder.append('\\').append('n');
                break;
            }
            case '\t': {
                builder.append('\\').append('t');
                break;
            }
            case '\f': {
                builder.append('\\').append('f');
                break;
            }
            case '\r': {
                builder.append('\\').append('r');
                break;
            }
            default: {
                if (c > '\u000f') {
                    builder.append("\\u00").append(Integer.toHexString(c));
                    break;
                }
                builder.append("\\u000").append(Integer.toHexString(c));
            }
        }
    }

    private static void escapeJSASCIICharacter(StringBuilder builder, char c, boolean escapeSingleQuote) {
        switch (c) {
            case '\'': {
                if (escapeSingleQuote) {
                    builder.append('\\');
                }
                builder.append('\'');
                break;
            }
            case '\"': {
                builder.append('\\').append('\"');
                break;
            }
            case '\\': {
                builder.append('\\').append('\\');
                break;
            }
            case '/': {
                builder.append('\\').append('/');
                break;
            }
            default: {
                builder.append(c);
            }
        }
    }

    public static String formatRFC1123(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_RFC1123_DATE, Locale.US);
        sdf.setTimeZone(TIMEZONE_GMT);
        return sdf.format(date);
    }

    public static Date parseRFC1123(String string) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_RFC1123_DATE, Locale.US);
        return sdf.parse(string);
    }
}

