/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.ext;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.component.html.ext.HtmlSelectManyCheckbox;
import org.apache.myfaces.custom.checkbox.HtmlCheckbox;
import org.apache.myfaces.shared_tomahawk.component.DisplayValueOnlyCapable;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlCheckboxRendererBase;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class HtmlCheckboxRenderer
extends HtmlCheckboxRendererBase {
    private static final Log log = LogFactory.getLog((Class)HtmlCheckboxRenderer.class);
    private static final String PAGE_DIRECTION = "pageDirection";
    private static final String LINE_DIRECTION = "lineDirection";
    private static final String LAYOUT_SPREAD = "spread";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        if (component instanceof HtmlCheckbox) {
            this.renderSingleCheckbox(context, (HtmlCheckbox)component);
        } else if (component instanceof DisplayValueOnlyCapable && HtmlRendererUtils.isDisplayValueOnly(component)) {
            HtmlRendererUtils.renderDisplayValueOnlyForSelects(context, component);
        } else if (component instanceof UISelectMany) {
            String layout = this.getLayout((UISelectMany)component);
            if (layout != null && layout.equals(LAYOUT_SPREAD)) {
                return;
            }
            super.encodeEnd(context, component);
        } else if (component instanceof UISelectBoolean) {
            super.encodeEnd(context, component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    public void renderCheckboxList(FacesContext facesContext, UISelectMany selectMany) throws IOException {
        String layout = this.getLayout(selectMany);
        if (layout != null) {
            Converter converter = this.getConverter(facesContext, selectMany);
            if (layout.equals(PAGE_DIRECTION)) {
                this.renderCheckboxListVertically(facesContext, selectMany, converter);
            } else if (layout.equals(LINE_DIRECTION)) {
                this.renderCheckboxListHorizontally(facesContext, selectMany, converter);
            } else {
                log.error((Object)("Wrong layout attribute for component " + selectMany.getClientId(facesContext) + ": " + layout));
            }
        }
    }

    protected void renderCheckboxListHorizontally(FacesContext facesContext, UISelectMany selectMany, Converter converter) throws IOException {
        boolean useSubmittedValues;
        Set lookupSet = RendererUtils.getSubmittedValuesAsSet(facesContext, (UIComponent)selectMany, converter, selectMany);
        boolean bl = useSubmittedValues = lookupSet != null;
        if (!useSubmittedValues) {
            lookupSet = RendererUtils.getSelectedValuesAsSet(facesContext, (UIComponent)selectMany, converter, selectMany);
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("table", (UIComponent)selectMany);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)selectMany, HTML.SELECT_TABLE_PASSTHROUGH_ATTRIBUTES);
        HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)selectMany, facesContext);
        int numRows = this.getLayoutWidth(selectMany);
        for (int i = 0; i < numRows; ++i) {
            this.renderRowForHorizontal(facesContext, selectMany, converter, lookupSet, writer, numRows, i);
        }
        writer.endElement("table");
    }

    protected void renderRowForHorizontal(FacesContext facesContext, UISelectMany selectMany, Converter converter, Set lookupSet, ResponseWriter writer, int totalRows, int rowNum) throws IOException {
        writer.startElement("tr", (UIComponent)selectMany);
        int colNum = 0;
        List items = RendererUtils.getSelectItemList(selectMany);
        for (int count = rowNum; count < items.size(); ++count) {
            int mod = count % totalRows;
            if (mod != rowNum) continue;
            ++colNum;
            SelectItem selectItem = (SelectItem)items.get(count);
            writer.startElement("td", (UIComponent)selectMany);
            this.renderGroupOrItemCheckbox(facesContext, (UIComponent)selectMany, selectItem, lookupSet != null, lookupSet, converter, false);
            writer.endElement("td");
        }
        int totalItems = items.size();
        int totalCols = totalItems / totalRows;
        if (totalItems % totalRows != 0) {
            ++totalCols;
        }
        if (colNum < totalCols) {
            writer.startElement("td", (UIComponent)selectMany);
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    protected void renderCheckboxListVertically(FacesContext facesContext, UISelectMany selectMany, Converter converter) throws IOException {
        boolean useSubmittedValues;
        Set lookupSet = RendererUtils.getSubmittedValuesAsSet(facesContext, (UIComponent)selectMany, converter, selectMany);
        boolean bl = useSubmittedValues = lookupSet != null;
        if (!useSubmittedValues) {
            lookupSet = RendererUtils.getSelectedValuesAsSet(facesContext, (UIComponent)selectMany, converter, selectMany);
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("table", (UIComponent)selectMany);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)selectMany, HTML.SELECT_TABLE_PASSTHROUGH_ATTRIBUTES);
        HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)selectMany, facesContext);
        List items = RendererUtils.getSelectItemList(selectMany);
        int totalItems = items.size();
        for (int count = 0; count < totalItems; ++count) {
            writer.startElement("tr", (UIComponent)selectMany);
            int numCols = this.getLayoutWidth(selectMany);
            for (int i = 0; i < numCols; ++i) {
                writer.startElement("td", (UIComponent)selectMany);
                if (count < totalItems) {
                    SelectItem selectItem = (SelectItem)items.get(count);
                    this.renderGroupOrItemCheckbox(facesContext, (UIComponent)selectMany, selectItem, lookupSet != null, lookupSet, converter, true);
                }
                writer.endElement("td");
                if (i >= numCols - 1) continue;
                ++count;
            }
            writer.endElement("tr");
        }
        writer.endElement("table");
    }

    protected void renderGroupOrItemCheckbox(FacesContext facesContext, UIComponent uiComponent, SelectItem selectItem, boolean useSubmittedValues, Set lookupSet, Converter converter, boolean pageDirectionLayout) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        boolean isSelectItemGroup = selectItem instanceof SelectItemGroup;
        if (isSelectItemGroup) {
            SelectItemGroup selectItemGroup = (SelectItemGroup)selectItem;
            this.renderCheckboxGroup(facesContext, uiComponent, selectItemGroup, useSubmittedValues, lookupSet, converter, pageDirectionLayout);
        } else {
            UISelectMany selectMany = (UISelectMany)uiComponent;
            Object itemValue = selectItem.getValue();
            String itemStrValue = this.getItemStringValue(facesContext, selectMany, converter, itemValue);
            boolean checked = useSubmittedValues && lookupSet.contains(itemStrValue) || !useSubmittedValues && lookupSet.contains(itemValue);
            boolean disabled = selectItem.isDisabled();
            writer.startElement("label", (UIComponent)selectMany);
            this.renderLabelClassIfNecessary(facesContext, selectMany, disabled);
            this.renderCheckbox(facesContext, (UIComponent)selectMany, itemStrValue, selectItem.getLabel(), disabled, checked, false);
            writer.endElement("label");
        }
    }

    protected void renderLabelClassIfNecessary(FacesContext facesContext, UISelectMany selectMany, boolean disabled) throws IOException {
        String labelClass = null;
        boolean componentDisabled = this.isDisabled(facesContext, (UIComponent)selectMany);
        labelClass = componentDisabled || disabled ? (String)selectMany.getAttributes().get("disabledClass") : (String)selectMany.getAttributes().get("enabledClass");
        if (labelClass != null) {
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.writeAttribute("class", (Object)labelClass, "labelClass");
        }
    }

    protected void renderCheckboxGroup(FacesContext facesContext, UIComponent uiComponent, SelectItemGroup selectItemGroup, boolean useSubmittedValues, Set lookupSet, Converter converter, boolean pageDirectionLayout) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        UISelectMany selectMany = (UISelectMany)uiComponent;
        writer.startElement("table", (UIComponent)selectMany);
        if (pageDirectionLayout) {
            writer.startElement("tr", (UIComponent)selectMany);
        }
        writer.startElement("td", (UIComponent)selectMany);
        writer.writeText((Object)selectItemGroup.getLabel(), null);
        writer.endElement("td");
        if (pageDirectionLayout) {
            writer.endElement("tr");
            writer.startElement("tr", (UIComponent)selectMany);
        }
        writer.startElement("td", (UIComponent)selectMany);
        writer.startElement("table", (UIComponent)selectMany);
        writer.writeAttribute("border", (Object)"0", null);
        SelectItem[] selectItems = selectItemGroup.getSelectItems();
        for (int i = 0; i < selectItems.length; ++i) {
            this.renderGroupOrItemCheckbox(facesContext, (UIComponent)selectMany, selectItems[i], useSubmittedValues, lookupSet, converter, pageDirectionLayout);
        }
        writer.endElement("table");
        writer.endElement("td");
        if (pageDirectionLayout) {
            writer.endElement("tr");
        }
        writer.endElement("table");
    }

    protected String getLayout(UISelectMany selectMany) {
        String layout = super.getLayout(selectMany);
        if (layout == null) {
            layout = LINE_DIRECTION;
        }
        return layout;
    }

    protected int getLayoutWidth(UISelectMany selectMany) {
        String layoutWidthString = null;
        layoutWidthString = selectMany instanceof HtmlSelectManyCheckbox ? ((HtmlSelectManyCheckbox)selectMany).getLayoutWidth() : (String)selectMany.getAttributes().get("layoutWidth");
        boolean defaultLayoutWidth = true;
        int layoutWidth = 1;
        try {
            if (layoutWidthString != null && layoutWidthString.trim().length() > 0) {
                layoutWidth = Integer.parseInt(layoutWidthString);
            }
            if (layoutWidth < 1) {
                layoutWidth = 1;
            }
        }
        catch (Exception e) {
            layoutWidth = 1;
        }
        return layoutWidth;
    }

    protected void renderSingleCheckbox(FacesContext facesContext, HtmlCheckbox checkbox) throws IOException {
        boolean useSubmittedValues;
        String forAttr = checkbox.getFor();
        if (forAttr == null) {
            throw new IllegalStateException("mandatory attribute 'for'");
        }
        int index = checkbox.getIndex();
        if (index < 0) {
            throw new IllegalStateException("positive index must be given");
        }
        UIComponent uiComponent = checkbox.findComponent(forAttr);
        if (uiComponent == null) {
            throw new IllegalStateException("Could not find component '" + forAttr + "' (calling findComponent on component '" + checkbox.getClientId(facesContext) + "')");
        }
        if (!(uiComponent instanceof UISelectMany)) {
            throw new IllegalStateException("UISelectMany expected");
        }
        UISelectMany uiSelectMany = (UISelectMany)uiComponent;
        Converter converter = this.getConverter(facesContext, uiSelectMany);
        List selectItemList = RendererUtils.getSelectItemList(uiSelectMany);
        if (index >= selectItemList.size()) {
            throw new IndexOutOfBoundsException("index " + index + " >= " + selectItemList.size());
        }
        SelectItem selectItem = (SelectItem)selectItemList.get(index);
        Object itemValue = selectItem.getValue();
        String itemStrValue = this.getItemStringValue(facesContext, uiSelectMany, converter, itemValue);
        Set lookupSet = RendererUtils.getSubmittedValuesAsSet(facesContext, uiComponent, converter, uiSelectMany);
        boolean bl = useSubmittedValues = lookupSet != null;
        if (!useSubmittedValues) {
            lookupSet = RendererUtils.getSelectedValuesAsSet(facesContext, uiComponent, converter, uiSelectMany);
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("label", (UIComponent)uiSelectMany);
        this.renderCheckbox(facesContext, (UIComponent)uiSelectMany, itemStrValue, selectItem.getLabel(), this.isDisabled(facesContext, (UIComponent)uiSelectMany), lookupSet.contains(itemStrValue), false, index);
        writer.endElement("label");
    }

    protected String renderCheckbox(FacesContext facesContext, UIComponent uiComponent, String value, String label, boolean disabled, boolean checked, boolean renderId, int itemNum) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        String itemId = clientId + ':' + itemNum;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", uiComponent);
        if (itemId != null) {
            writer.writeAttribute("id", (Object)itemId, null);
        }
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("name", (Object)clientId, null);
        if (renderId) {
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        }
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (value != null && value.length() > 0) {
            writer.writeAttribute("value", (Object)value, null);
        }
        if (uiComponent instanceof UISelectBoolean) {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_ATTRIBUTES);
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_PASSTROUGH_ATTRIBUTES_WITHOUT_STYLE);
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_FIELD_ATTRIBUTES_WITHOUT_DISABLED);
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_FIELD_EVENT_ATTRIBUTES);
        }
        if (this.isDisabled(facesContext, uiComponent)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        writer.endElement("input");
        if (label != null && label.length() > 0) {
            writer.write("&#160;");
            writer.writeText((Object)label, null);
        }
        return itemId;
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (!UserRoleUtils.isEnabledOnUserRole(uiComponent)) {
            return true;
        }
        return super.isDisabled(facesContext, uiComponent);
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        if (!(uiComponent instanceof HtmlCheckbox)) {
            super.decode(facesContext, uiComponent);
        }
    }

    protected String getItemStringValue(FacesContext facesContext, UISelectMany selectMany, Converter converter, Object itemValue) {
        String itemStrValue = converter == null ? itemValue.toString() : converter.getAsString(facesContext, (UIComponent)selectMany, itemValue);
        return itemStrValue;
    }

    protected Converter getConverter(FacesContext facesContext, UISelectMany selectMany) {
        Converter converter;
        try {
            converter = RendererUtils.findUISelectManyConverter(facesContext, selectMany);
        }
        catch (FacesException e) {
            log.error((Object)("Error finding Converter for component with id " + selectMany.getClientId(facesContext)));
            converter = null;
        }
        return converter;
    }
}

