/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.application;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public class NavigationHandlerImpl
extends ConfigurableNavigationHandler {
    private Boolean _disabled;
    private NavigationHandler _delegate;
    private final Map<String, Set<NavigationCase>> _emptyCaces = new HashMap<String, Set<NavigationCase>>();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(NavigationHandlerImpl.class);

    public NavigationHandlerImpl(NavigationHandler delegate) {
        this._delegate = delegate;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        if (this._disableNavigationHandler(context)) {
            this._delegate.handleNavigation(context, fromAction, outcome);
            return;
        }
        RequestContext afc = RequestContext.getCurrentInstance();
        if (outcome != null && outcome.startsWith(afc.getDialogService().getDialogNavigationPrefix())) {
            NavigationCase navigationCase = this.getNavigationCase(context, fromAction, outcome);
            if (navigationCase == null) {
                navigationCase = this.getNavigationCase(context, fromAction, outcome.substring(afc.getDialogService().getDialogNavigationPrefix().length()));
            }
            UIViewRoot newRoot = null;
            UIViewRoot oldRoot = context.getViewRoot();
            if (navigationCase == null) {
                Map viewMap = oldRoot.getViewMap(false);
                HashMap cloneMap = viewMap == null ? null : new HashMap(viewMap);
                this._delegate.handleNavigation(context, fromAction, outcome);
                newRoot = context.getViewRoot();
                if (newRoot != oldRoot) {
                    context.setViewRoot(oldRoot);
                    if (cloneMap != null) {
                        oldRoot.getViewMap().putAll(cloneMap);
                    }
                }
            } else {
                newRoot = context.getApplication().getViewHandler().createView(context, navigationCase.getToViewId(context));
            }
            if (newRoot != oldRoot) {
                afc.getPageFlowScopeProvider().pushPageFlowScope(context, true);
                afc.getDialogService().queueLaunchEvent(newRoot);
            }
        } else {
            this._delegate.handleNavigation(context, fromAction, outcome);
        }
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
        if (!(this._delegate instanceof ConfigurableNavigationHandler)) {
            return null;
        }
        return ((ConfigurableNavigationHandler)this._delegate).getNavigationCase(context, fromAction, outcome);
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        if (!(this._delegate instanceof ConfigurableNavigationHandler)) {
            return this._emptyCaces;
        }
        return ((ConfigurableNavigationHandler)this._delegate).getNavigationCases();
    }

    private synchronized boolean _disableNavigationHandler(FacesContext context) {
        if (this._disabled == null) {
            this._disabled = Boolean.FALSE;
            Object disabledAttr = context.getExternalContext().getApplicationMap().get("org.apache.myfaces.trinidad.DISABLE_DIALOG_OUTCOMES");
            if (disabledAttr != null) {
                this._disabled = "true".equalsIgnoreCase(disabledAttr.toString());
            } else {
                String disabledParam = context.getExternalContext().getInitParameter("org.apache.myfaces.trinidad.DISABLE_DIALOG_OUTCOMES");
                if (disabledParam != null) {
                    this._disabled = "true".equalsIgnoreCase(disabledParam);
                }
            }
        }
        return this._disabled;
    }
}

