/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.extensions.validator.test.core.stage;

import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.core.ProjectStage;
import org.apache.myfaces.extensions.validator.core.ProjectStageName;

/**
 * custom project stage
 *
 * @since x.x.3
 */
@UsageInformation(UsageCategory.INTERNAL)
enum CustomProjectStage
{
    Dev(ProjectStage.createStageName("Dev")),
    Test(ProjectStage.createStageName("Test")),
    Prod(ProjectStage.createStageName("Prod"));

    private final ProjectStageName value;

    CustomProjectStage(ProjectStageName value)
    {
        this.value = value;
    }

    public static boolean is(CustomProjectStage customProjectStage)
    {
        return ProjectStage.is(customProjectStage.getValue());
    }

    public ProjectStageName getValue()
    {
        return this.value;
    }
}