/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.control;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import jpt.sun.source.tree.AssignmentTree;
import jpt.sun.source.tree.BinaryTree;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.CaseTree;
import jpt.sun.source.tree.CompoundAssignmentTree;
import jpt.sun.source.tree.ConditionalExpressionTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.InstanceOfTree;
import jpt.sun.source.tree.LambdaExpressionTree;
import jpt.sun.source.tree.LiteralTree;
import jpt.sun.source.tree.MemberReferenceTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.NewArrayTree;
import jpt.sun.source.tree.NewClassTree;
import jpt.sun.source.tree.ReturnTree;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.SwitchTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.TryTree;
import jpt.sun.source.tree.TypeCastTree;
import jpt.sun.source.tree.UnaryTree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.ExecutableType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.hints.control.Bundle;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.openide.util.NbBundle;

public class RemoveUnnecessary {
    private static final Set<Tree.Kind> LOOP_KINDS = EnumSet.of(Tree.Kind.DO_WHILE_LOOP, Tree.Kind.ENHANCED_FOR_LOOP, Tree.Kind.FOR_LOOP, Tree.Kind.WHILE_LOOP);

    public static ErrorDescription unnecessaryReturn(HintContext ctx) {
        return RemoveUnnecessary.unnecessaryReturnContinue(ctx, null, "UnnecessaryReturnStatement", true);
    }

    public static ErrorDescription unnecessaryContinue(HintContext ctx) {
        return RemoveUnnecessary.unnecessaryReturnContinue(ctx, ctx.getInfo().getTreeUtilities().getBreakContinueTargetTree(ctx.getPath()), "UnnecessaryContinueStatement", false);
    }

    private static ErrorDescription unnecessaryReturnContinue(HintContext ctx, Tree targetLoop, String key, boolean isReturn) {
        TreePath tp = ctx.getPath();
        block12: while (tp != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
            List<? extends StatementTree> statements;
            Tree current = tp.getLeaf();
            if ((tp = tp.getParentPath()) == null) {
                return null;
            }
            block0 : switch (tp.getLeaf().getKind()) {
                case METHOD: {
                    if (targetLoop != null) {
                        return null;
                    }
                    MethodTree mt = (MethodTree)tp.getLeaf();
                    if (mt.getReturnType() == null) {
                        if (mt.getName().contentEquals("<init>")) break block12;
                        return null;
                    }
                    TypeMirror tm = ctx.getInfo().getTrees().getTypeMirror(new TreePath(tp, mt.getReturnType()));
                    if (tm != null && tm.getKind() == TypeKind.VOID) break block12;
                    return null;
                }
                case LAMBDA_EXPRESSION: {
                    TypeMirror returnType;
                    if (targetLoop != null) {
                        return null;
                    }
                    TypeMirror functionalType = ctx.getInfo().getTrees().getTypeMirror(tp);
                    if (functionalType == null || functionalType.getKind() != TypeKind.DECLARED) {
                        return null;
                    }
                    ExecutableType descriptorType = ctx.getInfo().getTypeUtilities().getDescriptorType((DeclaredType)functionalType);
                    TypeMirror typeMirror = returnType = descriptorType != null ? descriptorType.getReturnType() : null;
                    if (returnType != null && returnType.getKind() == TypeKind.VOID) break block12;
                    return null;
                }
                case BLOCK: {
                    statements = ((BlockTree)tp.getLeaf()).getStatements();
                    break;
                }
                case CASE: {
                    switch (tp.getParentPath().getLeaf().getKind()) {
                        case SWITCH: {
                            CaseTree ct = (CaseTree)tp.getLeaf();
                            if (ct.getCaseKind() == CaseTree.CaseKind.RULE) {
                                if (ExpressionTree.class.isAssignableFrom(ct.getBody().getKind().asInterface())) {
                                    return null;
                                }
                                statements = List.of((StatementTree)ct.getBody());
                                break block0;
                            }
                            List<? extends CaseTree> cases = ((SwitchTree)tp.getParentPath().getLeaf()).getCases();
                            ArrayList<? extends StatementTree> locStatements = new ArrayList<StatementTree>();
                            for (int i = cases.indexOf(tp.getLeaf()); i < cases.size(); ++i) {
                                List<? extends StatementTree> list = cases.get(i).getStatements();
                                if (list == null) continue;
                                locStatements.addAll(list);
                            }
                            statements = locStatements;
                            break block0;
                        }
                        case SWITCH_EXPRESSION: {
                            return null;
                        }
                    }
                    statements = ((CaseTree)tp.getLeaf()).getStatements();
                    break;
                }
                case DO_WHILE_LOOP: 
                case ENHANCED_FOR_LOOP: 
                case FOR_LOOP: 
                case WHILE_LOOP: {
                    if (tp.getLeaf() == targetLoop) break block12;
                    return null;
                }
                case TRY: {
                    if (((TryTree)tp.getLeaf()).getFinallyBlock() == current) {
                        return null;
                    }
                }
                default: {
                    continue block12;
                }
            }
            assert (!statements.isEmpty());
            int i = statements.indexOf(current);
            if (i == -1) {
                return null;
            }
            while (i + 1 < statements.size()) {
                StatementTree next = statements.get(i + 1);
                if (next.getKind() == Tree.Kind.EMPTY_STATEMENT) {
                    ++i;
                    continue;
                }
                if (next.getKind() == Tree.Kind.BLOCK) {
                    statements = ((BlockTree)next).getStatements();
                    i = -1;
                    continue;
                }
                if (next.getKind() == Tree.Kind.BREAK) {
                    Tree target = ctx.getInfo().getTreeUtilities().getBreakContinueTargetTree(new TreePath(tp, next));
                    if (target == null) {
                        return null;
                    }
                    tp = TreePath.getPath(ctx.getInfo().getCompilationUnit(), target);
                    continue block12;
                }
                return null;
            }
        }
        Fix toExpression = null;
        if (isReturn) {
            ExpressionToStatement scanner = new ExpressionToStatement(null, ctx.getInfo());
            scanner.scan(ctx.getPath(), null);
            if (!scanner.remove) {
                toExpression = new MakeExpressionStatement(ctx.getInfo(), ctx.getPath()).toEditorFix();
            }
        }
        String displayName = NbBundle.getMessage(RemoveUnnecessary.class, "ERR_" + key);
        String fixDisplayName = NbBundle.getMessage(RemoveUnnecessary.class, "FIX_" + key);
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), displayName, JavaFixUtilities.removeFromParent(ctx, fixDisplayName, ctx.getPath()), toExpression);
    }

    public static ErrorDescription unnecessaryContinueLabel(HintContext ctx) {
        return RemoveUnnecessary.unnecessaryLabel(ctx, false);
    }

    public static ErrorDescription unnecessaryBreakLabel(HintContext ctx) {
        return RemoveUnnecessary.unnecessaryLabel(ctx, true);
    }

    private static ErrorDescription unnecessaryLabel(HintContext ctx, boolean brk) {
        TreePath loop;
        for (loop = ctx.getPath(); !(loop == null || LOOP_KINDS.contains((Object)loop.getLeaf().getKind()) || brk && loop.getLeaf().getKind() == Tree.Kind.SWITCH); loop = loop.getParentPath()) {
        }
        if (loop == null) {
            return null;
        }
        if (ctx.getInfo().getTreeUtilities().getBreakContinueTargetTree(ctx.getPath()) != loop.getParentPath().getLeaf()) {
            return null;
        }
        Fix fix = JavaFixUtilities.rewriteFix(ctx, brk ? Bundle.FIX_UnnecessaryBreakStatementLabel() : Bundle.FIX_UnnecessaryContinueStatementLabel(), ctx.getPath(), brk ? "break;" : "continue;");
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), brk ? Bundle.ERR_UnnecessaryBreakStatementLabel() : Bundle.ERR_UnnecessaryContinueStatementLabel(), fix);
    }

    static class ExpressionToStatement
    extends ErrorAwareTreePathScanner {
        private boolean remove = true;
        private List<StatementTree> statements = new ArrayList<StatementTree>();
        private final TreeMaker mk;
        private final CompilationInfo cinfo;

        public ExpressionToStatement(TreeMaker mk, CompilationInfo cinfo) {
            this.mk = mk;
            this.cinfo = cinfo;
        }

        private Object addExpressionStatement(ExpressionTree node, Object p) {
            if (this.mk != null) {
                this.statements.add(this.mk.ExpressionStatement(node));
            }
            this.remove = false;
            return null;
        }

        @Override
        public Object visitLiteral(LiteralTree node, Object p) {
            return null;
        }

        @Override
        public Object visitIdentifier(IdentifierTree node, Object p) {
            return null;
        }

        @Override
        public Object visitMemberReference(MemberReferenceTree node, Object p) {
            return null;
        }

        @Override
        public Object visitMemberSelect(MemberSelectTree node, Object p) {
            return null;
        }

        @Override
        public Object visitInstanceOf(InstanceOfTree node, Object p) {
            return null;
        }

        @Override
        public Object visitLambdaExpression(LambdaExpressionTree node, Object p) {
            return null;
        }

        @Override
        public Object visitNewArray(NewArrayTree node, Object p) {
            return null;
        }

        @Override
        public Object visitTypeCast(TypeCastTree node, Object p) {
            return this.scan(node.getExpression(), p);
        }

        public Object transformLogAndOr(BinaryTree node, Object p) {
            List<StatementTree> saveStats = this.statements;
            boolean saveRemove = this.remove;
            this.remove = true;
            this.statements = new ArrayList<StatementTree>();
            this.scan(node.getRightOperand(), p);
            if (this.remove) {
                this.statements = saveStats;
                this.scan(node.getLeftOperand(), p);
                if (this.remove) {
                    this.remove &= saveRemove;
                    return null;
                }
                this.remove &= saveRemove;
            } else {
                List<StatementTree> elseStats = this.statements;
                this.statements = saveStats;
                this.remove = false;
                if (this.mk != null) {
                    ExpressionTree condition = node.getKind() == Tree.Kind.CONDITIONAL_AND ? node.getLeftOperand() : Utilities.negate(this.mk, node.getLeftOperand(), node);
                    this.statements.add(this.mk.If(condition, elseStats.size() == 1 ? elseStats.get(0) : this.mk.Block(elseStats, false), null));
                }
            }
            return null;
        }

        @Override
        public Object visitBinary(BinaryTree node, Object p) {
            switch (node.getKind()) {
                case CONDITIONAL_AND: 
                case CONDITIONAL_OR: {
                    return this.transformLogAndOr(node, p);
                }
            }
            this.scan(node.getLeftOperand(), p);
            this.scan(node.getRightOperand(), p);
            return null;
        }

        @Override
        public Object visitUnary(UnaryTree node, Object p) {
            this.scan(node.getExpression(), p);
            return null;
        }

        @Override
        public Object visitAssignment(AssignmentTree node, Object p) {
            return this.addExpressionStatement(node, p);
        }

        @Override
        public Object visitCompoundAssignment(CompoundAssignmentTree node, Object p) {
            return this.addExpressionStatement(node, p);
        }

        @Override
        public Object visitNewClass(NewClassTree node, Object p) {
            return this.addExpressionStatement(node, p);
        }

        @Override
        public Object visitMethodInvocation(MethodInvocationTree node, Object p) {
            return this.addExpressionStatement(node, p);
        }

        @Override
        public Object visitConditionalExpression(ConditionalExpressionTree node, Object p) {
            List<StatementTree> saveStat = this.statements;
            boolean saveRemove = this.remove;
            this.statements = new ArrayList<StatementTree>();
            this.scan(node.getTrueExpression(), p);
            List<StatementTree> trueStat = this.statements;
            this.statements = new ArrayList<StatementTree>();
            this.scan(node.getFalseExpression(), p);
            List<StatementTree> falseStat = this.statements;
            this.statements = saveStat;
            boolean bl = this.remove = saveRemove && this.remove;
            if (trueStat.isEmpty()) {
                if (falseStat.isEmpty()) {
                    return null;
                }
                this.statements.add(this.mk.If(this.mk.Unary(Tree.Kind.LOGICAL_COMPLEMENT, node.getCondition()), falseStat.size() == 1 ? falseStat.get(0) : this.mk.Block(falseStat, false), null));
            } else {
                this.statements.add(this.mk.If(node.getCondition(), trueStat.size() == 1 ? trueStat.get(0) : this.mk.Block(trueStat, false), falseStat.isEmpty() ? null : (falseStat.size() == 1 ? falseStat.get(0) : this.mk.Block(falseStat, false))));
            }
            return null;
        }
    }

    private static class MakeExpressionStatement
    extends JavaFix {
        public MakeExpressionStatement(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        @Override
        protected String getText() {
            return Bundle.FIX_MakeExpressionStatement();
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TreePath retPath = ctx.getPath();
            if (retPath.getLeaf().getKind() != Tree.Kind.RETURN) {
                return;
            }
            ReturnTree rtt = (ReturnTree)retPath.getLeaf();
            if (rtt.getExpression() == null) {
                return;
            }
            WorkingCopy wc = ctx.getWorkingCopy();
            ExpressionToStatement st = new ExpressionToStatement(wc.getTreeMaker(), wc);
            st.scan(new TreePath(retPath, rtt.getExpression()), null);
            if (st.remove || st.statements.isEmpty()) {
                return;
            }
            Utilities.replaceStatement(wc, retPath, st.statements);
        }
    }
}

