/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.spi.java.project.support.ui.Bundle;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

final class MakeSharableVisualPanel1
extends JPanel {
    private AntProjectHelper helper;
    private ChangeSupport support;
    private WizardDescriptor settings;
    private DocumentListener docListener;
    private JButton btnDefinition;
    private JLabel lblDefinition;
    private JLabel lblNote;
    private JTextField txtDefinition;

    public MakeSharableVisualPanel1(ChangeSupport supp) {
        this.initComponents();
        this.support = supp;
        this.docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MakeSharableVisualPanel1.this.support.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MakeSharableVisualPanel1.this.support.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MakeSharableVisualPanel1.this.support.fireChange();
            }
        };
        this.txtDefinition.getDocument().addDocumentListener(this.docListener);
    }

    @Override
    public String getName() {
        return Bundle.TIT_LibraryDefinitionSelection();
    }

    boolean isValidPanel() {
        String location = this.getLibraryLocation();
        boolean wrong = false;
        if (new File(location).isAbsolute()) {
            this.settings.putProperty("WizardPanel_errorMessage", Bundle.WARN_MakeSharable_absolutePath());
            wrong = true;
        } else {
            File libLoc;
            File projectLoc = FileUtil.toFile(this.helper.getProjectDirectory());
            if (!CollocationQuery.areCollocated(projectLoc, libLoc = PropertyUtils.resolveFile(projectLoc, location))) {
                this.settings.putProperty("WizardPanel_errorMessage", Bundle.WARN_makeSharable_relativePath());
                wrong = true;
            }
        }
        if (!wrong) {
            this.settings.putProperty("WizardPanel_errorMessage", null);
        }
        return true;
    }

    private String getLibraryLocation() {
        return this.txtDefinition.getText().trim();
    }

    private void setLibraryLocation(String loc) {
        this.txtDefinition.setText(loc);
    }

    void readSettings(WizardDescriptor wiz) {
        this.settings = wiz;
        Object loc = (String)wiz.getProperty("location");
        this.helper = (AntProjectHelper)wiz.getProperty("helper");
        loc = loc == null ? "." + File.separator + "lib" : ((String)loc).substring(0, ((String)loc).length() - "nblibraries.properties".length());
        this.setLibraryLocation((String)loc);
        this.support.fireChange();
    }

    void storeSettings(WizardDescriptor wiz) {
        Object librariesDefinition = this.getLibraryLocation();
        if (librariesDefinition != null) {
            if (((String)librariesDefinition).length() != 0 && !((String)librariesDefinition).endsWith(File.separator)) {
                librariesDefinition = (String)librariesDefinition + File.separatorChar;
            }
            librariesDefinition = (String)librariesDefinition + "nblibraries.properties";
        }
        wiz.putProperty("location", librariesDefinition);
    }

    private void initComponents() {
        this.lblDefinition = new JLabel();
        this.txtDefinition = new JTextField();
        this.btnDefinition = new JButton();
        this.lblNote = new JLabel();
        this.lblDefinition.setLabelFor(this.txtDefinition);
        Mnemonics.setLocalizedText(this.lblDefinition, NbBundle.getMessage(MakeSharableVisualPanel1.class, "MakeSharableVisualPanel1.lblDefinition.text"));
        Mnemonics.setLocalizedText(this.btnDefinition, NbBundle.getMessage(MakeSharableVisualPanel1.class, "MakeSharableVisualPanel1.btnDefinition.text"));
        this.btnDefinition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MakeSharableVisualPanel1.this.btnDefinitionActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.lblNote, NbBundle.getMessage(MakeSharableVisualPanel1.class, "MakeSharableVisualPanel1.lblNote.text"));
        this.lblNote.setVerticalAlignment(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblDefinition).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblNote, -1, 365, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.txtDefinition, -1, 257, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDefinition)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnDefinition).addComponent(this.lblDefinition).addComponent(this.txtDefinition, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNote, -2, 129, -2).addContainerGap(116, Short.MAX_VALUE)));
        this.lblDefinition.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeSharableVisualPanel1.class, "ACSD_lblDefinition"));
        this.txtDefinition.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeSharableVisualPanel1.class, "ACSD_lblDefinition"));
        this.btnDefinition.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeSharableVisualPanel1.class, "ACSD_btnDefinition"));
    }

    private void btnDefinitionActionPerformed(ActionEvent evt) {
        File f = FileUtil.toFile(this.helper.getProjectDirectory());
        String curr = SharableLibrariesUtils.browseForLibraryLocation(this.getLibraryLocation(), this, f);
        if (curr != null) {
            this.setLibraryLocation(curr);
        }
    }
}

