/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage.deb;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.netbeans.nbpackage.AbstractPackagerTask;
import org.apache.netbeans.nbpackage.Architecture;
import org.apache.netbeans.nbpackage.ExecutionContext;
import org.apache.netbeans.nbpackage.NBPackage;
import org.apache.netbeans.nbpackage.StringUtils;
import org.apache.netbeans.nbpackage.deb.DebPackager;

class DebTask
extends AbstractPackagerTask {
    private static final String DPKG = "dpkg";
    private static final String DPKG_DEB = "dpkg-deb";
    private static final String FAKEROOT = "fakeroot";
    private static final String ARCH_ALL = "all";
    private static final String ARCH_AMD64 = "amd64";
    private static final String ARCH_ARM64 = "arm64";
    private String packageName;
    private String packageVersion;
    private String packageArch;

    DebTask(ExecutionContext context) {
        super(context);
    }

    @Override
    protected void checkPackageRequirements() throws Exception {
        this.validateTools(DPKG, DPKG_DEB, FAKEROOT);
    }

    @Override
    protected void customizeImage(Path image) throws Exception {
        String pkgName = this.packageName();
        String base = "usr";
        Path baseDir = image.resolve(base);
        Path appDir = baseDir.resolve("lib").resolve(pkgName);
        Files.move(baseDir.resolve("lib").resolve("APPDIR"), appDir, new CopyOption[0]);
        String execName = this.findLauncher(appDir.resolve("bin")).getFileName().toString();
        String packageLocation = "/" + base + "/lib/" + pkgName;
        Path binDir = baseDir.resolve("bin");
        Files.createDirectories(binDir, new FileAttribute[0]);
        this.setupLauncher(binDir, packageLocation, execName);
        Path share = baseDir.resolve("share");
        Files.createDirectories(share, new FileAttribute[0]);
        this.setupIcons(share, pkgName);
        this.setupDesktopFile(share, "/" + base + "/bin/" + execName, pkgName);
        Path DEBIAN = image.resolve("DEBIAN");
        Files.createDirectories(DEBIAN, new FileAttribute[0]);
        this.setupControlFile(DEBIAN);
    }

    @Override
    protected Path buildPackage(Path image) throws Exception {
        String targetName = image.getFileName().toString() + ".deb";
        Path target = this.context().destination().resolve(targetName).toAbsolutePath();
        if (Files.exists(target, new LinkOption[0])) {
            throw new FileAlreadyExistsException(target.toString());
        }
        int result = this.context().exec(FAKEROOT, DPKG_DEB, "--build", image.toAbsolutePath().toString(), target.toString());
        if (result != 0) {
            throw new Exception();
        }
        return target;
    }

    @Override
    protected String calculateImageName(Path input) throws Exception {
        return this.packageName() + "_" + this.packageVersion() + "_" + this.packageArch();
    }

    @Override
    protected Path calculateAppPath(Path image) throws Exception {
        return image.resolve("usr").resolve("lib").resolve("APPDIR");
    }

    private void validateTools(String ... tools) throws Exception {
        if (this.context().isVerbose()) {
            this.context().infoHandler().accept(MessageFormat.format(DebPackager.MESSAGES.getString("message.validatingtools"), Arrays.toString(tools)));
        }
        for (String tool : tools) {
            if (this.context().exec(List.of("which", tool)) == 0) continue;
            throw new IllegalStateException(DebPackager.MESSAGES.getString("message.missingdebtools"));
        }
    }

    private String packageName() {
        if (this.packageName == null) {
            String name = this.sanitize(this.context().getValue(NBPackage.PACKAGE_NAME).orElseThrow());
            if (name.length() < 2 || !Character.isLetter(name.charAt(0))) {
                throw new IllegalArgumentException();
            }
            this.packageName = name;
        }
        return this.packageName;
    }

    private String packageVersion() {
        if (this.packageVersion == null) {
            String version = this.sanitizeVersion(this.context().getValue(NBPackage.PACKAGE_VERSION).orElse("1.0"));
            this.packageVersion = version + "-1";
        }
        return this.packageVersion;
    }

    private String packageArch() {
        if (this.packageArch == null) {
            this.packageArch = this.context().getValue(NBPackage.PACKAGE_ARCH).orElseGet(() -> {
                Optional<Path> runtime = this.context().getValue(NBPackage.PACKAGE_RUNTIME);
                if (runtime.isPresent()) {
                    return Architecture.detectFromPath(runtime.get()).map(a -> switch (a) {
                        default -> throw new MatchException(null, null);
                        case Architecture.AARCH64 -> ARCH_ARM64;
                        case Architecture.X86_64 -> ARCH_AMD64;
                    }).orElseGet(() -> {
                        this.context().warningHandler().accept(DebPackager.MESSAGES.getString("message.unknownarch"));
                        return ARCH_ALL;
                    });
                }
                return ARCH_ALL;
            });
        }
        return this.packageArch;
    }

    private String sanitize(String text) {
        return text.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9\\+\\-\\.]", "-");
    }

    private String sanitizeVersion(String text) {
        return text.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9\\+\\.\\~]", "~");
    }

    private Path findLauncher(Path binDir) throws IOException {
        try (Stream<Path> files = Files.list(binDir);){
            Path path = files.filter(f -> !f.getFileName().toString().endsWith(".exe")).findFirst().orElseThrow(IOException::new);
            return path;
        }
    }

    private void setupLauncher(Path binDir, String packageLocation, String execName) throws IOException {
        String template = DebPackager.LAUNCHER_TEMPLATE.load(this.context());
        String script = StringUtils.replaceTokens(template, Map.of("PACKAGE", packageLocation, "EXEC", execName));
        Path bin = binDir.resolve(execName);
        Files.writeString(bin, (CharSequence)script, StandardOpenOption.CREATE_NEW);
        try {
            Files.setPosixFilePermissions(bin, PosixFilePermissions.fromString("rwxr-xr-x"));
        }
        catch (UnsupportedOperationException ex) {
            this.context().warningHandler().accept("UnsupportedOperationException : PosixFilePermissions");
        }
    }

    private void setupIcons(Path share, String pkgName) throws IOException {
        Path iconDir = share.resolve("icons").resolve("hicolor").resolve("48x48").resolve("apps");
        Path svgDir = share.resolve("icons").resolve("hicolor").resolve("scalable").resolve("apps");
        Path icon = this.context().getValue(DebPackager.ICON_PATH).orElse(null);
        Path svg = this.context().getValue(DebPackager.SVG_ICON_PATH).orElse(null);
        if (svg != null && icon == null) {
            this.context().warningHandler().accept(DebPackager.MESSAGES.getString("message.svgnoicon"));
            svg = null;
        }
        Files.createDirectories(iconDir, new FileAttribute[0]);
        if (icon != null) {
            Files.copy(icon, iconDir.resolve(pkgName + ".png"), new CopyOption[0]);
        } else {
            Files.copy(this.getClass().getResourceAsStream("/org/apache/netbeans/nbpackage/apache-netbeans-48x48.png"), iconDir.resolve(pkgName + ".png"), new CopyOption[0]);
        }
        if (svg != null) {
            Files.createDirectories(svgDir, new FileAttribute[0]);
            Files.copy(svg, svgDir.resolve(pkgName + ".svg"), new CopyOption[0]);
        } else if (icon == null) {
            Files.createDirectories(svgDir, new FileAttribute[0]);
            Files.copy(this.getClass().getResourceAsStream("/org/apache/netbeans/nbpackage/apache-netbeans.svg"), svgDir.resolve(pkgName + ".svg"), new CopyOption[0]);
        }
    }

    private void setupDesktopFile(Path share, String exec, String pkgName) throws IOException {
        String template = DebPackager.DESKTOP_TEMPLATE.load(this.context());
        Map<String, String> tokens = Map.of("EXEC", exec, "ICON", pkgName);
        String desktop = StringUtils.replaceTokens(template, key -> {
            String ret = (String)tokens.get(key);
            if (ret != null) {
                return ret;
            }
            return this.context().tokenReplacementFor((String)key);
        });
        Path desktopDir = share.resolve("applications");
        Files.createDirectories(desktopDir, new FileAttribute[0]);
        String desktopFileName = this.context().getValue(DebPackager.DESKTOP_FILENAME).map(name -> this.sanitize((String)name)).orElse(pkgName);
        Path desktopFile = desktopDir.resolve(desktopFileName + ".desktop");
        Files.writeString(desktopFile, (CharSequence)desktop, StandardOpenOption.CREATE_NEW);
    }

    private void setupControlFile(Path DEBIAN) throws Exception {
        String template = DebPackager.CONTROL_TEMPLATE.load(this.context());
        String maintainer = this.context().getValue(DebPackager.DEB_MAINTAINER).orElse("");
        if (maintainer.isBlank()) {
            this.context().warningHandler().accept(DebPackager.MESSAGES.getString("message.nomaintainer"));
        }
        String description = this.context().getValue(NBPackage.PACKAGE_DESCRIPTION).orElse("");
        String recommends = this.context().getValue(NBPackage.PACKAGE_RUNTIME).isPresent() ? "" : "java17-sdk";
        String control = StringUtils.replaceTokens(template, Map.of("DEB_PACKAGE", this.packageName(), "DEB_VERSION", this.packageVersion(), "DEB_ARCH", this.packageArch(), "DEB_MAINTAINER", maintainer, "DEB_DESCRIPTION", description, "DEB_RECOMMENDS", recommends));
        Path controlFile = DEBIAN.resolve("control");
        Files.writeString(controlFile, (CharSequence)control, StandardOpenOption.CREATE_NEW);
    }
}

