/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.Iterator;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.util.EntityIdSetFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntityIdSetIterable;", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "(Ljetbrains/exodus/entitystore/PersistentStoreTransaction;)V", "h", "Ljetbrains/exodus/entitystore/iterate/EntityIterableHandleBase$EntityIterableHandleHash;", "getH", "()Ljetbrains/exodus/entitystore/iterate/EntityIterableHandleBase$EntityIterableHandleHash;", "ids", "Ljetbrains/exodus/entitystore/iterate/EntityIdSet;", "getIds", "()Ljetbrains/exodus/entitystore/iterate/EntityIdSet;", "setIds", "(Ljetbrains/exodus/entitystore/iterate/EntityIdSet;)V", "addTarget", "", "id", "Ljetbrains/exodus/entitystore/EntityId;", "count", "", "getHandleImpl", "Ljetbrains/exodus/entitystore/EntityIterableHandle;", "getIteratorImpl", "Ljetbrains/exodus/entitystore/EntityIterator;", "getRoughCount", "getRoughSize", "isSortedById", "", "size", "toSet", "xodus-entity-store"})
public final class EntityIdSetIterable
extends EntityIterableBase {
    @NotNull
    private final EntityIterableHandleBase.EntityIterableHandleHash h;
    @NotNull
    private EntityIdSet ids;

    public EntityIdSetIterable(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        super(txn);
        this.h = new EntityIterableHandleBase.EntityIterableHandleHash(this.getStore());
        this.ids = EntityIdSetFactory.newSet();
    }

    @NotNull
    public final EntityIterableHandleBase.EntityIterableHandleHash getH() {
        return this.h;
    }

    @NotNull
    public final EntityIdSet getIds() {
        return this.ids;
    }

    public final void setIds(@NotNull EntityIdSet entityIdSet) {
        Intrinsics.checkNotNullParameter((Object)entityIdSet, (String)"<set-?>");
        this.ids = entityIdSet;
    }

    @Override
    @NotNull
    public EntityIterator getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        return new EntityIteratorBase(this){
            @NotNull
            private final Iterator<EntityId> it;
            final /* synthetic */ EntityIdSetIterable this$0;
            {
                this.this$0 = $receiver;
                super($receiver);
                this.it = this.this$0.getIds().iterator();
            }

            @NotNull
            public final Iterator<EntityId> getIt() {
                return this.it;
            }

            protected boolean hasNextImpl() {
                return this.it.hasNext();
            }

            protected EntityId nextIdImpl() {
                return this.it.next();
            }
        };
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        PersistentEntityStoreImpl persistentEntityStoreImpl = this.getStore();
        EntityIterableType entityIterableType = EntityIterableType.FILTER_LINKS;
        return new ConstantEntityIterableHandle(this, persistentEntityStoreImpl, entityIterableType){
            final /* synthetic */ EntityIdSetIterable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                hash.apply(this.this$0.getH());
            }
        };
    }

    @Override
    public long size() {
        return this.ids.count();
    }

    @Override
    public long count() {
        return this.ids.count();
    }

    @Override
    public long getRoughCount() {
        return this.ids.count();
    }

    @Override
    public long getRoughSize() {
        return this.ids.count();
    }

    @Override
    public boolean isSortedById() {
        return false;
    }

    @Override
    @NotNull
    public EntityIdSet toSet(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        return this.ids;
    }

    public final void addTarget(@NotNull EntityId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        EntityIdSet entityIdSet = this.ids.add(id);
        Intrinsics.checkNotNullExpressionValue((Object)entityIdSet, (String)"ids.add(id)");
        this.ids = entityIdSet;
        this.h.applyDelimiter();
        this.h.apply(id.getTypeId());
        this.h.apply(id.getLocalId());
    }
}

