/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.socket;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.nifi.remote.io.InterruptableInputStream;
import org.apache.nifi.remote.protocol.CommunicationsInput;
import org.apache.nifi.stream.io.ByteCountingInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketInput
implements CommunicationsInput {
    private static final Logger LOG = LoggerFactory.getLogger(SocketInput.class);
    private final Socket socket;
    private final InputStream socketIn;
    private final ByteCountingInputStream countingIn;
    private final InputStream bufferedIn;
    private final InterruptableInputStream interruptableIn;

    public SocketInput(Socket socket) throws IOException {
        this.socket = socket;
        this.socketIn = socket.getInputStream();
        this.countingIn = new ByteCountingInputStream(this.socketIn);
        this.bufferedIn = new BufferedInputStream((InputStream)this.countingIn);
        this.interruptableIn = new InterruptableInputStream(this.bufferedIn);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.interruptableIn;
    }

    public void setTimeout(int millis) {
        try {
            this.socket.setSoTimeout(millis);
        }
        catch (SocketException e) {
            LOG.warn("Failed to set socket timeout.", (Throwable)e);
        }
    }

    public boolean isDataAvailable() {
        try {
            return this.interruptableIn.available() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public long getBytesRead() {
        return this.countingIn.getBytesRead();
    }

    public void interrupt() {
        this.interruptableIn.interrupt();
    }

    @Override
    public void consume() throws IOException {
        int bytesRead;
        if (this.interruptableIn == null || !this.isDataAvailable()) {
            return;
        }
        byte[] b = new byte[4096];
        while ((bytesRead = this.interruptableIn.read(b)) > 0) {
        }
    }
}

