/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.fastdouble;

import io.questdb.std.NumericException;
import io.questdb.std.fastdouble.FastDoubleSwar;
import io.questdb.std.fastdouble.FastDoubleUtils;
import io.questdb.std.fastdouble.FastFloatMath;
import java.nio.charset.StandardCharsets;

final class FastFloatByteArray {
    FastFloatByteArray() {
    }

    private static float fallbackToJavaParser(byte[] str, int startIndex, int endIndex, boolean rejectOverflow) throws NumericException {
        float f = Float.parseFloat(new String(str, startIndex, endIndex - startIndex, StandardCharsets.ISO_8859_1));
        if (rejectOverflow && (f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY || f == 0.0f)) {
            throw NumericException.INSTANCE;
        }
        return f;
    }

    private static boolean isDigit(byte c) {
        return 48 <= c && c <= 57;
    }

    private static float parseDecFloatLiteral(byte[] str, int index, int startIndex, int endIndex, boolean isNegative, boolean hasLeadingZero, boolean rejectOverflow) throws NumericException {
        int exponentOfTruncatedSignificand;
        boolean isSignificandTruncated;
        int exponent;
        int digitCount;
        long significand = 0L;
        int significandStartIndex = index;
        int virtualIndexOfPoint = -1;
        boolean illegal = false;
        byte ch = 0;
        while (index < endIndex) {
            ch = str[index];
            if (FastFloatByteArray.isDigit(ch)) {
                significand = 10L * significand + (long)ch - 48L;
            } else {
                int eightDigits;
                if (ch != 46) break;
                illegal |= virtualIndexOfPoint >= 0;
                virtualIndexOfPoint = index;
                while (index < endIndex - 8 && (eightDigits = FastFloatByteArray.tryToParseEightDigits(str, index + 1)) >= 0) {
                    significand = 100000000L * significand + (long)eightDigits;
                    index += 8;
                }
            }
            ++index;
        }
        int significandEndIndex = index;
        if (virtualIndexOfPoint < 0) {
            digitCount = index - significandStartIndex;
            virtualIndexOfPoint = index;
            exponent = 0;
        } else {
            digitCount = index - significandStartIndex - 1;
            exponent = virtualIndexOfPoint - index + 1;
        }
        int expNumber = 0;
        if (ch == 101 || ch == 69) {
            boolean neg_exp;
            ch = ++index < endIndex ? str[index] : (byte)0;
            boolean bl = neg_exp = ch == 45;
            if (neg_exp || ch == 43) {
                ch = ++index < endIndex ? str[index] : (byte)0;
            }
            illegal |= !FastFloatByteArray.isDigit(ch);
            do {
                if (expNumber >= 1024) continue;
                expNumber = 10 * expNumber + ch - 48;
            } while (FastFloatByteArray.isDigit(ch = ++index < endIndex ? str[index] : (byte)0));
            if (neg_exp) {
                expNumber = -expNumber;
            }
            exponent += expNumber;
        }
        if (index < endIndex && (ch == 100 || ch == 68 || ch == 102 || ch == 70)) {
            ++index;
        }
        index = FastFloatByteArray.skipWhitespace(str, index, endIndex);
        if (illegal || index < endIndex || !hasLeadingZero && digitCount == 0) {
            throw NumericException.INSTANCE;
        }
        int skipCountInTruncatedDigits = 0;
        if (digitCount > 19) {
            significand = 0L;
            for (index = significandStartIndex; index < significandEndIndex; ++index) {
                ch = str[index];
                if (ch == 46) {
                    ++skipCountInTruncatedDigits;
                    continue;
                }
                if (Long.compareUnsigned(significand, 1000000000000000000L) >= 0) break;
                significand = 10L * significand + (long)ch - 48L;
            }
            isSignificandTruncated = index < significandEndIndex;
            exponentOfTruncatedSignificand = virtualIndexOfPoint - index + skipCountInTruncatedDigits + expNumber;
        } else {
            isSignificandTruncated = false;
            exponentOfTruncatedSignificand = 0;
        }
        return FastFloatByteArray.valueOfFloatLiteral(str, startIndex, endIndex, isNegative, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand, rejectOverflow);
    }

    private static float parseHexFloatingPointLiteral(byte[] str, int index, int startIndex, int endIndex, boolean isNegative, boolean rejectOverflow) throws NumericException {
        boolean isSignificandTruncated;
        boolean hasExponent;
        int digitCount;
        long significand = 0L;
        int exponent = 0;
        int significandStartIndex = index;
        int virtualIndexOfPoint = -1;
        boolean illegal = false;
        byte ch = 0;
        while (index < endIndex) {
            int hexValue;
            ch = str[index];
            int n = hexValue = ch < 0 ? -1 : FastDoubleUtils.CHAR_TO_HEX_MAP[ch];
            if (hexValue >= 0) {
                significand = significand << 4 | (long)hexValue;
            } else {
                if (hexValue != -4) break;
                illegal |= virtualIndexOfPoint >= 0;
                virtualIndexOfPoint = index;
            }
            ++index;
        }
        int significandEndIndex = index;
        if (virtualIndexOfPoint < 0) {
            digitCount = significandEndIndex - significandStartIndex;
            virtualIndexOfPoint = significandEndIndex;
        } else {
            digitCount = significandEndIndex - significandStartIndex - 1;
            exponent = Math.min(virtualIndexOfPoint - index + 1, 1024) * 4;
        }
        int expNumber = 0;
        boolean bl = hasExponent = ch == 112 || ch == 80;
        if (hasExponent) {
            boolean neg_exp;
            ch = ++index < endIndex ? str[index] : (byte)0;
            boolean bl2 = neg_exp = ch == 45;
            if (neg_exp || ch == 43) {
                ch = ++index < endIndex ? str[index] : (byte)0;
            }
            illegal |= !FastFloatByteArray.isDigit(ch);
            do {
                expNumber = 10 * expNumber + ch - 48;
            } while (FastFloatByteArray.isDigit(ch = ++index < endIndex ? str[index] : (byte)0));
            if (neg_exp) {
                expNumber = -expNumber;
            }
            exponent += expNumber;
        }
        if (index < endIndex && (ch == 100 || ch == 68 || ch == 102 || ch == 70)) {
            ++index;
        }
        index = FastFloatByteArray.skipWhitespace(str, index, endIndex);
        if (illegal || index < endIndex || digitCount == 0 || !hasExponent) {
            throw NumericException.INSTANCE;
        }
        int skipCountInTruncatedDigits = 0;
        if (digitCount > 16) {
            significand = 0L;
            for (index = significandStartIndex; index < significandEndIndex; ++index) {
                int hexValue;
                ch = str[index];
                int n = hexValue = ch < 0 ? -1 : FastDoubleUtils.CHAR_TO_HEX_MAP[ch];
                if (hexValue >= 0) {
                    if (Long.compareUnsigned(significand, 1000000000000000000L) >= 0) break;
                    significand = significand << 4 | (long)hexValue;
                    continue;
                }
                ++skipCountInTruncatedDigits;
            }
            isSignificandTruncated = index < significandEndIndex;
        } else {
            isSignificandTruncated = false;
        }
        return FastFloatByteArray.valueOfHexLiteral(str, startIndex, endIndex, isNegative, significand, exponent, isSignificandTruncated, virtualIndexOfPoint - index + skipCountInTruncatedDigits + expNumber, rejectOverflow);
    }

    private static float parseInfinity(byte[] str, int index, int endIndex, boolean negative) throws NumericException {
        if (index + 7 < endIndex && str[index] == 73 && str[index + 1] == 110 && str[index + 2] == 102 && str[index + 3] == 105 && str[index + 4] == 110 && str[index + 5] == 105 && str[index + 6] == 116 && str[index + 7] == 121 && (index = FastFloatByteArray.skipWhitespace(str, index + 8, endIndex)) == endIndex) {
            return negative ? FastFloatByteArray.negativeInfinity() : FastFloatByteArray.positiveInfinity();
        }
        throw NumericException.INSTANCE;
    }

    private static float parseNaN(byte[] str, int index, int endIndex) throws NumericException {
        if (index + 2 < endIndex && str[index + 1] == 97 && str[index + 2] == 78 && (index = FastFloatByteArray.skipWhitespace(str, index + 3, endIndex)) == endIndex) {
            return FastFloatByteArray.nan();
        }
        throw NumericException.INSTANCE;
    }

    private static int skipWhitespace(byte[] str, int index, int endIndex) {
        while (index < endIndex && (str[index] & 0xFF) <= 32) {
            ++index;
        }
        return index;
    }

    private static int tryToParseEightDigits(byte[] str, int offset) {
        return FastDoubleSwar.tryToParseEightDigitsUtf8(str, offset);
    }

    static float nan() {
        return Float.NaN;
    }

    static float negativeInfinity() {
        return Float.NEGATIVE_INFINITY;
    }

    static float parseFloatingPointLiteral(byte[] str, int offset, int length, boolean rejectOverflow) throws NumericException {
        boolean hasLeadingZero;
        boolean isNegative;
        int endIndex = offset + length;
        if (offset < 0 || endIndex > str.length) {
            throw NumericException.INSTANCE;
        }
        int index = FastFloatByteArray.skipWhitespace(str, offset, endIndex);
        if (index == endIndex) {
            throw NumericException.INSTANCE;
        }
        byte ch = str[index];
        boolean bl = isNegative = ch == 45;
        if (isNegative || ch == 43) {
            byte by = ch = ++index < endIndex ? str[index] : (byte)0;
            if (ch == 0) {
                throw NumericException.INSTANCE;
            }
        }
        if (ch >= 73) {
            return ch == 78 ? FastFloatByteArray.parseNaN(str, index, endIndex) : FastFloatByteArray.parseInfinity(str, index, endIndex, isNegative);
        }
        boolean bl2 = hasLeadingZero = ch == 48;
        if (hasLeadingZero) {
            byte by = ch = ++index < endIndex ? str[index] : (byte)0;
            if (ch == 120 || ch == 88) {
                return FastFloatByteArray.parseHexFloatingPointLiteral(str, index + 1, offset, endIndex, isNegative, rejectOverflow);
            }
        }
        return FastFloatByteArray.parseDecFloatLiteral(str, index, offset, endIndex, isNegative, hasLeadingZero, rejectOverflow);
    }

    static float positiveInfinity() {
        return Float.POSITIVE_INFINITY;
    }

    static float valueOfFloatLiteral(byte[] str, int startIndex, int endIndex, boolean isNegative, long significand, int exponent, boolean isSignificandTruncated, int exponentOfTruncatedSignificand, boolean rejectOverflow) throws NumericException {
        float f = FastFloatMath.decFloatLiteralToFloat(isNegative, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand);
        if (Float.isNaN(f)) {
            f = FastFloatByteArray.fallbackToJavaParser(str, startIndex, endIndex, rejectOverflow);
        }
        return f;
    }

    static float valueOfHexLiteral(byte[] str, int startIndex, int endIndex, boolean isNegative, long significand, int exponent, boolean isSignificandTruncated, int exponentOfTruncatedSignificand, boolean rejectOverflow) throws NumericException {
        float f = FastFloatMath.hexFloatLiteralToFloat(isNegative, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand);
        if (Float.isNaN(f)) {
            f = FastFloatByteArray.fallbackToJavaParser(str, startIndex, endIndex, rejectOverflow);
        }
        return f;
    }
}

