/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.encryption;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.apache.nifi.repository.encryption.AesSecretKeyRepositoryEncryptor;
import org.apache.nifi.repository.encryption.RepositoryEncryptionException;
import org.apache.nifi.repository.encryption.configuration.EncryptionMetadataHeader;
import org.apache.nifi.repository.encryption.configuration.RepositoryEncryptionMethod;
import org.apache.nifi.repository.encryption.metadata.RecordMetadata;
import org.apache.nifi.security.kms.KeyProvider;

public class AesCtrStreamRepositoryEncryptor
extends AesSecretKeyRepositoryEncryptor<OutputStream, InputStream> {
    public AesCtrStreamRepositoryEncryptor(KeyProvider keyProvider, EncryptionMetadataHeader encryptionMetadataHeader) {
        super(RepositoryEncryptionMethod.AES_CTR, keyProvider, encryptionMetadataHeader);
    }

    @Override
    public InputStream decrypt(InputStream record, String recordId) {
        RecordMetadata metadata = this.readMetadata(record);
        Cipher cipher = this.getDecryptionCipher(metadata.getKeyId(), metadata.getInitializationVector());
        return new CipherInputStream(record, cipher);
    }

    @Override
    protected OutputStream encrypt(OutputStream record, String recordId, String keyId, Cipher cipher) {
        try {
            byte[] serializedMetadata = this.getMetadata(keyId, cipher.getIV());
            record.write(serializedMetadata);
            record.flush();
            return new CipherOutputStream(record, cipher);
        }
        catch (IOException e) {
            throw new RepositoryEncryptionException(String.format("Encryption Failed for Record ID [%s]", recordId), e);
        }
    }
}

