/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.reporting;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.resource.ResourceContext;
import org.apache.nifi.components.resource.ResourceReferenceFactory;
import org.apache.nifi.components.resource.StandardResourceContext;
import org.apache.nifi.components.resource.StandardResourceReferenceFactory;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.reporting.Severity;

public abstract class AbstractReportingContext
implements ReportingContext {
    private final ReportingTaskNode reportingTaskNode;
    private final BulletinRepository bulletinRepository;
    private final ControllerServiceProvider serviceProvider;
    private final Map<PropertyDescriptor, String> properties;
    private final Map<PropertyDescriptor, PreparedQuery> preparedQueries;
    private final ParameterLookup parameterLookup;
    private final VariableRegistry variableRegistry;

    public AbstractReportingContext(ReportingTaskNode reportingTaskNode, BulletinRepository bulletinRepository, Map<PropertyDescriptor, String> properties, ControllerServiceProvider controllerServiceProvider, ParameterLookup parameterLookup, VariableRegistry variableRegistry) {
        this.bulletinRepository = bulletinRepository;
        this.properties = Collections.unmodifiableMap(properties);
        this.serviceProvider = controllerServiceProvider;
        this.reportingTaskNode = reportingTaskNode;
        this.parameterLookup = parameterLookup;
        this.variableRegistry = variableRegistry;
        this.preparedQueries = new HashMap<PropertyDescriptor, PreparedQuery>();
        for (Map.Entry<PropertyDescriptor, String> entry : properties.entrySet()) {
            PropertyDescriptor desc = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                value = desc.getDefaultValue();
            }
            PreparedQuery pq = Query.prepare((String)value);
            this.preparedQueries.put(desc, pq);
        }
    }

    protected ReportingTask getReportingTask() {
        return this.reportingTaskNode.getReportingTask();
    }

    public BulletinRepository getBulletinRepository() {
        return this.bulletinRepository;
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        PropertyDescriptor descriptor = this.reportingTaskNode.getPropertyDescriptor(property.getName());
        if (descriptor == null) {
            return null;
        }
        String configuredValue = this.properties.get(property);
        StandardResourceContext resourceContext = new StandardResourceContext((ResourceReferenceFactory)new StandardResourceReferenceFactory(), descriptor);
        return new StandardPropertyValue((ResourceContext)resourceContext, configuredValue == null ? descriptor.getDefaultValue() : configuredValue, (ControllerServiceLookup)this.serviceProvider, this.parameterLookup, this.preparedQueries.get(property), this.variableRegistry);
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this.serviceProvider;
    }

    public Bulletin createBulletin(String category, Severity severity, String message) {
        return BulletinFactory.createBulletin((String)category, (String)severity.name(), (String)message);
    }

    public Bulletin createBulletin(String componentId, String category, Severity severity, String message) {
        Connectable connectable = this.getFlowManager().findConnectable(componentId);
        if (connectable == null) {
            throw new IllegalStateException("Cannot create Component-Level Bulletin because no component can be found with ID " + componentId);
        }
        return BulletinFactory.createBulletin((Connectable)connectable, (String)category, (String)severity.name(), (String)message);
    }

    protected abstract FlowManager getFlowManager();
}

