/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.gc;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.LongArrayList;
import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.core.dataStructures.hash.PackedLongHashSet;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessorAdapter;
import jetbrains.exodus.core.execution.LatchJob;
import jetbrains.exodus.core.execution.SharedTimer;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.ReadWriteTransaction;
import jetbrains.exodus.env.ReadonlyTransactionException;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.TransactionAcquireTimeoutException;
import jetbrains.exodus.gc.BackgroundCleaner;
import jetbrains.exodus.gc.GcJob;
import jetbrains.exodus.gc.PeriodicGc;
import jetbrains.exodus.gc.UtilizationProfile;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.io.DataWriter;
import jetbrains.exodus.io.RemoveBlockType;
import jetbrains.exodus.log.AbstractBlockListener;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogUtil;
import jetbrains.exodus.log.LoggableIterator;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.runtime.OOMGuard;
import jetbrains.exodus.tree.ExpiredLoggableCollection;
import jetbrains.exodus.util.DeferredIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 X2\u00020\u0001:\u0001XB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u000200J\u001b\u00104\u001a\u00020\u00112\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000b06H\u0000\u00a2\u0006\u0002\b7J\u0018\u00108\u001a\u0002002\u0006\u00109\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020;H\u0002J\u0006\u0010<\u001a\u000200J\r\u0010=\u001a\u000200H\u0000\u00a2\u0006\u0002\b>J\u000e\u0010?\u001a\u00020\u00112\u0006\u00109\u001a\u00020\u000bJ\u0016\u0010@\u001a\u00020\u00112\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000b06H\u0002J\u000e\u0010A\u001a\u0002002\u0006\u0010B\u001a\u00020CJ\u0006\u0010D\u001a\u000200J\u0006\u0010E\u001a\u00020FJ\u000e\u0010G\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u000bJ\u0015\u0010H\u001a\u00020\u00112\u0006\u0010I\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\bJJ\u0010\u0010K\u001a\u0002002\u0006\u0010L\u001a\u00020(H\u0002J\u0006\u0010M\u001a\u000200J\u000e\u0010N\u001a\u0002002\u0006\u0010O\u001a\u00020FJ\u0006\u0010P\u001a\u000200J\u0006\u0010Q\u001a\u000200J\u0006\u0010R\u001a\u000200J\u0010\u0010S\u001a\u0002002\b\b\u0002\u0010T\u001a\u00020\u0011J\u0015\u0010U\u001a\u0002002\u0006\u0010V\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\bWR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0015\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u001f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0017R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u0006Y"}, d2={"Ljetbrains/exodus/gc/GarbageCollector;", "", "environment", "Ljetbrains/exodus/env/EnvironmentImpl;", "(Ljetbrains/exodus/env/EnvironmentImpl;)V", "cleaner", "Ljetbrains/exodus/gc/BackgroundCleaner;", "getCleaner$xodus_environment", "()Ljetbrains/exodus/gc/BackgroundCleaner;", "deletionQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "", "ec", "Ljetbrains/exodus/env/EnvironmentConfig;", "getEnvironment$xodus_environment", "()Ljetbrains/exodus/env/EnvironmentImpl;", "isSuspended", "", "()Z", "isTooMuchFreeSpace", "isTooMuchFreeSpace$xodus_environment", "lastInvocationTime", "getLastInvocationTime", "()J", "setLastInvocationTime", "(J)V", "log", "Ljetbrains/exodus/log/Log;", "getLog$xodus_environment", "()Ljetbrains/exodus/log/Log;", "maximumFreeSpacePercent", "", "getMaximumFreeSpacePercent$xodus_environment", "()I", "minFileAge", "getMinFileAge$xodus_environment", "openStoresCache", "Ljetbrains/exodus/core/dataStructures/hash/IntHashMap;", "Ljetbrains/exodus/env/StoreImpl;", "pendingFilesToDelete", "Ljetbrains/exodus/core/dataStructures/hash/PackedLongHashSet;", "startTime", "getStartTime$xodus_environment", "utilizationProfile", "Ljetbrains/exodus/gc/UtilizationProfile;", "getUtilizationProfile", "()Ljetbrains/exodus/gc/UtilizationProfile;", "addBeforeGcAction", "", "action", "Ljava/lang/Runnable;", "cleanEntireLog", "cleanFiles", "fragmentedFiles", "", "cleanFiles$xodus_environment", "cleanSingleFile", "fileAddress", "txn", "Ljetbrains/exodus/env/ReadWriteTransaction;", "clear", "deletePendingFiles", "deletePendingFiles$xodus_environment", "doCleanFile", "doCleanFiles", "fetchExpiredLoggables", "loggables", "Ljetbrains/exodus/tree/ExpiredLoggableCollection;", "finish", "getCleanerJobProcessor", "Ljetbrains/exodus/core/execution/JobProcessorAdapter;", "getFileFreeBytes", "isFileCleaned", "file", "isFileCleaned$xodus_environment", "queueDeletionOfFiles", "cleanedFiles", "resume", "setCleanerJobProcessor", "processor", "suspend", "testDeletePendingFiles", "waitForPendingGC", "wake", "estimateTotalUtilization", "wakeAt", "millis", "wakeAt$xodus_environment", "Companion", "xodus-environment"})
public final class GarbageCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnvironmentImpl environment;
    private long lastInvocationTime;
    @NotNull
    private final EnvironmentConfig ec;
    @NotNull
    private final UtilizationProfile utilizationProfile;
    @NotNull
    private final PackedLongHashSet pendingFilesToDelete;
    @NotNull
    private final ConcurrentLinkedQueue<Long> deletionQueue;
    @NotNull
    private final BackgroundCleaner cleaner;
    @NotNull
    private final IntHashMap<StoreImpl> openStoresCache;
    @NotNull
    public static final String UTILIZATION_PROFILE_STORE_NAME = "exodus.gc.up";

    public GarbageCollector(@NotNull EnvironmentImpl environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.environment = environment;
        EnvironmentConfig environmentConfig = this.environment.getEnvironmentConfig();
        Intrinsics.checkNotNullExpressionValue((Object)environmentConfig, (String)"environment.environmentConfig");
        this.ec = environmentConfig;
        this.utilizationProfile = new UtilizationProfile(this.environment, this);
        this.pendingFilesToDelete = new PackedLongHashSet(null, 0.0f, 3, null);
        this.deletionQueue = new ConcurrentLinkedQueue();
        this.cleaner = new BackgroundCleaner(this);
        this.openStoresCache = new IntHashMap();
        this.environment.getLog().addBlockListener(new AbstractBlockListener(){

            @Override
            public void blockCreated(@NotNull Block block, @NotNull DataReader reader, @NotNull DataWriter writer) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                this.getUtilizationProfile().estimateTotalBytes$xodus_environment();
                if (!this.getCleaner$xodus_environment().isCleaning() && this.isTooMuchFreeSpace$xodus_environment()) {
                    GarbageCollector.wake$default(this, false, 1, null);
                }
            }
        });
        SharedTimer.registerPeriodicTask((SharedTimer.ExpirablePeriodicTask)new PeriodicGc(this));
    }

    @NotNull
    public final EnvironmentImpl getEnvironment$xodus_environment() {
        return this.environment;
    }

    public final long getLastInvocationTime() {
        return this.lastInvocationTime;
    }

    public final void setLastInvocationTime(long l) {
        this.lastInvocationTime = l;
    }

    @NotNull
    public final UtilizationProfile getUtilizationProfile() {
        return this.utilizationProfile;
    }

    @NotNull
    public final BackgroundCleaner getCleaner$xodus_environment() {
        return this.cleaner;
    }

    public final int getMaximumFreeSpacePercent$xodus_environment() {
        return 100 - this.ec.getGcMinUtilization();
    }

    public final boolean isTooMuchFreeSpace$xodus_environment() {
        return this.utilizationProfile.totalFreeSpacePercent$xodus_environment() > this.getMaximumFreeSpacePercent$xodus_environment();
    }

    public final int getMinFileAge$xodus_environment() {
        return this.ec.getGcFileMinAge();
    }

    @NotNull
    public final Log getLog$xodus_environment() {
        Log log = this.environment.getLog();
        Intrinsics.checkNotNullExpressionValue((Object)log, (String)"environment.log");
        return log;
    }

    public final long getStartTime$xodus_environment() {
        return this.environment.getCreated() + (long)this.ec.getGcStartIn();
    }

    public final boolean isSuspended() {
        return this.cleaner.isSuspended();
    }

    public final void clear() {
        this.utilizationProfile.clear$xodus_environment();
        this.pendingFilesToDelete.clear();
        this.deletionQueue.clear();
        this.openStoresCache.clear();
    }

    @NotNull
    public final JobProcessorAdapter getCleanerJobProcessor() {
        return this.cleaner.getJobProcessor();
    }

    public final void setCleanerJobProcessor(@NotNull JobProcessorAdapter processor) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        this.getCleanerJobProcessor().queue(new Job(this, processor){
            final /* synthetic */ GarbageCollector this$0;
            final /* synthetic */ JobProcessorAdapter $processor;
            {
                this.this$0 = $receiver;
                this.$processor = $processor;
            }

            protected void execute() {
                this.this$0.getCleaner$xodus_environment().setJobProcessor(this.$processor);
                this.this$0.wake(true);
            }
        }, Priority.highest);
    }

    public final void addBeforeGcAction(@NotNull Runnable action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.cleaner.addBeforeGcAction(action);
    }

    public final void wake(boolean estimateTotalUtilization) {
        if (this.ec.isGcEnabled()) {
            this.environment.executeTransactionSafeTask(() -> GarbageCollector.wake$lambda-0(estimateTotalUtilization, this));
        }
    }

    public static /* synthetic */ void wake$default(GarbageCollector garbageCollector, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        garbageCollector.wake(bl);
    }

    public final void wakeAt$xodus_environment(long millis) {
        if (this.ec.isGcEnabled()) {
            this.cleaner.queueCleaningJobAt(millis);
        }
    }

    public final void fetchExpiredLoggables(@NotNull ExpiredLoggableCollection loggables) {
        Intrinsics.checkNotNullParameter((Object)loggables, (String)"loggables");
        if (loggables.getFromScratch()) {
            this.utilizationProfile.computeUtilizationFromScratch();
        } else {
            this.utilizationProfile.fetchExpiredLoggables$xodus_environment(loggables);
        }
    }

    public final long getFileFreeBytes(long fileAddress) {
        return this.utilizationProfile.getFileFreeBytes$xodus_environment(fileAddress);
    }

    public final void suspend() {
        this.cleaner.suspend();
    }

    public final void resume() {
        this.cleaner.resume();
    }

    public final void finish() {
        this.cleaner.finish();
    }

    public final boolean doCleanFile(long fileAddress) {
        return this.doCleanFiles(SetsKt.setOf((Object)fileAddress).iterator());
    }

    public final boolean cleanFiles$xodus_environment(@NotNull Iterator<Long> fragmentedFiles) {
        Intrinsics.checkNotNullParameter(fragmentedFiles, (String)"fragmentedFiles");
        this.cleaner.checkThread();
        return this.doCleanFiles(fragmentedFiles);
    }

    public final boolean isFileCleaned$xodus_environment(long file) {
        return this.pendingFilesToDelete.contains((Object)file);
    }

    public final void waitForPendingGC() {
        this.getCleanerJobProcessor().waitForLatchJob(new LatchJob(){

            protected void execute() {
                this.release();
            }
        }, 100L, Priority.lowest);
    }

    public final void cleanEntireLog() {
        this.cleaner.cleanEntireLog();
    }

    public final void testDeletePendingFiles() {
        long[] files = this.pendingFilesToDelete.toLongArray();
        boolean aFileWasDeleted = false;
        long[] currentFile = new long[1];
        for (long file : files) {
            this.utilizationProfile.removeFile$xodus_environment(file);
            currentFile[0] = file;
            this.environment.removeFiles(currentFile, this.ec.getGcRenameFiles() ? RemoveBlockType.Rename : RemoveBlockType.Delete);
            aFileWasDeleted = true;
        }
        if (aFileWasDeleted) {
            this.pendingFilesToDelete.clear();
            this.utilizationProfile.estimateTotalBytes$xodus_environment();
        }
    }

    public final void deletePendingFiles$xodus_environment() {
        if (!this.cleaner.isCurrentThread()) {
            this.getCleanerJobProcessor().queue((Job)new GcJob(this, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ GarbageCollector this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.deletePendingFiles$xodus_environment();
                }
            })));
        } else {
            LongArrayList filesToDelete = new LongArrayList();
            while (true) {
                long l;
                Long l2 = this.deletionQueue.poll();
                if (l2 == null) break;
                long $this$deletePendingFiles_u24lambda_u2d1 = l = l2.longValue();
                boolean bl = false;
                if (this.pendingFilesToDelete.remove((Object)$this$deletePendingFiles_u24lambda_u2d1)) {
                    filesToDelete.add($this$deletePendingFiles_u24lambda_u2d1);
                }
            }
            if (!filesToDelete.isEmpty()) {
                this.environment.flushAndSync();
                long[] filesArray = filesToDelete.toArray();
                this.environment.removeFiles(filesArray, this.ec.getGcRenameFiles() ? RemoveBlockType.Rename : RemoveBlockType.Delete);
                Intrinsics.checkNotNullExpressionValue((Object)filesArray, (String)"filesArray");
                long[] $this$forEach$iv = filesArray;
                boolean $i$f$forEach = false;
                for (long element$iv : $this$forEach$iv) {
                    long it = element$iv;
                    boolean bl = false;
                    this.getUtilizationProfile().removeFile$xodus_environment(it);
                }
                this.utilizationProfile.estimateTotalBytesAndWakeGcIfNecessary$xodus_environment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doCleanFiles(Iterator<Long> fragmentedFiles) {
        ReadWriteTransaction readWriteTransaction;
        if (!fragmentedFiles.hasNext()) {
            return true;
        }
        OOMGuard guard = new OOMGuard(0, false, 1, null);
        try {
            readWriteTransaction = this.environment.beginGCTransaction();
            Intrinsics.checkNotNullExpressionValue((Object)readWriteTransaction, (String)"{\n            environmen\u2026GCTransaction()\n        }");
        }
        catch (ReadonlyTransactionException _) {
            return false;
        }
        catch (TransactionAcquireTimeoutException _) {
            return false;
        }
        ReadWriteTransaction txn = readWriteTransaction;
        PackedLongHashSet cleanedFiles = new PackedLongHashSet(null, 0.0f, 3, null);
        boolean isTxnExclusive = txn.isExclusive();
        try {
            long started = System.currentTimeMillis();
            while (fragmentedFiles.hasNext()) {
                long file = ((Number)fragmentedFiles.next()).longValue();
                boolean bl = false;
                this.cleanSingleFile(file, txn);
                cleanedFiles.add(file);
                if (isTxnExclusive && started + (long)this.ec.getGcTransactionTimeout() > System.currentTimeMillis() && !guard.isItCloseToOOM()) continue;
            }
            if (!txn.forceFlush()) {
                if (isTxnExclusive) {
                    throw new ExodusException("Can't be: exclusive txn should be successfully flushed");
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (ReadonlyTransactionException _) {
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            RuntimeException runtimeException = ExodusException.toExodusException((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)runtimeException, (String)"toExodusException(e)");
            throw (Throwable)runtimeException;
        }
        finally {
            txn.abort();
        }
        if (!((Collection)cleanedFiles).isEmpty()) {
            for (Long file : cleanedFiles) {
                if (isTxnExclusive) {
                    Log log = this.getLog$xodus_environment();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                    Log.clearFileFromLogCache$default(log, file, 0L, 2, null);
                }
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                this.pendingFilesToDelete.add(file.longValue());
                this.utilizationProfile.resetFile$xodus_environment(file);
            }
            this.utilizationProfile.estimateTotalBytes$xodus_environment();
            this.environment.executeTransactionSafeTask(() -> GarbageCollector.doCleanFiles$lambda-4(this, cleanedFiles));
        }
        return true;
    }

    private final void queueDeletionOfFiles(PackedLongHashSet cleanedFiles) {
        for (Long file : cleanedFiles) {
            this.deletionQueue.offer(file);
        }
        this.deletePendingFiles$xodus_environment();
    }

    private final void cleanSingleFile(long fileAddress, ReadWriteTransaction txn) {
        Object object;
        Object object2;
        if (this.isFileCleaned$xodus_environment(fileAddress)) {
            throw new ExodusException("Attempt to clean already cleaned file");
        }
        Companion.loggingInfo$xodus_environment((Function0<String>)((Function0)new Function0<String>(this, fileAddress){
            final /* synthetic */ GarbageCollector this$0;
            final /* synthetic */ long $fileAddress;
            {
                this.this$0 = $receiver;
                this.$fileAddress = $fileAddress;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "start cleanFile(" + this.this$0.getEnvironment$xodus_environment().getLocation() + File.separatorChar + LogUtil.getLogFilename(this.$fileAddress) + "), free bytes = " + GarbageCollector.Companion.formatBytes$xodus_environment(this.this$0.getFileFreeBytes(this.$fileAddress));
            }
        }));
        Log log = this.getLog$xodus_environment();
        if (Companion.getLogger().isDebugEnabled()) {
            long high = log.getHighAddress();
            long highFile = log.getHighFileAddress();
            KLogger kLogger = Companion.getLogger();
            String string = "Cleaner acquired txn when log high address was: %d (%s@%d) when cleaning file %s";
            object2 = new Object[]{high, LogUtil.getLogFilename(highFile), high - highFile, LogUtil.getLogFilename(fileAddress)};
            object = String.format(string, Arrays.copyOf(object2, ((Object[])object2).length));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"format(format, *args)");
            kLogger.debug((String)object);
        }
        try {
            RandomAccessLoggable loggable;
            long nextFileAddress = fileAddress + log.getFileLengthBound();
            LoggableIterator loggables = log.getLoggableIterator(fileAddress);
            while (loggables.hasNext() && (loggable = loggables.next()) != null && loggable.getAddress() < nextFileAddress) {
                int structureId = loggable.getStructureId();
                if (structureId == 0 || structureId == 1) continue;
                StoreImpl store = (StoreImpl)this.openStoresCache.get(structureId);
                if (store == null) {
                    store = txn.openStoreByStructureId(structureId);
                    object2 = (Map)this.openStoresCache;
                    object = structureId;
                    object2.put(object, store);
                }
                store.reclaim(txn, loggable, loggables);
            }
        }
        catch (Throwable e) {
            Companion.getLogger().error("cleanFile(" + LogUtil.getLogFilename(fileAddress) + ')', e);
            throw e;
        }
    }

    private static final void wake$lambda-0(boolean $estimateTotalUtilization, GarbageCollector this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($estimateTotalUtilization) {
            this$0.utilizationProfile.estimateTotalBytes$xodus_environment();
        }
        this$0.cleaner.queueCleaningJob();
    }

    private static final void doCleanFiles$lambda-4(GarbageCollector this$0, PackedLongHashSet $cleanedFiles) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cleanedFiles, (String)"$cleanedFiles");
        int filesDeletionDelay = this$0.ec.getGcFilesDeletionDelay();
        if (filesDeletionDelay == 0) {
            this$0.queueDeletionOfFiles($cleanedFiles);
        } else {
            DeferredIO.getJobProcessor().queueIn(new Job(this$0, $cleanedFiles){
                final /* synthetic */ GarbageCollector this$0;
                final /* synthetic */ PackedLongHashSet $cleanedFiles;
                {
                    this.this$0 = $receiver;
                    this.$cleanedFiles = $cleanedFiles;
                }

                protected void execute() {
                    GarbageCollector.access$queueDeletionOfFiles(this.this$0, this.$cleanedFiles);
                }
            }, (long)filesDeletionDelay);
        }
    }

    @JvmStatic
    public static final boolean isUtilizationProfile(@NotNull String storeName) {
        return Companion.isUtilizationProfile(storeName);
    }

    public static final /* synthetic */ void access$queueDeletionOfFiles(GarbageCollector $this, PackedLongHashSet cleanedFiles) {
        $this.queueDeletionOfFiles(cleanedFiles);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u001b\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0000\u00a2\u0006\u0002\b\u0010J%\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0000\u00a2\u0006\u0002\b\u0014J\u001b\u0010\u0015\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0000\u00a2\u0006\u0002\b\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ljetbrains/exodus/gc/GarbageCollector$Companion;", "Lmu/KLogging;", "()V", "UTILIZATION_PROFILE_STORE_NAME", "", "formatBytes", "bytes", "", "formatBytes$xodus_environment", "isUtilizationProfile", "", "storeName", "loggingDebug", "", "message", "Lkotlin/Function0;", "loggingDebug$xodus_environment", "loggingError", "t", "", "loggingError$xodus_environment", "loggingInfo", "loggingInfo$xodus_environment", "xodus-environment"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        @JvmStatic
        public final boolean isUtilizationProfile(@NotNull String storeName) {
            Intrinsics.checkNotNullParameter((Object)storeName, (String)"storeName");
            return Intrinsics.areEqual((Object)GarbageCollector.UTILIZATION_PROFILE_STORE_NAME, (Object)storeName);
        }

        public final void loggingInfo$xodus_environment(@NotNull Function0<String> message) {
            Intrinsics.checkNotNullParameter(message, (String)"message");
            this.getLogger().info((Function0)new Function0<Object>(message){
                final /* synthetic */ Function0<String> $message;
                {
                    this.$message = $message;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$message.invoke();
                }
            });
        }

        public final void loggingError$xodus_environment(@Nullable Throwable t, @NotNull Function0<String> message) {
            Intrinsics.checkNotNullParameter(message, (String)"message");
            if (t == null) {
                this.getLogger().error((Function0)new Function0<Object>(message){
                    final /* synthetic */ Function0<String> $message;
                    {
                        this.$message = $message;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return this.$message.invoke();
                    }
                });
            } else {
                this.getLogger().error(t, (Function0)new Function0<Object>(message){
                    final /* synthetic */ Function0<String> $message;
                    {
                        this.$message = $message;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return this.$message.invoke();
                    }
                });
            }
        }

        public final void loggingDebug$xodus_environment(@NotNull Function0<String> message) {
            Intrinsics.checkNotNullParameter(message, (String)"message");
            this.getLogger().debug((Function0)new Function0<Object>(message){
                final /* synthetic */ Function0<String> $message;
                {
                    this.$message = $message;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$message.invoke();
                }
            });
        }

        @NotNull
        public final String formatBytes$xodus_environment(long bytes) {
            return bytes == Long.MAX_VALUE ? "Unknown" : bytes / (long)1000 + "Kb";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

