/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.service.mapper;

import java.util.Date;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.db.entity.BucketEntity;

public class BucketMappings {
    public static BucketEntity map(Bucket bucket) {
        BucketEntity bucketEntity = new BucketEntity();
        bucketEntity.setId(bucket.getIdentifier());
        bucketEntity.setName(bucket.getName());
        bucketEntity.setDescription(bucket.getDescription());
        bucketEntity.setCreated(new Date(bucket.getCreatedTimestamp()));
        bucketEntity.setAllowExtensionBundleRedeploy(bucket.isAllowBundleRedeploy());
        bucketEntity.setAllowPublicRead(bucket.isAllowPublicRead());
        return bucketEntity;
    }

    public static Bucket map(BucketEntity bucketEntity) {
        Bucket bucket = new Bucket();
        bucket.setIdentifier(bucketEntity.getId());
        bucket.setName(bucketEntity.getName());
        bucket.setDescription(bucketEntity.getDescription());
        bucket.setCreatedTimestamp(bucketEntity.getCreated().getTime());
        bucket.setAllowBundleRedeploy(Boolean.valueOf(bucketEntity.isAllowExtensionBundleRedeploy()));
        bucket.setAllowPublicRead(Boolean.valueOf(bucketEntity.isAllowPublicRead()));
        return bucket;
    }
}

