/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexwriter.rabbit;

import com.google.gson.Gson;
import java.util.LinkedList;
import java.util.List;
import org.apache.nutch.indexwriter.rabbit.RabbitDocument;

class RabbitMessage {
    private List<RabbitDocument> docsToWrite = new LinkedList<RabbitDocument>();
    private List<RabbitDocument> docsToUpdate = new LinkedList<RabbitDocument>();
    private List<String> docsToDelete = new LinkedList<String>();

    RabbitMessage() {
    }

    boolean addDocToWrite(RabbitDocument doc) {
        return this.docsToWrite.add(doc);
    }

    boolean addDocToUpdate(RabbitDocument doc) {
        return this.docsToUpdate.add(doc);
    }

    boolean addDocToDelete(String url) {
        return this.docsToDelete.add(url);
    }

    byte[] getBytes() {
        Gson gson = new Gson();
        return gson.toJson((Object)this).getBytes();
    }

    boolean isEmpty() {
        return this.docsToWrite.isEmpty() && this.docsToUpdate.isEmpty() && this.docsToDelete.isEmpty();
    }

    public List<RabbitDocument> getDocsToWrite() {
        return this.docsToWrite;
    }

    public List<RabbitDocument> getDocsToUpdate() {
        return this.docsToUpdate;
    }

    public List<String> getDocsToDelete() {
        return this.docsToDelete;
    }

    public int size() {
        return this.docsToWrite.size() + this.docsToUpdate.size() + this.docsToDelete.size();
    }

    public void clear() {
        this.docsToWrite.clear();
        this.docsToUpdate.clear();
        this.docsToDelete.clear();
    }
}

