/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.interfaces.strategies.collections.set;

import de.vandermeer.skb.interfaces.strategies.collections.IsSetStrategy;
import java.util.Collection;
import java.util.LinkedHashSet;

public interface LinkedHashSetStrategy<T>
extends IsSetStrategy<LinkedHashSet<T>, T> {
    @Override
    default public LinkedHashSet<T> get(Collection<T> collection) {
        if (collection == null) {
            return new LinkedHashSet();
        }
        return new LinkedHashSet<T>(collection);
    }

    @Override
    default public LinkedHashSet<T> get() {
        return new LinkedHashSet();
    }

    public static <T> LinkedHashSetStrategy<T> create() {
        return new LinkedHashSetStrategy<T>(){};
    }
}

