/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.AddSeleniumUserAgent;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.RetryRequest;

public class ClientConfig {
    private static final Filter RETRY_FILTER = new RetryRequest();
    private static final Filter DEFAULT_FILTER = new AddSeleniumUserAgent();
    private final URI baseUri;
    private final Duration connectionTimeout;
    private final Duration readTimeout;
    private final Filter filters;
    private final Proxy proxy;
    private final Credentials credentials;

    protected ClientConfig(URI baseUri, Duration connectionTimeout, Duration readTimeout, Filter filters, Proxy proxy, Credentials credentials) {
        this.baseUri = baseUri;
        this.connectionTimeout = Require.nonNegative((String)"Connection timeout", (Duration)connectionTimeout);
        this.readTimeout = Require.nonNegative((String)"Read timeout", (Duration)readTimeout);
        this.filters = (Filter)Require.nonNull((String)"Filters", (Object)filters);
        this.proxy = proxy;
        this.credentials = credentials;
    }

    public static ClientConfig defaultConfig() {
        return new ClientConfig(null, Duration.ofSeconds(10L), Duration.ofMinutes(3L), DEFAULT_FILTER, null, null);
    }

    public ClientConfig baseUri(URI baseUri) {
        return new ClientConfig((URI)Require.nonNull((String)"Base URI", (Object)baseUri), this.connectionTimeout, this.readTimeout, this.filters, this.proxy, this.credentials);
    }

    public ClientConfig baseUrl(URL baseUrl) {
        try {
            return this.baseUri(((URL)Require.nonNull((String)"Base URL", (Object)baseUrl)).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URI baseUri() {
        return this.baseUri;
    }

    public URL baseUrl() {
        try {
            return this.baseUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ClientConfig connectionTimeout(Duration timeout) {
        return new ClientConfig(this.baseUri, (Duration)Require.nonNull((String)"Connection timeout", (Object)timeout), this.readTimeout, this.filters, this.proxy, this.credentials);
    }

    public Duration connectionTimeout() {
        return this.connectionTimeout;
    }

    public ClientConfig readTimeout(Duration timeout) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, (Duration)Require.nonNull((String)"Read timeout", (Object)timeout), this.filters, this.proxy, this.credentials);
    }

    public Duration readTimeout() {
        return this.readTimeout;
    }

    public ClientConfig withFilter(Filter filter) {
        Require.nonNull((String)"Filter", (Object)filter);
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, filter.andThen(DEFAULT_FILTER), this.proxy, this.credentials);
    }

    public ClientConfig withRetries() {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, this.filters.andThen(RETRY_FILTER), this.proxy, this.credentials);
    }

    public Filter filter() {
        return this.filters;
    }

    public ClientConfig proxy(Proxy proxy) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, this.filters, (Proxy)Require.nonNull((String)"Proxy", (Object)proxy), this.credentials);
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public ClientConfig authenticateAs(Credentials credentials) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, this.filters, this.proxy, (Credentials)Require.nonNull((String)"Credentials", (Object)credentials));
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public String toString() {
        return "ClientConfig{baseUri=" + this.baseUri + ", connectionTimeout=" + this.connectionTimeout + ", readTimeout=" + this.readTimeout + ", filters=" + this.filters + ", proxy=" + this.proxy + ", credentials=" + this.credentials + '}';
    }
}

